import qbs.base 1.0
import "../../QtcLibrary.qbs" as QtcLibrary

QtcLibrary {
    name: "Botan"

    Depends { name: "cpp" }
    Depends { name: "qt"; submodules: 'core' }

    cpp.includePaths: ["build", "src"]
    cpp.dynamicLibraries: {
        if (qbs.targetOS == 'linux' || qbs.targetOS == 'freebsd') {
            return ['rt']
        }
        else if (qbs.targetOS == 'windows') {
            return [
                "advapi32",
                "user32"
            ]
        }
    }

    cpp.defines: {
        var result = []
        if (qbs.toolchain == 'msvc2005' || qbs.toolchain == 'msvc2008' || qbs.toolchain == 'msvc2010')
            result.push('BOTAN_DLL=__declspec(dllexport)')
        return result
    }

    Properties {
        condition: qbs.toolchain === 'mingw'
        cpp.cxxFlags: [
            '-fpermissive',
            '-finline-functions',
            '-Wno-long-long'
        ]
    }

    files: [
        "src/algo_factory/algo_cache.h",
        "src/algo_factory/algo_factory.h",
        "src/alloc/allocate.h",
        "src/alloc/mem_pool/mem_pool.h",
        "src/alloc/secmem.h",
        "src/alloc/system_alloc/defalloc.h",
        "src/asn1/alg_id.h",
        "src/asn1/asn1_int.h",
        "src/asn1/asn1_obj.h",
        "src/asn1/asn1_oid.h",
        "src/asn1/ber_dec.h",
        "src/asn1/der_enc.h",
        "src/benchmark/benchmark.h",
        "src/block/aes/aes.h",
        "src/block/block_cipher.h",
        "src/block/blowfish/blowfish.h",
        "src/block/cast/cast128.h",
        "src/block/cast/cast256.h",
        "src/block/des/des.h",
        "src/block/des/desx.h",
        "src/block/gost_28147/gost_28147.h",
        "src/block/idea/idea.h",
        "src/block/kasumi/kasumi.h",
        "src/block/lion/lion.h",
        "src/block/lubyrack/lubyrack.h",
        "src/block/mars/mars.h",
        "src/block/misty1/misty1.h",
        "src/block/noekeon/noekeon.h",
        "src/block/rc2/rc2.h",
        "src/block/rc5/rc5.h",
        "src/block/rc6/rc6.h",
        "src/block/safer/safer_sk.h",
        "src/block/seed/seed.h",
        "src/block/serpent/serpent.h",
        "src/block/skipjack/skipjack.h",
        "src/block/square/square.h",
        "src/block/tea/tea.h",
        "src/block/twofish/twofish.h",
        "src/block/xtea/xtea.h",
        "src/cert/x509/certstor.h",
        "src/cert/x509/crl_ent.h",
        "src/cert/x509/pkcs10.h",
        "src/cert/x509/x509_ca.h",
        "src/cert/x509/x509_crl.h",
        "src/cert/x509/x509_ext.h",
        "src/cert/x509/x509_obj.h",
        "src/cert/x509/x509cert.h",
        "src/cert/x509/x509find.h",
        "src/cert/x509/x509self.h",
        "src/cert/x509/x509stor.h",
        "src/checksum/adler32/adler32.h",
        "src/checksum/crc24/crc24.h",
        "src/checksum/crc32/crc32.h",
        "src/cms/cms_dec.h",
        "src/cms/cms_enc.h",
        "src/codec/base64/base64.h",
        "src/codec/hex/hex.h",
        "src/codec/openpgp/openpgp.h",
        "src/codec/pem/pem.h",
        "src/cryptobox/cryptobox.h",
        "src/engine/def_engine/def_eng.h",
        "src/engine/engine.h",
        "src/entropy/entropy_src.h",
        "src/filters/basefilt.h",
        "src/filters/buf_filt.h",
        "src/filters/data_snk.h",
        "src/filters/data_src.h",
        "src/filters/filter.h",
        "src/filters/filters.h",
        "src/filters/out_buf.h",
        "src/filters/pbe.h",
        "src/filters/pipe.h",
        "src/filters/secqueue.h",
        "src/hash/fork256/fork256.h",
        "src/hash/gost_3411/gost_3411.h",
        "src/hash/has160/has160.h",
        "src/hash/hash.h",
        "src/hash/md2/md2.h",
        "src/hash/md4/md4.h",
        "src/hash/md5/md5.h",
        "src/hash/mdx_hash/mdx_hash.h",
        "src/hash/par_hash/par_hash.h",
        "src/hash/rmd128/rmd128.h",
        "src/hash/rmd160/rmd160.h",
        "src/hash/sha1/sha160.h",
        "src/hash/sha2/sha2_32.h",
        "src/hash/sha2/sha2_64.h",
        "src/hash/skein/skein_512.h",
        "src/hash/tiger/tiger.h",
        "src/hash/whirlpool/whrlpool.h",
        "src/kdf/kdf.h",
        "src/kdf/kdf1/kdf1.h",
        "src/kdf/kdf2/kdf2.h",
        "src/kdf/mgf1/mgf1.h",
        "src/kdf/ssl_prf/prf_ssl3.h",
        "src/kdf/tls_prf/prf_tls.h",
        "src/kdf/x942_prf/prf_x942.h",
        "src/libstate/botan.h",
        "src/libstate/init.h",
        "src/libstate/libstate.h",
        "src/libstate/look_pk.h",
        "src/libstate/lookup.h",
        "src/libstate/oid_lookup/oids.h",
        "src/libstate/pk_engine.h",
        "src/libstate/scan_name.h",
        "src/mac/cbc_mac/cbc_mac.h",
        "src/mac/cmac/cmac.h",
        "src/mac/hmac/hmac.h",
        "src/mac/mac.h",
        "src/mac/ssl3mac/ssl3_mac.h",
        "src/mac/x919_mac/x919_mac.h",
        "src/math/bigint/bigint.h",
        "src/math/bigint/divide.h",
        "src/math/bigint/mp_core.h",
        "src/math/bigint/mp_generic/mp_asm.h",
        "src/math/bigint/mp_generic/mp_asmi.h",
        "src/math/bigint/mp_types.h",
        "src/math/numbertheory/blinding.h",
        "src/math/numbertheory/def_powm.h",
        "src/math/numbertheory/numthry.h",
        "src/math/numbertheory/pow_mod.h",
        "src/math/numbertheory/reducer.h",
        "src/modes/cbc/cbc.h",
        "src/modes/cfb/cfb.h",
        "src/modes/ctr/ctr.h",
        "src/modes/cts/cts.h",
        "src/modes/eax/eax.h",
        "src/modes/ecb/ecb.h",
        "src/modes/mode_pad/mode_pad.h",
        "src/modes/modebase.h",
        "src/modes/ofb/ofb.h",
        "src/modes/xts/xts.h",
        "src/mutex/mutex.h",
        "src/mutex/noop_mutex/mux_noop.h",
        "src/pbe/get_pbe.h",
        "src/pbe/pbes1/pbes1.h",
        "src/pbe/pbes2/pbes2.h",
        "src/pk_pad/eme.h",
        "src/pk_pad/eme1/eme1.h",
        "src/pk_pad/eme_pkcs/eme_pkcs.h",
        "src/pk_pad/emsa.h",
        "src/pk_pad/emsa1/emsa1.h",
        "src/pk_pad/emsa1_bsi/emsa1_bsi.h",
        "src/pk_pad/emsa2/emsa2.h",
        "src/pk_pad/emsa3/emsa3.h",
        "src/pk_pad/emsa4/emsa4.h",
        "src/pk_pad/emsa_raw/emsa_raw.h",
        "src/pk_pad/hash_id/hash_id.h",
        "src/pubkey/dh/dh.h",
        "src/pubkey/dh/dh_core.h",
        "src/pubkey/dh/dh_op.h",
        "src/pubkey/dl_algo/dl_algo.h",
        "src/pubkey/dl_group/dl_group.h",
        "src/pubkey/dlies/dlies.h",
        "src/pubkey/dsa/dsa.h",
        "src/pubkey/dsa/dsa_core.h",
        "src/pubkey/dsa/dsa_op.h",
        "src/pubkey/elgamal/elg_core.h",
        "src/pubkey/elgamal/elg_op.h",
        "src/pubkey/elgamal/elgamal.h",
        "src/pubkey/if_algo/if_algo.h",
        "src/pubkey/if_algo/if_core.h",
        "src/pubkey/if_algo/if_op.h",
        "src/pubkey/keypair/keypair.h",
        "src/pubkey/nr/nr.h",
        "src/pubkey/nr/nr_core.h",
        "src/pubkey/nr/nr_op.h",
        "src/pubkey/pk_algs.h",
        "src/pubkey/pk_codecs/pkcs8.h",
        "src/pubkey/pk_codecs/x509_key.h",
        "src/pubkey/pk_filts.h",
        "src/pubkey/pk_keys.h",
        "src/pubkey/pubkey.h",
        "src/pubkey/pubkey_enums.h",
        "src/pubkey/rsa/rsa.h",
        "src/pubkey/rw/rw.h",
        "src/rng/auto_rng/auto_rng.h",
        "src/rng/hmac_rng/hmac_rng.h",
        "src/rng/randpool/randpool.h",
        "src/rng/rng.h",
        "src/rng/x931_rng/x931_rng.h",
        "src/s2k/pbkdf1/pbkdf1.h",
        "src/s2k/pbkdf2/pbkdf2.h",
        "src/s2k/pgps2k/pgp_s2k.h",
        "src/s2k/s2k.h",
        "src/selftest/selftest.h",
        "src/stream/arc4/arc4.h",
        "src/stream/salsa20/salsa20.h",
        "src/stream/stream_cipher.h",
        "src/stream/turing/turing.h",
        "src/stream/wid_wake/wid_wake.h",
        "src/sym_algo/sym_algo.h",
        "src/sym_algo/symkey.h",
        "src/timer/timer.h",
        "src/utils/bit_ops.h",
        "src/utils/bswap.h",
        "src/utils/buf_comp/buf_comp.h",
        "src/utils/charset.h",
        "src/utils/datastor/datastor.h",
        "src/utils/exceptn.h",
        "src/utils/loadstor.h",
        "src/utils/mem_ops.h",
        "src/utils/parsing.h",
        "src/utils/rotate.h",
        "src/utils/stl_util.h",
        "src/utils/types.h",
        "src/utils/ui.h",
        "src/utils/util.h",
        "src/utils/version.h",
        "src/utils/xor_buf.h",
        "src/utils/sharedpointer.h",
        "src/algo_factory/algo_factory.cpp",
        "src/algo_factory/prov_weight.cpp",
        "src/alloc/mem_pool/mem_pool.cpp",
        "src/alloc/system_alloc/defalloc.cpp",
        "src/asn1/alg_id.cpp",
        "src/asn1/asn1_alt.cpp",
        "src/asn1/asn1_att.cpp",
        "src/asn1/asn1_dn.cpp",
        "src/asn1/asn1_int.cpp",
        "src/asn1/asn1_oid.cpp",
        "src/asn1/asn1_str.cpp",
        "src/asn1/asn1_tm.cpp",
        "src/asn1/ber_dec.cpp",
        "src/asn1/der_enc.cpp",
        "src/benchmark/benchmark.cpp",
        "src/block/aes/aes.cpp",
        "src/block/aes/aes_tab.cpp",
        "src/block/blowfish/blfs_tab.cpp",
        "src/block/blowfish/blowfish.cpp",
        "src/block/cast/cast128.cpp",
        "src/block/cast/cast256.cpp",
        "src/block/cast/cast_tab.cpp",
        "src/block/des/des.cpp",
        "src/block/des/des_tab.cpp",
        "src/block/des/desx.cpp",
        "src/block/gost_28147/gost_28147.cpp",
        "src/block/idea/idea.cpp",
        "src/block/kasumi/kasumi.cpp",
        "src/block/lion/lion.cpp",
        "src/block/lubyrack/lubyrack.cpp",
        "src/block/mars/mars.cpp",
        "src/block/mars/mars_tab.cpp",
        "src/block/misty1/misty1.cpp",
        "src/block/noekeon/noekeon.cpp",
        "src/block/rc2/rc2.cpp",
        "src/block/rc5/rc5.cpp",
        "src/block/rc6/rc6.cpp",
        "src/block/safer/safe_tab.cpp",
        "src/block/safer/safer_sk.cpp",
        "src/block/seed/seed.cpp",
        "src/block/seed/seed_tab.cpp",
        "src/block/serpent/serpent.cpp",
        "src/block/skipjack/skipjack.cpp",
        "src/block/square/sqr_tab.cpp",
        "src/block/square/square.cpp",
        "src/block/tea/tea.cpp",
        "src/block/twofish/two_tab.cpp",
        "src/block/twofish/twofish.cpp",
        "src/block/xtea/xtea.cpp",
        "src/cert/x509/certstor.cpp",
        "src/cert/x509/crl_ent.cpp",
        "src/cert/x509/pkcs10.cpp",
        "src/cert/x509/x509_ca.cpp",
        "src/cert/x509/x509_crl.cpp",
        "src/cert/x509/x509_ext.cpp",
        "src/cert/x509/x509_obj.cpp",
        "src/cert/x509/x509cert.cpp",
        "src/cert/x509/x509find.cpp",
        "src/cert/x509/x509opt.cpp",
        "src/cert/x509/x509self.cpp",
        "src/cert/x509/x509stor.cpp",
        "src/checksum/adler32/adler32.cpp",
        "src/checksum/crc24/crc24.cpp",
        "src/checksum/crc32/crc32.cpp",
        "src/cms/cms_algo.cpp",
        "src/cms/cms_comp.cpp",
        "src/cms/cms_dalg.cpp",
        "src/cms/cms_dec.cpp",
        "src/cms/cms_ealg.cpp",
        "src/cms/cms_enc.cpp",
        "src/codec/base64/b64_char.cpp",
        "src/codec/base64/base64.cpp",
        "src/codec/hex/hex.cpp",
        "src/codec/hex/hex_char.cpp",
        "src/codec/openpgp/openpgp.cpp",
        "src/codec/pem/pem.cpp",
        "src/cryptobox/cryptobox.cpp",
        "src/engine/def_engine/def_mode.cpp",
        "src/engine/def_engine/def_pk_ops.cpp",
        "src/engine/def_engine/def_powm.cpp",
        "src/engine/def_engine/lookup_block.cpp",
        "src/engine/def_engine/lookup_hash.cpp",
        "src/engine/def_engine/lookup_mac.cpp",
        "src/engine/def_engine/lookup_stream.cpp",
        "src/filters/algo_filt.cpp",
        "src/filters/basefilt.cpp",
        "src/filters/buf_filt.cpp",
        "src/filters/data_snk.cpp",
        "src/filters/data_src.cpp",
        "src/filters/filter.cpp",
        "src/filters/out_buf.cpp",
        "src/filters/pipe.cpp",
        "src/filters/pipe_io.cpp",
        "src/filters/pipe_rw.cpp",
        "src/filters/secqueue.cpp",
        "src/hash/fork256/fork256.cpp",
        "src/hash/gost_3411/gost_3411.cpp",
        "src/hash/has160/has160.cpp",
        "src/hash/md2/md2.cpp",
        "src/hash/md4/md4.cpp",
        "src/hash/md5/md5.cpp",
        "src/hash/mdx_hash/mdx_hash.cpp",
        "src/hash/par_hash/par_hash.cpp",
        "src/hash/rmd128/rmd128.cpp",
        "src/hash/rmd160/rmd160.cpp",
        "src/hash/sha1/sha160.cpp",
        "src/hash/sha2/sha2_32.cpp",
        "src/hash/sha2/sha2_64.cpp",
        "src/hash/skein/skein_512.cpp",
        "src/hash/tiger/tig_tab.cpp",
        "src/hash/tiger/tiger.cpp",
        "src/hash/whirlpool/whrl_tab.cpp",
        "src/hash/whirlpool/whrlpool.cpp",
        "src/kdf/kdf.cpp",
        "src/kdf/kdf1/kdf1.cpp",
        "src/kdf/kdf2/kdf2.cpp",
        "src/kdf/mgf1/mgf1.cpp",
        "src/kdf/ssl_prf/prf_ssl3.cpp",
        "src/kdf/tls_prf/prf_tls.cpp",
        "src/kdf/x942_prf/prf_x942.cpp",
        "src/libstate/get_enc.cpp",
        "src/libstate/init.cpp",
        "src/libstate/libstate.cpp",
        "src/libstate/look_pk.cpp",
        "src/libstate/lookup.cpp",
        "src/libstate/oid_lookup/oids.cpp",
        "src/libstate/pk_engine.cpp",
        "src/libstate/policy.cpp",
        "src/libstate/scan_name.cpp",
        "src/mac/cbc_mac/cbc_mac.cpp",
        "src/mac/cmac/cmac.cpp",
        "src/mac/hmac/hmac.cpp",
        "src/mac/mac.cpp",
        "src/mac/ssl3mac/ssl3_mac.cpp",
        "src/mac/x919_mac/x919_mac.cpp",
        "src/math/bigint/big_code.cpp",
        "src/math/bigint/big_io.cpp",
        "src/math/bigint/big_ops2.cpp",
        "src/math/bigint/big_ops3.cpp",
        "src/math/bigint/big_rand.cpp",
        "src/math/bigint/bigint.cpp",
        "src/math/bigint/divide.cpp",
        "src/math/bigint/monty_generic/mp_monty.cpp",
        "src/math/bigint/mp_asm.cpp",
        "src/math/bigint/mp_comba.cpp",
        "src/math/bigint/mp_karat.cpp",
        "src/math/bigint/mp_misc.cpp",
        "src/math/bigint/mp_shift.cpp",
        "src/math/bigint/mulop_generic/mp_mulop.cpp",
        "src/math/numbertheory/blinding.cpp",
        "src/math/numbertheory/dsa_gen.cpp",
        "src/math/numbertheory/jacobi.cpp",
        "src/math/numbertheory/make_prm.cpp",
        "src/math/numbertheory/mp_numth.cpp",
        "src/math/numbertheory/numthry.cpp",
        "src/math/numbertheory/pow_mod.cpp",
        "src/math/numbertheory/powm_fw.cpp",
        "src/math/numbertheory/powm_mnt.cpp",
        "src/math/numbertheory/primes.cpp",
        "src/math/numbertheory/reducer.cpp",
        "src/math/numbertheory/ressol.cpp",
        "src/modes/cbc/cbc.cpp",
        "src/modes/cfb/cfb.cpp",
        "src/modes/ctr/ctr.cpp",
        "src/modes/cts/cts.cpp",
        "src/modes/eax/eax.cpp",
        "src/modes/eax/eax_dec.cpp",
        "src/modes/ecb/ecb.cpp",
        "src/modes/mode_pad/mode_pad.cpp",
        "src/modes/modebase.cpp",
        "src/modes/ofb/ofb.cpp",
        "src/modes/xts/xts.cpp",
        "src/mutex/noop_mutex/mux_noop.cpp",
        "src/pbe/get_pbe.cpp",
        "src/pbe/pbes1/pbes1.cpp",
        "src/pbe/pbes2/pbes2.cpp",
        "src/pk_pad/eme.cpp",
        "src/pk_pad/eme1/eme1.cpp",
        "src/pk_pad/eme_pkcs/eme_pkcs.cpp",
        "src/pk_pad/emsa1/emsa1.cpp",
        "src/pk_pad/emsa1_bsi/emsa1_bsi.cpp",
        "src/pk_pad/emsa2/emsa2.cpp",
        "src/pk_pad/emsa3/emsa3.cpp",
        "src/pk_pad/emsa4/emsa4.cpp",
        "src/pk_pad/emsa_raw/emsa_raw.cpp",
        "src/pk_pad/hash_id/hash_id.cpp",
        "src/pubkey/dh/dh.cpp",
        "src/pubkey/dh/dh_core.cpp",
        "src/pubkey/dl_algo/dl_algo.cpp",
        "src/pubkey/dl_group/dl_group.cpp",
        "src/pubkey/dlies/dlies.cpp",
        "src/pubkey/dsa/dsa.cpp",
        "src/pubkey/dsa/dsa_core.cpp",
        "src/pubkey/dsa/dsa_op.cpp",
        "src/pubkey/elgamal/elg_core.cpp",
        "src/pubkey/elgamal/elg_op.cpp",
        "src/pubkey/elgamal/elgamal.cpp",
        "src/pubkey/if_algo/if_algo.cpp",
        "src/pubkey/if_algo/if_core.cpp",
        "src/pubkey/if_algo/if_op.cpp",
        "src/pubkey/keypair/keypair.cpp",
        "src/pubkey/nr/nr.cpp",
        "src/pubkey/nr/nr_core.cpp",
        "src/pubkey/nr/nr_op.cpp",
        "src/pubkey/pk_algs.cpp",
        "src/pubkey/pk_codecs/pkcs8.cpp",
        "src/pubkey/pk_codecs/x509_key.cpp",
        "src/pubkey/pk_filts.cpp",
        "src/pubkey/pk_keys.cpp",
        "src/pubkey/pubkey.cpp",
        "src/pubkey/pubkey_enums.cpp",
        "src/pubkey/rsa/rsa.cpp",
        "src/pubkey/rw/rw.cpp",
        "src/rng/auto_rng/auto_rng.cpp",
        "src/rng/hmac_rng/hmac_rng.cpp",
        "src/rng/randpool/randpool.cpp",
        "src/rng/rng.cpp",
        "src/rng/x931_rng/x931_rng.cpp",
        "src/s2k/pbkdf1/pbkdf1.cpp",
        "src/s2k/pbkdf2/pbkdf2.cpp",
        "src/s2k/pgps2k/pgp_s2k.cpp",
        "src/s2k/s2k.cpp",
        "src/selftest/selftest.cpp",
        "src/stream/arc4/arc4.cpp",
        "src/stream/salsa20/salsa20.cpp",
        "src/stream/stream_cipher.cpp",
        "src/stream/turing/tur_tab.cpp",
        "src/stream/turing/turing.cpp",
        "src/stream/wid_wake/wid_wake.cpp",
        "src/sym_algo/symkey.cpp",
        "src/timer/timer.cpp",
        "src/utils/charset.cpp",
        "src/utils/datastor/datastor.cpp",
        "src/utils/exceptn.cpp",
        "src/utils/mlock.cpp",
        "src/utils/parsing.cpp",
        "src/utils/ui.cpp",
        "src/utils/util.cpp",
        "src/utils/version.cpp"
    ]

    Group {
        condition: qbs.targetOS == "windows"
        files: [
            "src/entropy/cryptoapi_rng/es_capi.cpp",
            "src/entropy/win32_stats/es_win32.cpp",
            "src/mutex/win32_crit_section/mux_win32.cpp",
            "src/timer/win32_query_perf_ctr/tm_win32.cpp",
        ]
    }

    Group {
        condition: qbs.targetOS == "linux" || qbs.targetOS == 'mac'
        files: [
            "src/alloc/alloc_mmap/mmap_mem.cpp",
            "src/cert/cvc/asn1_eac_str.cpp",
            "src/cert/cvc/asn1_eac_tm.cpp",
            "src/cert/cvc/cvc_ado.cpp",
            "src/cert/cvc/cvc_ca.cpp",
            "src/cert/cvc/cvc_cert.cpp",
            "src/cert/cvc/cvc_req.cpp",
            "src/cert/cvc/cvc_self.cpp",
            "src/cert/cvc/ecdsa_sig.cpp",
            "src/cert/cvc/signed_obj.cpp",
            "src/entropy/dev_random/es_dev.cpp",
            "src/entropy/egd/es_egd.cpp",
            "src/entropy/proc_walk/es_ftw.cpp",
            "src/entropy/unix_procs/es_unix.cpp",
            "src/entropy/unix_procs/unix_cmd.cpp",
            "src/entropy/unix_procs/unix_src.cpp",
            "src/filters/fd_unix/fd_unix.cpp",
            "src/math/gfpmath/curve_gfp.cpp",
            "src/math/gfpmath/gfp_element.cpp",
            "src/math/gfpmath/point_gfp.cpp",
            "src/mutex/pthreads/mux_pthr.cpp",
            "src/pubkey/ec_dompar/ec_dompar.cpp",
            "src/pubkey/ecc_key/ecc_key.cpp",
            "src/pubkey/ecdsa/ecdsa.cpp",
            "src/pubkey/ecdsa/ecdsa_core.cpp",
            "src/pubkey/ecdsa/ecdsa_op.cpp",
            "src/pubkey/eckaeg/eckaeg.cpp",
            "src/pubkey/eckaeg/eckaeg_core.cpp",
            "src/pubkey/eckaeg/eckaeg_op.cpp",
            "src/timer/gettimeofday/tm_unix.cpp"
        ]
    }

    Group {
        condition: qbs.targetOS == "linux"
        files: [
            "src/timer/posix_rt/tm_posix.cpp"
        ]
    }

    ProductModule {
        Depends { name: "cpp" }
        cpp.linkerFlags: {
            if (qbs.toolchain === 'mingw') {
                return ['--enable-auto-import']
            }
        }
    }
}
