<CsoundSynthesizer>

; Id: H00_a.CSD mg (2006, rev.2009)
; author: marco gasperini (marcogsp at yahoo dot it)

; G.M. Koenig
; ESSAY (1957)

<CsOptions>
-W -f -oH00_a.wav
</CsOptions>

<CsInstruments>

sr     = 192000
kr     = 19200
ksmps  = 10
nchnls = 1

;=============================================
; SINUS TONES (S)
;=============================================
	instr 1	
iamp	= ampdb(90+p4)
ifreq	= p5

a1	oscili iamp , ifreq , 1
aenv	expseg .001 , .005, 1 , p3-.01 ,1, .005,.001

aout	= a1 * aenv

	out aout
	endin
;=============================================

;=============================================
; FILTERED NOISE (N)
;=============================================
	instr 2
iamp	= ampdb(89+p4)
ifreq	= p5
ibw	= ifreq * .05		; filtered noise's bandwidth 5% of central frequency

a1	rnd31 iamp , 1 
k1	rms a1

afilt	butterbp a1 , ifreq , ibw
afilt	butterbp afilt , ifreq , ibw

aenv	expseg .001 , .005, .8 , p3-.01 ,.8 ,.005,.001

aout	gain afilt , k1
aout	= aout * aenv 

	out aout
	endin
;=============================================

;=============================================
; FILTERED IMPULSES (I)
;=============================================
	instr 3
iamp	= ampdb(90+p4)
ifreq	= p5
ibw	= ifreq * .01		; filtered pulse's bandwidth 1% of central frequency

if1	= ifreq-(ibw/3)
if2	= ifreq+((2*ibw)/3)

				
a1	mpulse iamp , 0 

afilt	atonex a1 , if1 , 2
afilt	tonex afilt*400 , if2 , 2  
afilt	butterbp afilt*38 , ifreq , ibw*.5


aenv	linseg 1 , p3-.01, 1 , .01 , 0

aout	= afilt * aenv 

	out aout
	endin
;=============================================
</CsInstruments>
<CsScore>
;functions--------------------------------------------------
f1	0	8192	10	1	; sinusoid
;/functions--------------------------------------------------

t0	4572	; 76.2 cm/sec. tape speed (durations in cm)

;test--------------------------------------------------
;mute-------------------------------------------------
q 1 0 1
q 2 0 1
q 3 0 1
;/mute-------------------------------------------------
;/test-------------------------------------------------

;====================================================
; 180. MATERIAL H
; 181. total length: 171 cm, 5 sections
;
; sequence a
;
; length    sequence 	
; 29.2   cm (3)
; 65.6   cm (5)
; 43.8   cm (4)
; 13     cm (1)
; 19.5   cm (2)
;==================================================

;==================================181.11
; 29.2 cm 10/9
;----------------------------------------
;			p4	p5
;			iamp	ifreq	timbre
;			[dB]	[Hz]
i3	0	3	-2.5	1467	; I
i3	+	2.7	-2.5	1436    ; I
i3	+	4.6	-1.5	1345    ; I
i3	+	3.7	-2.5	1532    ; I
i2	14	3.4	-4	1499	; R
i3	17.4	5.1	-1.5	1375    ; I
i3	+	4.2	-2.8	1566    ; I
i3	+	2.5	-2	1405    ; I
s                                   
t0	4572
;==================================181.11
; 65.6 cm 8/7
;----------------------------------------
; x
i2	0	5.6	-9	1037	; R
i2	+	4.9	-10	972     ; R
i3	10.5	9.6	-8	1345    ; I
i3	+	7.3	-9	1532    ; I
i2	27.4	6.4	-10	1499    ; R
i2	+	10.9	-10	1375    ; R
i2	+	8.4	-10	1566    ; R
i3	53.1	12.5	-8.5	1499    ; I
                                    
; y
i2	0	5.6	-10	2691	; R
i2	+	4.9	-10	2263    ; R
i3	10.5	9.6	-10.5	1903    ; I
i3	+	7.3	-9	1600    ; I
i2	27.4	6.4	-10	1467    ; R
i2	+	10.9	-10	1745    ; R
i2	+	8.4	-10	2075    ; R
i3	53.1	12.5	-12.5	2468    ; I
s                                   
t0	4572
;==================================181.11
; 43.8 cm 9/8
;----------------------------------------
i2	0	7.1	-4 	1131	; R
i2	+	6.3	-4 	1288    ; R
i2	+	4.4	-4 	1467    ; R
i2	+	3.5	-4  	1671    ; R
i2	+	8	-6	1903    ; R
i2	+	5	-4 	2167    ; R
i2	+	3.9	-4 	2467    ; R
i2	+	5.6	-4 	2810    ; R
s                                   
t0	4572
;==================================181.11
; 13 cm 12/11
;----------------------------------------
; x
i1	0	1.7	-6	1745	; S
i2	1.7	1.5	-10	1708    ; R
i2	+	1.2	-10	1600    ; R
i2	+	2	-10	1822    ; R
i1	6.4	1.8	-6	1783    ; S
i1	+	1.3	-6	1635    ; S
i2	9.5	2.1	-10	1862    ; R
i2	+	1.4	-10	1671    ; R
; y                                 
i1	0	1.7	-6	1566	; S
i2	1.7	1.5	-10	1499    ; R
i2	+	1.2	-10	1436    ; R
i2	+	2	-10	1375    ; R
i1	6.4	1.8	-6	1345    ; S
i1	+	1.3	-6	1405    ; S
i2	9.5	2.1	-10	1467    ; R
i2	+	1.4	-10	1532    ; R
s                                   
t0	4572
;==================================181.11
; 19.4 cm 11/10
;----------------------------------------
; x
i1	0	2.3	-8	800	; S
i1	+	2	-8	951     ; S
i1	+	3.3	-8	1131    ; S
i2	7.6	2.7	-10	1345    ; R
i1	10.3	2.5	-8	1600    ; S
i1	+	1.7	-8	1903    ; S
i1	+	3	-8	2263    ; S
i1	+	1.9	-8	2691    ; S
; y                                 
i1	0	2.3	-8	3200	; S
i1	+	2	-8	2691    ; S
i1	+	3.3	-8	2263    ; S
i2	7.6	2.7	-9	1903    ; R
i1	10.3	2.5	-8	1600    ; S
i1	+	1.7	-8	1345    ; S
i1	+	3	-8	1131    ; S
i1	+	1.9	-8	951     ; S

; total length: 171 cm
e                                   
</CsScore>
</CsoundSynthesizer>