/***************************************************************************
 *   Copyright (C) 2008-2009 by fra74   *
 *   francesco.b74@gmail.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef SCHEDASTAZIONE_H
#define SCHEDASTAZIONE_H
//

#include "schedaviaggiatreno.h"
#include "parser_viaggiatreno.h"
//

namespace StazioneVT {
	enum {colCategoria = 0, colNumero = 1, colStazione = 2, colBinProgrammato = 3,
		  colBinReale = 4, colOrario = 5, colRitardo = 6, colUltima = colRitardo};
};

class QViaggiaTreno;

class SchedaStazione : public SchedaQViaggiaTreno
{
Q_OBJECT

public:
	SchedaStazione(QViaggiaTreno *parent, const QString& nome, const unsigned int intervalloStandard = 2);
	
	QString nomeStazione() const;
	QString codiceStazione() const { return m_codice; } 
	virtual QString titolo( bool titoloBreve = false) const;
	virtual void salvaScheda(QSettings& settings);
	
public slots:
	virtual void aggiorna();
	void cambiaCodiceStazione(const QString& nuovoCodice);
	void modificaNomeStazione();

	virtual void downloadFinito(const QString& rispostaVT);
	

private:
	int m_idTabella, m_idNomeSbagliato, m_idNomeAmbiguo;
	QString m_stazione, m_codice;
	QLabel *m_labelTitolo, *m_labelAggiornamento;
	QTableWidget *m_tabellaPartenze, *m_tabellaArrivi;
	QDomDocument *m_documentoDom;
	ParserStazioneViaggiaTreno *m_parser;
    QList<StazioneVT::DatiTreno> m_arrivi, m_partenze;

	QWidget* creaWidgetStazione();
	QWidget* creaWidgetErroreNome();
	
	void riempiTabelle(QList<StazioneVT::DatiTreno> arrivi, QList<StazioneVT::DatiTreno> partenze);
	
private slots:
	void itemAttivato(QTableWidgetItem* item);

signals:
	void downloadStazione(quint32, const QString&);
	void downloadStazioneConCodice(quint32, const QString&);
};


//widget che viene mostrato quando il nome della stazione introdotto risulta ambiguo
//codice nel file schedastazione_widget.cpp
class WidgetDisambiguaNome : public QWidget
{
Q_OBJECT

public:
	WidgetDisambiguaNome(SchedaStazione *parent, QMap<QString, QString>listaCodiciStazioni);
	
private:
	QListWidget* listaNomi;

private slots: 
	void sceltaNomeStazione();	
	
signals:
	void nomeDisambiguato(const QString& nuovoCodice);
};

class TabellaStazione : public QTableWidget
{
Q_OBJECT

public:
	TabellaStazione(QWidget *parent);

	void mouseMoveEvent(QMouseEvent *event);
};

#endif


