#!/usr/bin/python
# -*-coding: UTF-8 -*-
# bbou@ac-toulouse.fr
# GPL license
# 2006-11-16 10:31:38  
# globs.py

import pygtk
pygtk.require("2.0")
from gtk import *
import gtk.glade
import string
import re
import stat

import runner

#######################################################################
#	GLOBALS
#######################################################################

sysSetting={
	'testparm':'testparm -vs 2> /dev/null',
	'getSep':"testparm -sv 2> /dev/null | grep '^[[:space:]]*winbind separator[[:space:]]*=' | awk '{print $4}'",
	'getDomain':"testparm -sv 2> /dev/null | grep '^[[:space:]]workgroup[[:space:]]*=' | awk '{print $3}'",
	'getUidRange':"testparm -sv 2> /dev/null | grep '^[[:space:]]idmap uid[[:space:]]*=' | awk '{print $4}'",
	'getGidRange':"testparm -sv 2> /dev/null | grep '^[[:space:]]idmap gid[[:space:]]*=' | awk '{print $4}'",
	'docs':{'default':'file:///usr/share/doc/sadms-%s/%s',
		'redhat':'file:///usr/share/doc/sadms-%s/%s',
		'debian':'file:///usr/share/doc/sadms/%s',
		'suse':'file:///usr/share/doc/packages/sadms/%s',
		'mandriva':'file:///usr/share/doc/sadms-%s/%s'},
	'browser':{'default':'/usr/bin/firefox',
		'redhat':'/usr/bin/firefox',
		'debian':'/usr/bin/firefox',
		'suse':'/usr/bin/firefox',
		'mandriva':'/usr/bin/mozilla-firefox'},
	'pidof':{'default':'/sbin/pidof',
		'redhat':'/sbin/pidof',
		'debian':'/bin/pidof',
		'suse':'/sbin/pidof',
		'mandriva':'/sbin/pidof'},

	'getUsers':"getent passwd | grep -v '^$' | cut -f 1 -d ':' | sort",
	'getGroups':"getent group | grep -v '^$' | cut -f 1 -d ':' | sort",
	'getUserId':"id -u %USER%",
	'getGroupId':"getent group \"%GROUP%\" 2> /dev/null | awk 'BEGIN{FS=\":\"}{print $3}'",
	'signalSmb':'kill -HUP `pidof smbd` 2> /dev/null',
	'signalNmb':'kill -HUP `pidof nmbd` 2> /dev/null',
	'signalWinbind':'kill -HUP `pidof winbindd` 2> /dev/null',
	'readFile':'cat "%FILE%"',
	'writeFile':'cat - > "%FILE%" <<EOF\n%TEXT%\nEOF',
	'exists':'sh -c \'if [ -e "%FSOBJECT%" ]; then echo true; else echo false; fi\'',
	'getVersion':'cat version | head -n 1',
	'getDistribution':'sh -c \'if [ -f /etc/debian_version ]; then echo "debian"; else if [ -f /etc/SuSE-release ]; then echo "suse"; else if [ -e /etc/mandrake-release -o -e /etc/mandriva-release ]; then echo "mandriva"; else if [ -e /etc/redhat-release ]; then echo "redhat"; else echo "default"; fi; fi; fi; fi\'',
}

definedProps={}

#######################################################################
#	GlobalsManager
#######################################################################

class SubjectChooser:

	IMAGE=0
	TEXT=1

	USER=0
	GROUP=1

	pixbufs=[]

	def __init__(self,dialog,listview):
		self.dialog=dialog
		self.listview=listview
		
		# header
		self.listview.set_headers_visible(False)

		# selection
		self.listview.get_selection().set_mode(gtk.SELECTION_MULTIPLE)

		# model
		self.model=ListStore(gtk.gdk.Pixbuf,str)
		self.listview.set_model(self.model)

		# columns
		column=gtk.TreeViewColumn('')
		cell=gtk.CellRendererPixbuf()
		column.pack_start(cell,True)
		column.add_attribute(cell,'pixbuf',SubjectChooser.IMAGE)
		self.listview.append_column(column)

		column=gtk.TreeViewColumn('subject')
		cell=gtk.CellRendererText()
		column.pack_start(cell,True)
		column.add_attribute(cell,'text',SubjectChooser.TEXT)
		self.listview.append_column(column)

		# images
		if SubjectChooser.pixbufs==[]:
			SubjectChooser.pixbufs=self.setupImages()
                return
        
	def setupImages(self):
		imageFile=['user-hidden.png','group-hidden.png']
		pixbufs=[]
		for i in range(len(imageFile)):
        		pixbufs.append(gtk.gdk.pixbuf_new_from_file('pixmaps/'+imageFile[i]))
		return pixbufs

	def clear(self):
		self.model.clear()
		return

	def set(self,subjects,subjecttype):
		for i in subjects:
			self.model.append([SubjectChooser.pixbufs[subjecttype],i])
		return

	def getSelection(self):
		selection=self.listview.get_selection()
		(model,pathlist)=selection.get_selected_rows()
		return [model[model.get_iter(path)][SubjectChooser.TEXT] for path in pathlist]

	# wrappers 
	
	def run(self):
		return self.dialog.run()

	def hide(self):
		self.dialog.hide()
		return

#######################################################################

class BooleanProperty:

	def __init__(self,defineToggle,toggle,tag):
		self.dirty=None
		self.defineToggle=defineToggle
		self.toggle=toggle
		self.tag=tag
		self.defineToggle.set_data('master',self)
		self.toggle.set_data('master',self)
		definedProps[tag]=self
		return

	def set(self,value):
		#print '%s=%s' %(self.tag,value)
		if value==None:
			self.defineToggle.set_active(False)
			self.toggle.set_active(False)
		else:
			self.defineToggle.set_active(True)
			if value=='Yes':
				self.toggle.set_active(True)
			else:
				self.toggle.set_active(False)
		self.dirty=False
		return
		
	def get(self):
		return self.defineToggle.get_active(),self.toggle.get_active()
		
class MultipleProperty:

	def __init__(self,defineToggle,combo,tag):
		self.dirty=None
		self.defineToggle=defineToggle
		self.combo=combo
		self.tag=tag
		self.defineToggle.set_data('master',self)
		self.combo.set_data('master',self)
		definedProps[tag]=self
		return
		
	def set(self,value):
		#print '%s=<%s>' %(self.tag,value)
		if value==None:
			self.defineToggle.set_active(False)
		else:
			self.defineToggle.set_active(True)
			i=self.find(value)
			if i==None:
				self.combo.prepend_text(value)
				self.combo.set_active(0)
			else:
				self.combo.set_active(i)
		self.dirty=False
		return

	def get(self):
		value=self.combo.get_active_text()
		if value=='<none>':
			value=''
		return self.defineToggle.get_active(),value
		
	def find(self,value):
		if value=='':
			value='<none>'
		model=self.combo.get_model()
		i=model.get_iter_first()
		while i:
			if model.get_value(i,0)==value:
				return model.get_path(i)[0]
			i=model.iter_next(i)
		return None

class UsersProperty(MultipleProperty):

	def __init__(self,defineToggle,combo,tag,users):
		MultipleProperty.__init__(self,defineToggle,combo,tag)
		for u in users:
			self.combo.append_text(u)
		return

class StringProperty:

	def __init__(self,defineToggle,entry,tag):
		self.dirty=None
		self.defineToggle=defineToggle
		self.entry=entry
		self.tag=tag
		self.defineToggle.set_data('master',self)
		self.entry.set_data('master',self)
		definedProps[tag]=self
		return
		
	def set(self,value):
		#print '%s=<%s>' %(self.tag,value)
		if value==None:
			self.defineToggle.set_active(False)
		else:
			self.defineToggle.set_active(True)
			self.entry.set_text(value)
		self.dirty=False
		return
		
	def get(self):
		return self.defineToggle.get_active(),self.entry.get_text()
		
class MultipleUsersProperty(StringProperty):

	def __init__(self,defineToggle,entry,button,tag):
		StringProperty.__init__(self,defineToggle,entry,tag)
		self.button=button
		self.button.set_data('master',self)
		return

class MaskProperty(StringProperty):

	def __init__(self,defineToggle,entry,button,tag):
		StringProperty.__init__(self,defineToggle,entry,tag)
		self.button=button
		self.button.set_data('master',self)
		return

	def intToMode(self,m):
		#print oct(m)
		ur=m & stat.S_IRUSR!=0
		uw=m & stat.S_IWUSR!=0
		ux=m & stat.S_IXUSR!=0
		gr=m & stat.S_IRGRP!=0
		gw=m & stat.S_IWGRP!=0
		gx=m & stat.S_IXGRP!=0
		wr=m & stat.S_IROTH!=0
		ww=m & stat.S_IWOTH!=0
		wx=m & stat.S_IXOTH!=0
		return ur,uw,ux,gr,gw,gx,wr,ww,wx

	def modeToInt(self,ur,uw,ux,gr,gw,gx,wr,ww,wx):
		mode=0
		if ur:
			mode=mode | stat.S_IRUSR
		if uw:
			mode=mode | stat.S_IWUSR
		if ux:
			mode=mode | stat.S_IXUSR
		if gr:
			mode=mode | stat.S_IRGRP
		if gw:
			mode=mode | stat.S_IWGRP
		if gx:
			mode=mode | stat.S_IXGRP
		if wr:
			mode=mode | stat.S_IROTH
		if ww:
			mode=mode | stat.S_IWOTH
		if wx:
			mode=mode | stat.S_IXOTH
		return mode

class RangeProperty:

	def __init__(self,defineToggle,spinFrom,spinTo,tag):
		self.dirty=None
		self.defineToggle=defineToggle
		self.spinFrom=spinFrom
		self.spinTo=spinTo
		self.tag=tag
		self.defineToggle.set_data('master',self)
		self.spinFrom.set_data('master',self)
		self.spinTo.set_data('master',self)
		definedProps[tag]=self
		return
		
	def set(self,value):
		print "set ",value
		if value==None:
			self.defineToggle.set_active(False)
		else:
			self.defineToggle.set_active(True)
			r=value.split('-')
			if len(r)==2:
				self.spinFrom.set_value(float(r[0]))
				self.spinTo.set_value(float(r[1]))
			else:
				self.spinFrom.set_value(500)
				self.spinTo.set_value(32000)
		self.dirty=False
		return
		
	def get(self):
		return self.defineToggle.get_active(),'%d-%d' % (self.spinFrom.get_value(),self.spinTo.get_value())

#######################################################################

class GlobalsManager:
	
	def __init__(self):
		self.runner=runner.GtkRunner()
		self.uidRange=[]
		self.gidRange=[]
		
		prefix='%s%s' % (self.getDomain(),self.getSep())
		self.users=self.getUsers()
		self.users=[u.replace(prefix,'',1) for u in self.users]
		self.groups=self.getGroups()
		self.groups=[g.replace(prefix,'',1) for g in self.groups]
		self.nisGroups=['@'+g for g in self.groups]
		self.usersGroups=self.users+self.nisGroups

		handlers={
			'on_destroy':			self.exit,
			'on_ok_clicked':		self.exitOk,
			'on_cancel_clicked':		self.exit,
			'on_apply_clicked':		self.applyGlobs,

			'on_browseUsers_clicked':	self.browseUsers,
			'on_browseMask_clicked':	self.browseMask,
			'on_refresh_clicked':		self.forceRefresh,
			'on_about_activate':		self.about,
			'on_help_clicked':		self.help,

			'on_checkDefine_toggled':	self.checkDefineToggled,
			'on_check_toggled':		self.checkToggled,
			'on_entry_changed':		self.entryChanged,
			'on_combo_changed':		self.comboChanged,
			'on_spin_changed':		self.spinChanged,
		}

		self.widgets=gtk.glade.XML('globs.glade')
		self.widgets.signal_autoconnect(handlers)
		self.dialog=self['globals']
		self.usersDialog=self['usersDialog']
		self.permsDialog=self['permsDialog']
		self.aboutDialog=self['aboutDialog']

		self.subjectChooser=SubjectChooser(self.usersDialog,self['usersView'])
		
		# users
		self.winbindSeparatorProp=MultipleUsersProperty(self['validUsersDefineToggle'],self['validUsersEntry'],self['validUsersBrowseButton'],'valid users')
		self.winbindSeparatorProp=MultipleUsersProperty(self['readUsersDefineToggle'],self['readUsersEntry'],self['readUsersBrowseButton'],'read list')
		self.winbindSeparatorProp=MultipleUsersProperty(self['writeUsersDefineToggle'],self['writeUsersEntry'],self['writeUsersBrowseButton'],'write list')
		self.winbindSeparatorProp=MultipleUsersProperty(self['adminUsersDefineToggle'],self['adminUsersEntry'],self['adminUsersBrowseButton'],'admin users')

		# groups
		self.winbindEnumGroupsProp=BooleanProperty(self['winbindEnumGroupsDefineToggle'],self['winbindEnumGroupsToggle'],'winbind enum groups')
		self.winbindNestedGroupsProp=BooleanProperty(self['winbindNestedGroupsDefineToggle'],self['winbindNestedGroupsToggle'],'winbind nested groups')

		# winbind
		self.winbindSeparatorProp=MultipleProperty(self['winbindSeparatorDefineToggle'],self['winbindSeparatorCombo'],'winbind separator')
		self.winbindUseDefaultDomainProp=BooleanProperty(self['winbindUseDefaultDomainDefineToggle'],self['winbindUseDefaultDomainToggle'],'winbind use default domain')
		# shares
		self.clientSigningProp=MultipleProperty(self['clientSigningDefineToggle'],self['clientSigningCombo'],'client signing')
		self.serverSigningProp=MultipleProperty(self['serverSigningDefineToggle'],self['serverSigningCombo'],'server signing')
		self.createMaskProp=MaskProperty(self['createMaskDefineToggle'],self['createMaskEntry'],self['createMaskBrowseButton'],'create mask')
		self.directoryMaskProp=MaskProperty(self['directoryMaskDefineToggle'],self['directoryMaskEntry'],self['directoryMaskBrowseButton'],'directory mask')

		# id map
		minuid,maxuid=self.getUidRange()
		self.uidRangeProp=RangeProperty(self['idmapUidDefineToggle'],self['idmapUidFromSpin'],self['idmapUidToSpin'],'idmap uid')
		self.gidRangeProp=RangeProperty(self['idmapGidDefineToggle'],self['idmapGidFromSpin'],self['idmapGidToSpin'],'idmap gid')
		self.idmapBackendProp=MultipleProperty(self['idmapBackendDefineToggle'],self['idmapBackendCombo'],'idmap backend')
		self.idmapBackendProp.combo.append_text("rid:BUILTIN=500-%d,%s=%d-%d" %(minuid-1,self.getDomain(),minuid,maxuid))

		# templates
		self.templateHomeDirProp=MultipleProperty(self['templateHomedirDefineToggle'],self['templateHomedirCombo'],'template homedir')
		self.templateShellProp=MultipleProperty(self['templateShellDefineToggle'],self['templateShellCombo'],'template shell')
		#self.templatePrimaryGroupProp=UsersProperty(self['templatePrimaryGroupDefineToggle'],self['templatePrimaryGroupCombo'],'template primary group',self.groups)

		# hosts
		self.hostsAllowProp=StringProperty(self['hostsAllowDefineToggle'],self['hostsAllowEntry'],'hosts allow')
		self.hostsDenyProp=StringProperty(self['hostsDenyDefineToggle'],self['hostsDenyEntry'],'hosts deny')
		self.winsServerProp=StringProperty(self['winsServerDefineToggle'],self['winsServerEntry'],'wins server')
		self.nameResolveOrderProp=MultipleProperty(self['nameResolveOrderDefineToggle'],self['nameResolveOrderCombo'],'name resolve order')
		self.winsSupportProp=BooleanProperty(self['winsSupportDefineToggle'],self['winsSupportToggle'],'wins support')

		# perms
		self.urCheck=self['permsURCheck']
		self.uwCheck=self['permsUWCheck']
		self.uxCheck=self['permsUXCheck']
		self.grCheck=self['permsGRCheck']
		self.gwCheck=self['permsGWCheck']
		self.gxCheck=self['permsGXCheck']
		self.wrCheck=self['permsWRCheck']
		self.wwCheck=self['permsWWCheck']
		self.wxCheck=self['permsWXCheck']
		return

	def __getitem__(self, key):
        	return self.widgets.get_widget(key)

	def exit(self,*options):
		if __name__ == "__main__":
			gtk.main_quit()
		else:
			self.dialog.destroy()	
		return
				
	def exitOk(self,*options):
		self.applyGlobs()
		self.exit()
		return

	# apply

	def applyGlobs(self,*options):
		self.atexit=[]
		changes=[[k,definedProps[k].get()] for k in definedProps.keys() if definedProps[k].dirty]
		if len(changes)>0:		
			lines=self.getConf()
			begin,end=self.clip(lines,'global')
			if begin!=-1 and end!=-1:
				glines=lines[begin:end]
				#self.printConf(glines[begin:end])
				for key,data in changes:
					define,value=data
					#print '%s %s=%s' % (define,key,value)

					# special processing hook
					self.hookActions(define,key,value)

					# change config
					lineno=self.find(key,glines)
					if define:
						if lineno!=-1:
							#print 'FOUND <%s> at line %d <%s>' % (key,lineno,glines[lineno])
							glines[lineno:lineno+1]=['\t%s = %s' % (key,value)]
							#print 'REDEFINED <%s> at line %d <%s>' % (key,lineno,glines[lineno])
						else:
							#print 'NOT FOUND <%s>' % (key)
							gend=len(glines)
							glines[gend:gend]=['\t%s = %s' % (key,value)]
							#print 'DEFINED <%s> at line %d <%s>' % (key,gend,glines[gend])	
					else:
						if lineno!=-1:
							#print 'FOUND <%s> at line %d <%s>' % (key,lineno,glines[lineno])
							glines[lineno:lineno+1]=[]
							#print 'UNDEFINE REMOVED %s at line %d' % (key,lineno)
							
						else:
							#print 'NOT FOUND <%s> at line %d <%s>' % (key,lineno,glines[lineno])
							#print 'UNDEFINE NO OP'
							pass							
					#self.printConfKey(glines,key)

				#self.printConf(glines)
				lines[begin:end]=glines
				self.setConf(lines)

				# at exit
				for job in self.atexit:
					f,args=job
					f(*args)

				# signal running daemons
				status,output=self.signalWinbind()
				#print 'hup winbind=%s %s' % (status,output)
				status,output=self.signalNmb()
				#print 'hup nmb=%s %s' % (status,output)
				status,output=self.signalSmb()
				#print 'hup smb=%s %s' % (status,output)
		return

	def hookActions(self,define,key,value):
		if key=='winbind separator':
			if not define:
				value='\\'
			domain=self.getDomain()
			oldprefix='%s%s' % (domain,self.getSep())
			newprefix='%s%s' % (domain,value)
			if newprefix!=oldprefix:
				self.atexit.append((self.changeSeparator,(oldprefix,newprefix)))
		return

	def changeSeparator(self,oldprefix,newprefix):
		#print oldprefix,newprefix
		conf=self.getConf()
		for i in range(len(conf)):
			if conf[i].find(oldprefix)!=-1:
				conf[i]=conf[i].replace(oldprefix,newprefix)
		#self.printConf(conf)
		self.setConf(conf)
		return

	# dirty bit callbacks

	def checkDefineToggled(self,widget,*options):
		master=widget.get_data('master')
		master.dirty=True
		return

	def checkToggled(self,widget,*options):
		master=widget.get_data('master')
		master.dirty=True
		return

	def comboChanged(self,widget,*options):
		master=widget.get_data('master')
		master.dirty=True
		return

	def entryChanged(self,widget,*options):
		master=widget.get_data('master')
		master.dirty=True
		return

	def spinChanged(self,widget,*options):
		master=widget.get_data('master')
		master.dirty=True
		return

	# browse users

	def putPrefix(self,s,isUser,prefix,inDomain):
		if s.startswith('builtin/'):
			return s
		if inDomain!=None:
			isInDomain=inDomain(s,isUser)
			if not isInDomain:
				return s
		return '%s%s' % (prefix,s)
		
	def browseUsers(self,button,*options):
		sep=self.getSep()
		domain=self.getDomain()
		prefix='%s%s' % (domain,sep)

		master=button.get_data('master')
		self.subjectChooser.clear()
		self.subjectChooser.set(self.users,SubjectChooser.USER)
		self.subjectChooser.set(self.nisGroups,SubjectChooser.GROUP)
		response=self.subjectChooser.run()
		self.subjectChooser.hide()
		if response==gtk.RESPONSE_OK:
			selection=self.subjectChooser.getSelection()
			users=[u for u in selection if u[0]!='@']
			users=['"%s"' % (self.putPrefix(u,True,prefix,self.inDomain)) for u in users]
			groups=[g for g in selection if g[0]=='@']
			groups=['"@%s"' % (self.putPrefix(g[1:],False,prefix,self.inDomain)) for g in groups]
			all=users+groups
			master.set(','.join(all))
		#else:
		#	master.set('')
		master.dirty=True
		return
		
	def browseMask(self,button,*options):
		master=button.get_data('master')
		defined,mode=master.get()
		try:
			mode=int(mode,8)
		except:
			return
		ur,uw,ux,gr,gw,gx,wr,ww,wx=master.intToMode(mode)
		self.urCheck.set_active(ur)
		self.uwCheck.set_active(uw)
		self.uxCheck.set_active(ux)
		self.grCheck.set_active(gr)
		self.gwCheck.set_active(gw)
		self.gxCheck.set_active(gx)
		self.wrCheck.set_active(wr)
		self.wwCheck.set_active(ww)
		self.wxCheck.set_active(wx)
		response=self.permsDialog.run()
		self.permsDialog.hide()
		if response==gtk.RESPONSE_OK:
			ur=self.urCheck.get_active()
			uw=self.uwCheck.get_active()
			ux=self.uxCheck.get_active()
			gr=self.grCheck.get_active()
			gw=self.gwCheck.get_active()
			gx=self.gxCheck.get_active()
			wr=self.wrCheck.get_active()
			ww=self.wwCheck.get_active()
			wx=self.wxCheck.get_active()
			mode=master.modeToInt(ur,uw,ux,gr,gw,gx,wr,ww,wx)
			master.set(oct(mode))
			master.dirty=True
		return

	# config file

	def printConf(self,lines):
		print '%d' % (len(lines))
		print 'vvv'
		for line in lines:
			print line
		print '^^^'
		return

	def printConfKey(self,lines,key):
		print '%d' % (len(lines))
		print 'vvv'
		for line in lines:
			if line.find(key)!=-1:
				print line
		print '^^^'
		return

	def find(self,key,lines):
		#key=key.replace(' ','\s*')
		#regexp='^[\s;#]*'+key+'\s*=.*$'
		regexp='^[\s]*'+key+'\s*=.*$'
		for i in range(0,len(lines)):
			#print key,lines[i]
			if re.match(regexp,lines[i]):
				return i
		return -1

	def clip(self,lines,section):
		begin,end=(-1,-1)
		for i in range(0,len(lines)):
			if re.match('^\['+section+'\]$',lines[i]):
				begin=i
			elif begin!=-1 and end==-1 and re.match('^\[.*\]$',lines[i]):
				end=i
			i=i+1
					
		if begin!=-1 and end==-1:
			end=i
		return begin,end

	def parse(self,lines):
		props={}
		for line in lines:
			# garbage line
			if re.match('^$',line):
				continue
			# section header line
			if re.match('^\[global\]$',line):
				continue
			# property line
			prop=line.split('=')
			name=prop[0].strip()
			value='='.join(prop[1:]).strip()
			props[name]=value
        	return props

	# refresh
	
	def forceRefresh(self,*options):
		self.refresh()
		return

	def refresh(self):
		cl=sysSetting['testparm']
		status,output=self.runToString(cl)
		if not status:
			return None
		lines=output.strip('\n\r ').splitlines()
		begin,end=self.clip(lines,'global')
		if [begin,end]==(-1,-1):
			return None
		lines=lines[begin:end]
		props=self.parse(lines)
		
		#print props
		for k in definedProps.keys():
			if props.has_key(k):
				definedProps[k].set(props[k])
			else:
				definedProps[k].set(None)
        	return

	def help(self,*options):
		distribution=self.getDistribution()
		browser=sysSetting['browser'][distribution]
		urlbase=sysSetting['docs'][distribution]
		if distribution=="suse" or distribution=="debian":
			url=urlbase % ('globs.html')
		else:
			url=urlbase % (self.getVersion(),'globs.html')
		os.spawnv(os.P_NOWAIT,browser,[browser,url])
		return

	def getVersion(self):
		cl=sysSetting['getVersion']
		status,output=self.runToString(cl)
		return output

	def about(self,*options):
		self.aboutDialog.show()
		return

	#######################################################################
	#	HELPERS
	#######################################################################
		
	def runToString(self,cl):
		status,output=self.runner.runToString(cl)
		return status,output

	def exists(self,path):
		cl=sysSetting['exists']
		cl=cl.replace('%FSOBJECT%',path)
		status,output=self.runToString(cl)
		if not status:
			return False
		output=output.strip('\n\r ')
		return output=='true'
		
	def getConf(self):
		cl=sysSetting['readFile']
		cl=cl.replace('%FILE%','/etc/samba/smb.conf')
		status,output=self.runToString(cl)
		if not status:
			return []
		output=output.strip('\n\r ')
		return output.splitlines()

	def setConf(self,lines):
		text='\n'.join(lines)
		cl=sysSetting['writeFile']
		cl=cl.replace('%TEXT%',text)
		cl=cl.replace('%FILE%','/etc/samba/smb.conf')
		status,output=self.runToString(cl)
		return
				
	def getUsers(self):
		cl=sysSetting['getUsers']
	        status,output=self.runToString(cl)
		if not status:
			return []
		output=output.strip('\n\r ')
		users=output.splitlines()
		return users
	
	def getGroups(self):
		cl=sysSetting['getGroups']
	        status,output=self.runToString(cl)
		if not status:
			return []
		output=output.strip('\n\r ')
		groups=output.splitlines()
		return groups

	def getSep(self):
		cl=sysSetting['getSep']
		status,output=self.runToString(cl)
		if status:
			return output.strip('\n\r ')
		return ''

	def getDomain(self):
		cl=sysSetting['getDomain']
		status,output=self.runToString(cl)
		if status:
			return output.strip('\n\r ')
		return ''

	def inDomain(self,subject,isUser):
		if self.uidRange==[]:
			self.uidRange=self.getUidRange()
		if self.gidRange==[]:
			self.gidRange=self.getGidRange()

		if isUser:
			cl=sysSetting['getUserId']
			cl=cl.replace('%USER%',subject)
		else:
			cl=sysSetting['getGroupId']
			cl=cl.replace('%GROUP%',subject)
	        status,output=self.runToString(cl)
		if not status:
			return False
		try:
			subjectid=int(output.strip('\n\r '))
		except:
			return False;
		if isUser:
			domainrange=self.uidRange
		else:
			domainrange=self.gidRange
		return domainrange[0]<=subjectid<=domainrange[1]
	
	def getUidRange(self):
		cl=sysSetting['getUidRange']
	        status,output=self.runToString(cl)
		if not status or output=="":	
			return 10000,60000
		else:
			low,high=output.strip('\n\r ').split('-')
			return [int(low),int(high)]
		
	def getGidRange(self):
		cl=sysSetting['getGidRange']
	        status,output=self.runToString(cl)
		if not status or output=="":	
			return 10000,60000
		else:
			low,high=output.strip('\n\r ').split('-')
			return [int(low),int(high)]
		
	def getDistribution(self):
		cl=sysSetting['getDistribution']
		status,output=self.runToString(cl)
		if status:
			return output.strip('\n\r ')
		return 'default'

	def signalSmb(self):
		cl=sysSetting['signalSmb']
	        status,output=self.runToString(cl)
		return status,output

	def signalNmb(self):
		cl=sysSetting['signalNmb']
	        status,output=self.runToString(cl)
		return status,output

	def signalWinbind(self):
		cl=sysSetting['signalWinbind']
	        status,output=self.runToString(cl)
		return status,output

#######################################################################
#	MAIN
#######################################################################

import sys
import os

if __name__ == "__main__":
	
	e=sys.argv[0]
	e=os.path.realpath(e)
	d=os.path.dirname(e)
	os.chdir(d)
	s=GlobalsManager()
	s.refresh()

	gtk.main()

__author__='Bernard Bou <bou@ac-toulouse.fr>'
