#!/bin/bash
# bbou@ac-toulouse.fr
# 2007-04-06  
# start.sh

function readlink2()
{
	[ ! -L $1 ] || ls -l $1 | sed s/.*-\>\ *//g
}

function followlink()
{
	prg="$1"
	while [ -h "$prg" ] ; do
		ls=`ls -ld "$prg"`
		link=`expr "$ls" : '.*-> \(.*\)$'`
		if expr "$link" : '.*/.*' > /dev/null; then
			prg="$link"
		else
			prg=`dirname "$prg"`/"$link"
		fi
	done
	echo $prg
}

function absdir() 
{ 
	[ -n "$1" ] && ( cd "$1" 2> /dev/null && pwd ; ) 
}

where=`followlink $0`
where=`dirname ${where}`
where=`absdir ${where}`
cd ${where}

function gettarball()
{
	where=`absdir ..`
	find ${where} -name "sadms-*.tar.gz" ! -name "*install*" | sort | tail -n 1
}

function getpackagerpm()
{
	where=`absdir ..`
	find ${where}/ -name "sadms*$1*.${PACKAGEEXT}" ! -name "*src*" | sort | tail -n 1
}

function getpackagedeb()
{
	where=`absdir ..`
	find ${where}/$1/ -name "sadms*.${PACKAGEEXT}" | sort | tail -n 1
}

function usetarball
{
	tarball=`gettarball`
	if [ ! -z "${tarball}" ];then
		echo "installing tarball ${tarball}"
		v=`echo ${tarball} | sed 's/.*sadms-\([0-9\.]*\)\.tar\.gz/\1/g'`
		pushd ../.. > /dev/null
		tar xvzf sadms-${v}/sadms-${v}.tar.gz
		pushd sadms-${v} > /dev/null
		make install
		popd > /dev/null
		popd > /dev/null
		return $?
	else
		echo "tarball not found"
		return 1
	fi
}

function usepackagerpm()
{
	package="$1"
	if [ ! -z "${package}" ];then
		echo "installing package ${package}"
		${PACKAGEINSTALLFILE} ${package}
		return 0
	else
		echo "package not found"
		usetarball
		return $?
	fi
}

function usepackagedeb()
{
	package="$1"
	if [ ! -z "${package}" ];then
		echo "installing package ${package}"
		${PACKAGEINSTALLFILE} ${package}
		return 0
	else
		echo "package not found"
		usetarball
		return $?
	fi
}

#  I N C L U D E

. ./_include-distribution.sh

# S T A R T

# I N F O
echo "OS=${OS}"
echo "KERNEL=${KERNEL}"
echo "ARCHITECTURE=${ARCHITECTURE}"
echo "DISTRIBUTION=${DISTRIBUTION}"
echo "DISTRIBUTIONTAG=${DISTRIBUTIONTAG}"
echo "DISTRIBUTIONVERSION=${DISTRIBUTIONVERSION}"

case ${DISTRIBUTION} in
	Redhat)
		gc="getpackagerpm rh"
		rc="usepackagerpm"
		;;
	Fedora)
		gc="getpackagerpm fc"
		rc="usepackagerpm"
		;;
	Mandriva)
		gc="getpackagerpm mdk"
		rc="usepackagerpm"
		;;
	Debian)
		gc="getpackagedeb debian"
		rc="usepackagedeb"
		;;
	Ubuntu)
		gc="getpackagedeb ubuntu"
		rc="usepackagedeb"
		;;
	Suse)
		gc="getpackagerpm suse"
		rc="usepackagerpm"
		;;
	*)
		echo "Unsupported distribution : no package available"
		exit 1
		;;
esac

echo "+P A C K A G E    S E L E C T I O N"
package=`eval ${gc}`
echo "select package ${package}"

echo "+P R E I N S T A L L"
if ! ./_preinstall.sh ${package}; then
 	echo preinstall failed
 	read -p "continue (y/n) ? " yes
 	if [ "${yes}" != "y" -a "${yes}" != "Y" ];then
 		exit 1
 	fi
fi

echo "+C H E C K"
if  ! ./_check-samba.sh; then
	echo samba is not properly configured
	exit 1
fi

# P A C K A G E
echo "+I N S T A L L   S A D M S"
if ! ${PACKAGETEST} sadms > /dev/null 2>/dev/null; then
	if ! eval "${rc} ${package}"; then
		exit 1
	fi
else
	version=`${PACKAGEVERSION} sadms`
	echo "version ${version} is already installed"
fi

# S T A R T
read -p "start sadms (y/n) ?" answer
if [ "${answer}" == "y" ]; then
echo "+S T A R T I N G   S A D M S"
echo "to start sadms, run 'sadms' as root"
fi

