#!/usr/bin/perl
# Helper to set a global option in the samba configuration file
# Eventually this should be replaced by a call to samba-tool, but
# for the moment that doesn't support setting individual configuration options.

use warnings;
require File::Temp;
use File::Temp ();
use File::Copy qw(move);

if ($#ARGV < 1) {
	print STDERR "Usage: $0 option value\n";
	exit(1);
}

my $key = $ARGV[0];
my $value = $ARGV[1];
my $inglobal = 0;
my $done = 0;
my $dest = "/etc/samba/smb.conf";

open(IN, "<$dest") or die("unable to open smb.conf");
$out = File::Temp->new(UNLINK => 0);

foreach (<IN>) {
	if (/^\s*\[([^]]+)\]$/) {
		if ($inglobal and (not $done)) {
			print $out "  $key = $value\n";
			$done = 1;
		}
		$inglobal = ($1 eq "global" or $1 eq "globals");
	} elsif (s/^(\s*)$key(\s*)=.*$/$1$key$2= $value/) {
		$done = 1;
	}
	print $out $_;
}

unless ($done) {
	print $out "$key = $value\n";
}

close($out);

move($out->filename, $dest) or die("Unable to rename $out->filename over $dest: $!");

0;
