/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.jline.internal;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import scala.tools.jline.internal.Log;

public final class Configuration {
    public static final String JLINE_RC = ".jline.rc";
    private static final Properties userprops;

    private static boolean isEmpty(String string) {
        return string == null || string.trim().length() == 0;
    }

    public static String getString(String string, String string2) {
        assert (string != null);
        String string3 = System.getProperty(string);
        if (Configuration.isEmpty(string3) && Configuration.isEmpty(string3 = userprops.getProperty(string))) {
            string3 = string2;
        }
        return string3;
    }

    public static String getString(String string) {
        return Configuration.getString(string, null);
    }

    public static Boolean getBoolean(String string, Boolean bl) {
        String string2 = Configuration.getString(string);
        if (Configuration.isEmpty(string2)) {
            return bl;
        }
        return Boolean.valueOf(string2);
    }

    public static Boolean getBoolean(String string) {
        return Configuration.getBoolean(string, null);
    }

    public static File getUserHome() {
        return new File(System.getProperty("user.home"));
    }

    public static String getOsName() {
        return System.getProperty("os.name").toLowerCase();
    }

    public static String getFileEncoding() {
        return System.getProperty("file.encoding");
    }

    public static String getInputEncoding() {
        return System.getProperty("input.encoding", "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Properties properties = new Properties();
        File file = new File(Configuration.getUserHome(), JLINE_RC);
        if (file.exists() && file.canRead()) {
            try {
                BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
                try {
                    properties.load(bufferedInputStream);
                    Log.debug("Loaded user configuration: ", file);
                }
                finally {
                    ((InputStream)bufferedInputStream).close();
                }
            }
            catch (IOException iOException) {
                Log.warn("Unable to read user configuration: ", file, iOException);
            }
        } else {
            Log.trace("User configuration file missing or unreadable: ", file);
        }
        userprops = properties;
    }
}

