/*
 * Decompiled with CFR 0.152.
 */
package org.scalatest.concurrent;

import java.io.Serializable;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.scalatest.NotAllowedException;
import org.scalatest.Resources$;
import org.scalatest.StackDepthExceptionHelper$;
import org.scalatest.concurrent.Conductor$;
import org.scalatest.concurrent.Conductor$Clock$;
import org.scalatest.concurrent.Conductor$ClockThread$;
import org.scalatest.concurrent.Conductor$ConductorState$;
import org.scalatest.concurrent.Conductor$Setup$;
import org.scalatest.concurrent.Conductor$TestFinished$;
import org.scalatest.concurrent.Conductor$TestStarted$;
import org.scalatest.concurrent.Conductor$TestThread$;
import org.scalatest.concurrent.PimpedReadWriteLock$;
import org.scalatest.concurrent.PimpedThreadGroup$;
import org.scalatest.concurrent.TestThreadsStartingCounter;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Product;
import scala.ScalaObject;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BooleanRef;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Conductor
implements ScalaObject {
    private /* synthetic */ Conductor$TestFinished$ TestFinished$module;
    private /* synthetic */ Conductor$TestStarted$ TestStarted$module;
    private /* synthetic */ Conductor$Setup$ Setup$module;
    private /* synthetic */ Conductor$TestThread$ TestThread$module;
    private /* synthetic */ Conductor$ClockThread$ ClockThread$module;
    private /* synthetic */ Conductor$ConductorState$ ConductorState$module;
    private final AtomicReference<ConductorState> currentState;
    private final CountDownLatch org$scalatest$concurrent$Conductor$$greenLightForTestThreads;
    private final TestThreadsStartingCounter org$scalatest$concurrent$Conductor$$testThreadsStartingCounter;
    private final ArrayBlockingQueue org$scalatest$concurrent$Conductor$$firstExceptionThrown;
    private final Thread org$scalatest$concurrent$Conductor$$mainThread;
    private final CopyOnWriteArrayList<String> threadNames;
    private final CopyOnWriteArrayList<Thread> threads;
    private final ThreadGroup org$scalatest$concurrent$Conductor$$threadGroup;
    private final Clock org$scalatest$concurrent$Conductor$$clock = new Clock();

    public Conductor() {
        this.org$scalatest$concurrent$Conductor$$threadGroup = new ThreadGroup("Orchestra");
        this.threads = new CopyOnWriteArrayList();
        this.threadNames = new CopyOnWriteArrayList();
        this.org$scalatest$concurrent$Conductor$$mainThread = Predef$.MODULE$.currentThread();
        this.org$scalatest$concurrent$Conductor$$firstExceptionThrown = new ArrayBlockingQueue(1);
        this.org$scalatest$concurrent$Conductor$$testThreadsStartingCounter = new TestThreadsStartingCounter();
        this.org$scalatest$concurrent$Conductor$$greenLightForTestThreads = new CountDownLatch(1);
        this.currentState = new AtomicReference<Conductor$Setup$>(this.org$scalatest$concurrent$Conductor$$Setup());
    }

    public final Conductor$TestFinished$ org$scalatest$concurrent$Conductor$$TestFinished() {
        if (this.TestFinished$module == null) {
            this.TestFinished$module = new Conductor$TestFinished$(this);
        }
        return this.TestFinished$module;
    }

    public final Conductor$TestStarted$ org$scalatest$concurrent$Conductor$$TestStarted() {
        if (this.TestStarted$module == null) {
            this.TestStarted$module = new Conductor$TestStarted$(this);
        }
        return this.TestStarted$module;
    }

    public final Conductor$Setup$ org$scalatest$concurrent$Conductor$$Setup() {
        if (this.Setup$module == null) {
            this.Setup$module = new Conductor$Setup$(this);
        }
        return this.Setup$module;
    }

    private void waitForThreads() {
        BooleanRef interrupted$1 = new BooleanRef(false);
        while (!interrupted$1.elem && PimpedThreadGroup$.MODULE$.threadGroupToPimpedThreadGroup(this.org$scalatest$concurrent$Conductor$$threadGroup()).areAnyThreadsAlive()) {
            PimpedThreadGroup$.MODULE$.threadGroupToPimpedThreadGroup(this.org$scalatest$concurrent$Conductor$$threadGroup()).getThreads().foreach((Function1)new $anonfun$waitForThreads$1(this, interrupted$1));
        }
    }

    public void conduct(int clockPeriod, int timeout) {
        if (clockPeriod <= 0) {
            throw new NotAllowedException(Resources$.MODULE$.apply("cannotPassNonPositiveClockPeriod", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{((Object)BoxesRunTime.boxToInteger((int)clockPeriod)).toString()})), StackDepthExceptionHelper$.MODULE$.getStackDepth("Conductor.scala", "conduct"));
        }
        if (timeout <= 0) {
            throw new NotAllowedException(Resources$.MODULE$.apply("cannotPassNonPositiveTimeout", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{((Object)BoxesRunTime.boxToInteger((int)timeout)).toString()})), StackDepthExceptionHelper$.MODULE$.getStackDepth("Conductor.scala", "conduct"));
        }
        if (this.conductingHasBegun()) {
            throw new NotAllowedException(Resources$.MODULE$.apply("cannotCallConductTwice"), StackDepthExceptionHelper$.MODULE$.getStackDepth("Conductor.scala", "conduct"));
        }
        this.currentState().set(this.org$scalatest$concurrent$Conductor$$TestStarted());
        this.org$scalatest$concurrent$Conductor$$testThreadsStartingCounter().waitUntilAllTestThreadsHaveStarted();
        this.org$scalatest$concurrent$Conductor$$greenLightForTestThreads().countDown();
        ClockThread clockThread = new ClockThread(this, clockPeriod, timeout);
        clockThread.start();
        this.waitForThreads();
        this.currentState().set(this.org$scalatest$concurrent$Conductor$$TestFinished());
        if (this.org$scalatest$concurrent$Conductor$$firstExceptionThrown().isEmpty()) {
            return;
        }
        throw (Throwable)this.org$scalatest$concurrent$Conductor$$firstExceptionThrown().peek();
    }

    public boolean conductingHasBegun() {
        return this.currentState().get().testWasStarted();
    }

    private AtomicReference<ConductorState> currentState() {
        return this.currentState;
    }

    public void conduct() {
        int DefaultClockPeriod = 10;
        int DefaultRunLimit = 5;
        this.conduct(DefaultClockPeriod, DefaultRunLimit);
    }

    public final CountDownLatch org$scalatest$concurrent$Conductor$$greenLightForTestThreads() {
        return this.org$scalatest$concurrent$Conductor$$greenLightForTestThreads;
    }

    public final TestThreadsStartingCounter org$scalatest$concurrent$Conductor$$testThreadsStartingCounter() {
        return this.org$scalatest$concurrent$Conductor$$testThreadsStartingCounter;
    }

    public boolean isConductorFrozen() {
        return this.org$scalatest$concurrent$Conductor$$clock().isFrozen();
    }

    public <T> void withConductorFrozen(Function0<T> fun) {
        this.org$scalatest$concurrent$Conductor$$clock().withClockFrozen(fun);
    }

    public int beat() {
        return this.org$scalatest$concurrent$Conductor$$clock().currentBeat();
    }

    public void waitForBeat(int beat) {
        if (beat == 0) {
            throw new NotAllowedException(Resources$.MODULE$.apply("cannotWaitForBeatZero"), StackDepthExceptionHelper$.MODULE$.getStackDepth("Conductor.scala", "waitForBeat"));
        }
        if (beat < 0) {
            throw new NotAllowedException(Resources$.MODULE$.apply("cannotWaitForNegativeBeat"), StackDepthExceptionHelper$.MODULE$.getStackDepth("Conductor.scala", "waitForBeat"));
        }
        this.org$scalatest$concurrent$Conductor$$clock().waitForBeat(beat);
    }

    public void whenFinished(Function0<Object> fun) {
        Thread thread2 = Predef$.MODULE$.currentThread();
        Thread thread3 = this.org$scalatest$concurrent$Conductor$$mainThread();
        if (!(thread2 != null ? !thread2.equals(thread3) : thread3 != null)) {
            if (this.conductingHasBegun()) {
                throw new NotAllowedException(Resources$.MODULE$.apply("cannotInvokeWhenFinishedAfterConduct"), StackDepthExceptionHelper$.MODULE$.getStackDepth("Conductor.scala", "whenFinished"));
            }
            this.conduct();
            fun.apply();
            return;
        }
        throw new NotAllowedException(Resources$.MODULE$.apply("whenFinishedCanOnlyBeCalledByMainThread"), StackDepthExceptionHelper$.MODULE$.getStackDepth("Conductor.scala", "whenFinished"));
    }

    public final ArrayBlockingQueue org$scalatest$concurrent$Conductor$$firstExceptionThrown() {
        return this.org$scalatest$concurrent$Conductor$$firstExceptionThrown;
    }

    public Thread thread(String name, Function0<Object> fun) {
        ConductorState temp1;
        ConductorState conductorState = temp1 = this.currentState().get();
        Conductor$TestFinished$ conductor$TestFinished$ = this.org$scalatest$concurrent$Conductor$$TestFinished();
        if (!(conductorState != null ? !((Object)conductorState).equals(conductor$TestFinished$) : conductor$TestFinished$ != null)) {
            if (true) {
                throw new NotAllowedException(Resources$.MODULE$.apply("threadCalledAfterConductingHasCompleted"), StackDepthExceptionHelper$.MODULE$.getStackDepth("Conductor.scala", "thread"));
            }
            throw new MatchError(temp1.toString());
        }
        if (true) {
            if (this.threadNames().contains(name)) {
                throw new NotAllowedException(Resources$.MODULE$.apply("cantRegisterThreadsWithSameName", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{name})), StackDepthExceptionHelper$.MODULE$.getStackDepth("Conductor.scala", "thread"));
            }
            TestThread t = new TestThread(this, name, fun);
            this.threads().add(t);
            this.threadNames().add(name);
            t.start();
            return t;
        }
        throw new MatchError(temp1.toString());
    }

    public Thread thread(Function0<Object> fun) {
        return this.thread(new StringBuilder().append((Object)"Conductor-Thread-").append((Object)BoxesRunTime.boxToInteger((int)this.threads().size())).toString(), fun);
    }

    public final Thread org$scalatest$concurrent$Conductor$$mainThread() {
        return this.org$scalatest$concurrent$Conductor$$mainThread;
    }

    private final CopyOnWriteArrayList<String> threadNames() {
        return this.threadNames;
    }

    private final CopyOnWriteArrayList<Thread> threads() {
        return this.threads;
    }

    public final ThreadGroup org$scalatest$concurrent$Conductor$$threadGroup() {
        return this.org$scalatest$concurrent$Conductor$$threadGroup;
    }

    public final Clock org$scalatest$concurrent$Conductor$$clock() {
        return this.org$scalatest$concurrent$Conductor$$clock;
    }

    private final /* synthetic */ Conductor$TestThread$ TestThread() {
        if (this.TestThread$module == null) {
            this.TestThread$module = new Conductor$TestThread$(this);
        }
        return this.TestThread$module;
    }

    private final /* synthetic */ Conductor$ClockThread$ ClockThread() {
        if (this.ClockThread$module == null) {
            this.ClockThread$module = new Conductor$ClockThread$(this);
        }
        return this.ClockThread$module;
    }

    private final /* synthetic */ Conductor$ConductorState$ ConductorState() {
        if (this.ConductorState$module == null) {
            this.ConductorState$module = new Conductor$ConductorState$(this);
        }
        return this.ConductorState$module;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Clock
    implements ScalaObject {
        private int highestBeatBeingWaitedOn;
        private final ReentrantReadWriteLock rwLock;
        private final Object lock;
        private int org$scalatest$concurrent$Conductor$Clock$$currentTime;

        public Clock() {
            if (Conductor.this == null) {
                throw new NullPointerException();
            }
            this.org$scalatest$concurrent$Conductor$Clock$$currentTime = 0;
            this.lock = new Object();
            this.rwLock = new ReentrantReadWriteLock();
            this.highestBeatBeingWaitedOn = 0;
        }

        private final void liftedTree1$1() {
            try {
                this.lock().wait();
                return;
            }
            catch (InterruptedException interruptedException) {
                throw new AssertionError((Object)interruptedException);
            }
        }

        public /* synthetic */ Conductor org$scalatest$concurrent$Conductor$Clock$$$outer() {
            return Conductor.this;
        }

        public boolean isFrozen() {
            return this.rwLock().getReadLockCount() > 0;
        }

        public <T> T withClockFrozen(Function0<T> fun) {
            return PimpedReadWriteLock$.MODULE$.pimpMyReadWriteLock(this.rwLock()).read(fun);
        }

        public boolean isAnyThreadWaitingForABeat() {
            Object object = this.lock();
            synchronized (object) {
                return BoxesRunTime.unboxToBoolean((Object)BoxesRunTime.boxToBoolean((this.highestBeatBeingWaitedOn() > this.org$scalatest$concurrent$Conductor$Clock$$currentTime() ? 1 : 0) != 0));
            }
        }

        public void waitForBeat(int beat) {
            Object object = this.lock();
            synchronized (object) {
                if (beat > this.highestBeatBeingWaitedOn()) {
                    this.highestBeatBeingWaitedOn_$eq(beat);
                }
                while (this.currentBeat() < beat) {
                    this.liftedTree1$1();
                }
                return;
            }
        }

        public int currentBeat() {
            Object object = this.lock();
            synchronized (object) {
                return BoxesRunTime.unboxToInt(PimpedReadWriteLock$.MODULE$.pimpMyReadWriteLock(this.rwLock()).read(new Clock$$anonfun$currentBeat$1(this)));
            }
        }

        public void advance() {
            Object object = this.lock();
            synchronized (object) {
                PimpedReadWriteLock$.MODULE$.pimpMyReadWriteLock(this.rwLock()).write(new Clock$$anonfun$advance$1(this));
                this.lock().notifyAll();
                return;
            }
        }

        private void highestBeatBeingWaitedOn_$eq(int n) {
            this.highestBeatBeingWaitedOn = n;
        }

        private int highestBeatBeingWaitedOn() {
            return this.highestBeatBeingWaitedOn;
        }

        private ReentrantReadWriteLock rwLock() {
            return this.rwLock;
        }

        private Object lock() {
            return this.lock;
        }

        public final void org$scalatest$concurrent$Conductor$Clock$$currentTime_$eq(int n) {
            this.org$scalatest$concurrent$Conductor$Clock$$currentTime = n;
        }

        public final int org$scalatest$concurrent$Conductor$Clock$$currentTime() {
            return this.org$scalatest$concurrent$Conductor$Clock$$currentTime;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class TestThread
    extends Thread
    implements ScalaObject,
    Product,
    Serializable {
        public final /* synthetic */ Conductor $outer;
        private final Function0<Object> f;
        private final String name;

        public TestThread(Conductor $outer, String name, Function0<Object> f) {
            this.name = name;
            this.f = f;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            super($outer.org$scalatest$concurrent$Conductor$$threadGroup(), name);
            Product.class.$init$((Product)this);
            $outer.org$scalatest$concurrent$Conductor$$testThreadsStartingCounter().increment();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final /* synthetic */ boolean gd1$1(String string, Function0 function0) {
            String string2 = string;
            String string3 = this.name();
            if (string2 == null) {
                if (string3 != null) {
                    return false;
                }
            } else if (!string2.equals(string3)) return false;
            Function0 function02 = function0;
            Function0<Object> function03 = this.f();
            if (function02 == null) {
                if (function03 == null) return true;
                return false;
            } else {
                if (!function02.equals(function03)) return false;
                return true;
            }
        }

        public /* synthetic */ Conductor org$scalatest$concurrent$Conductor$TestThread$$$outer() {
            return this.$outer;
        }

        public boolean canEqual(Object object) {
            return object instanceof TestThread;
        }

        public Object productElement(int n) {
            int temp6;
            block6: {
                Object object;
                temp6 = n;
                switch (temp6) {
                    default: {
                        if (true) {
                            throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)n)).toString());
                        }
                        throw new MatchError(((Object)BoxesRunTime.boxToInteger((int)temp6)).toString());
                    }
                    case 1: {
                        if (true) {
                            object = this.f();
                            break;
                        }
                        throw new MatchError(((Object)BoxesRunTime.boxToInteger((int)temp6)).toString());
                    }
                    case 0: {
                        if (!true) break block6;
                        object = this.name();
                    }
                }
                return object;
            }
            throw new MatchError(((Object)BoxesRunTime.boxToInteger((int)temp6)).toString());
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "TestThread";
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object object) {
            Function0<Object> temp5;
            Function0<Object> f$1;
            String name$1;
            String temp4;
            if (this == object) return true;
            Object temp2 = object;
            if (temp2 instanceof TestThread && ((TestThread)temp2).org$scalatest$concurrent$Conductor$TestThread$$$outer() == this.org$scalatest$concurrent$Conductor$TestThread$$$outer()) {
                TestThread temp3 = (TestThread)temp2;
                temp4 = temp3.name();
                name$1 = temp4;
                if (!this.gd1$1(name$1, f$1 = (temp5 = temp3.f()))) {
                    if (!true) throw new MatchError(temp2.toString());
                    return false;
                }
            } else {
                if (!true) throw new MatchError(temp2.toString());
                return false;
            }
            name$1 = temp4;
            f$1 = temp5;
            boolean bl = ((TestThread)object).canEqual(this);
            if (!bl) return false;
            return true;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        @Override
        public void run() {
            block2: {
                try {
                    this.org$scalatest$concurrent$Conductor$TestThread$$$outer().org$scalatest$concurrent$Conductor$$testThreadsStartingCounter().decrement();
                    this.org$scalatest$concurrent$Conductor$TestThread$$$outer().org$scalatest$concurrent$Conductor$$greenLightForTestThreads().await();
                    this.f().apply();
                }
                catch (Throwable throwable) {
                    if (!this.org$scalatest$concurrent$Conductor$TestThread$$$outer().org$scalatest$concurrent$Conductor$$firstExceptionThrown().isEmpty()) break block2;
                    this.org$scalatest$concurrent$Conductor$TestThread$$$outer().org$scalatest$concurrent$Conductor$$firstExceptionThrown().offer(throwable);
                }
            }
        }

        public Function0<Object> f() {
            return this.f;
        }

        public String name() {
            return this.name;
        }

        public /* synthetic */ String copy$default$1() {
            return this.name();
        }

        public /* synthetic */ Function0 copy$default$2() {
            return this.f();
        }

        public /* synthetic */ TestThread copy(String name, Function0 f) {
            return new TestThread(this.org$scalatest$concurrent$Conductor$TestThread$$$outer(), name, (Function0<Object>)f);
        }

        public Iterator productElements() {
            return Product.class.productElements((Product)this);
        }

        public Iterator productIterator() {
            return Product.class.productIterator((Product)this);
        }
    }

    public class ClockThread
    extends Thread
    implements ScalaObject,
    Product,
    Serializable {
        public final /* synthetic */ Conductor $outer;
        private final int MaxDeadlockDetectionsBeforeDeadlock;
        private int deadlockCount;
        private long lastProgress;
        private final int maxRunTime;
        private final int clockPeriod;

        public ClockThread(Conductor $outer, int clockPeriod, int maxRunTime) {
            this.clockPeriod = clockPeriod;
            this.maxRunTime = maxRunTime;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            super("Conductor-Clock");
            Product.class.$init$((Product)this);
            this.setDaemon(true);
            this.lastProgress = System.currentTimeMillis();
            this.deadlockCount = 0;
            this.MaxDeadlockDetectionsBeforeDeadlock = 50;
        }

        private final /* synthetic */ boolean gd2$1(int n, int n2) {
            return n == this.clockPeriod() && n2 == this.maxRunTime();
        }

        public /* synthetic */ Conductor org$scalatest$concurrent$Conductor$ClockThread$$$outer() {
            return this.$outer;
        }

        public boolean canEqual(Object object) {
            return object instanceof ClockThread;
        }

        public Object productElement(int n) {
            int temp11;
            block6: {
                Integer n2;
                temp11 = n;
                switch (temp11) {
                    default: {
                        if (true) {
                            throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)n)).toString());
                        }
                        throw new MatchError(((Object)BoxesRunTime.boxToInteger((int)temp11)).toString());
                    }
                    case 1: {
                        if (true) {
                            n2 = BoxesRunTime.boxToInteger((int)this.maxRunTime());
                            break;
                        }
                        throw new MatchError(((Object)BoxesRunTime.boxToInteger((int)temp11)).toString());
                    }
                    case 0: {
                        if (!true) break block6;
                        n2 = BoxesRunTime.boxToInteger((int)this.clockPeriod());
                    }
                }
                return n2;
            }
            throw new MatchError(((Object)BoxesRunTime.boxToInteger((int)temp11)).toString());
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "ClockThread";
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object object) {
            int temp10;
            int maxRunTime$1;
            int clockPeriod$1;
            int temp9;
            if (this == object) return true;
            Object temp7 = object;
            if (temp7 instanceof ClockThread && ((ClockThread)temp7).org$scalatest$concurrent$Conductor$ClockThread$$$outer() == this.org$scalatest$concurrent$Conductor$ClockThread$$$outer()) {
                ClockThread temp8 = (ClockThread)temp7;
                temp9 = temp8.clockPeriod();
                clockPeriod$1 = temp9;
                if (!this.gd2$1(clockPeriod$1, maxRunTime$1 = (temp10 = temp8.maxRunTime()))) {
                    if (!true) throw new MatchError(temp7.toString());
                    return false;
                }
            } else {
                if (!true) throw new MatchError(temp7.toString());
                return false;
            }
            clockPeriod$1 = temp9;
            maxRunTime$1 = temp10;
            boolean bl = ((ClockThread)object).canEqual(this);
            if (!bl) return false;
            return true;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        private void detectDeadlock() {
            if (this.deadlockCount() >= this.MaxDeadlockDetectionsBeforeDeadlock()) {
                String errorMessage = Resources$.MODULE$.apply("suspectedDeadlock", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{((Object)BoxesRunTime.boxToInteger((int)this.MaxDeadlockDetectionsBeforeDeadlock())).toString(), ((Object)BoxesRunTime.boxToInteger((int)(this.clockPeriod() * this.MaxDeadlockDetectionsBeforeDeadlock()))).toString()}));
                this.org$scalatest$concurrent$Conductor$ClockThread$$$outer().org$scalatest$concurrent$Conductor$$firstExceptionThrown().offer(new RuntimeException(errorMessage));
                this.org$scalatest$concurrent$Conductor$ClockThread$$$outer().org$scalatest$concurrent$Conductor$$mainThread().interrupt();
            } else {
                this.deadlockCount_$eq(this.deadlockCount() + 1);
            }
        }

        private void timeout() {
            String errorMessage = Resources$.MODULE$.apply("testTimedOut", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{((Object)BoxesRunTime.boxToInteger((int)this.maxRunTime())).toString()}));
            this.org$scalatest$concurrent$Conductor$ClockThread$$$outer().org$scalatest$concurrent$Conductor$$firstExceptionThrown().offer(new RuntimeException(errorMessage));
            this.org$scalatest$concurrent$Conductor$ClockThread$$$outer().org$scalatest$concurrent$Conductor$$mainThread().interrupt();
        }

        private boolean runningTooLong() {
            return System.currentTimeMillis() - this.lastProgress() > 1000L * (long)this.maxRunTime();
        }

        public void run() {
            while (PimpedThreadGroup$.MODULE$.threadGroupToPimpedThreadGroup(this.org$scalatest$concurrent$Conductor$ClockThread$$$outer().org$scalatest$concurrent$Conductor$$threadGroup()).areAnyThreadsAlive()) {
                if (this.org$scalatest$concurrent$Conductor$ClockThread$$$outer().org$scalatest$concurrent$Conductor$$firstExceptionThrown().isEmpty()) {
                    if (PimpedThreadGroup$.MODULE$.threadGroupToPimpedThreadGroup(this.org$scalatest$concurrent$Conductor$ClockThread$$$outer().org$scalatest$concurrent$Conductor$$threadGroup()).areAnyThreadsRunning()) {
                        if (this.runningTooLong()) {
                            this.timeout();
                        }
                    } else if (this.org$scalatest$concurrent$Conductor$ClockThread$$$outer().org$scalatest$concurrent$Conductor$$clock().isAnyThreadWaitingForABeat()) {
                        this.org$scalatest$concurrent$Conductor$ClockThread$$$outer().org$scalatest$concurrent$Conductor$$clock().advance();
                        this.deadlockCount_$eq(0);
                        this.lastProgress_$eq(System.currentTimeMillis());
                    } else if (!PimpedThreadGroup$.MODULE$.threadGroupToPimpedThreadGroup(this.org$scalatest$concurrent$Conductor$ClockThread$$$outer().org$scalatest$concurrent$Conductor$$threadGroup()).areAnyThreadsInTimedWaiting()) {
                        this.detectDeadlock();
                    }
                } else {
                    PimpedThreadGroup$.MODULE$.threadGroupToPimpedThreadGroup(this.org$scalatest$concurrent$Conductor$ClockThread$$$outer().org$scalatest$concurrent$Conductor$$threadGroup()).getThreads().foreach((Function1)new ClockThread$$anonfun$run$1(this));
                }
                Thread.sleep(this.clockPeriod());
            }
        }

        private int MaxDeadlockDetectionsBeforeDeadlock() {
            return this.MaxDeadlockDetectionsBeforeDeadlock;
        }

        private void deadlockCount_$eq(int n) {
            this.deadlockCount = n;
        }

        private int deadlockCount() {
            return this.deadlockCount;
        }

        private void lastProgress_$eq(long l) {
            this.lastProgress = l;
        }

        private long lastProgress() {
            return this.lastProgress;
        }

        public int maxRunTime() {
            return this.maxRunTime;
        }

        public int clockPeriod() {
            return this.clockPeriod;
        }

        public /* synthetic */ int copy$default$1() {
            return this.clockPeriod();
        }

        public /* synthetic */ int copy$default$2() {
            return this.maxRunTime();
        }

        public /* synthetic */ ClockThread copy(int clockPeriod, int maxRunTime) {
            return new ClockThread(this.org$scalatest$concurrent$Conductor$ClockThread$$$outer(), clockPeriod, maxRunTime);
        }

        public Iterator productElements() {
            return Product.class.productElements((Product)this);
        }

        public Iterator productIterator() {
            return Product.class.productIterator((Product)this);
        }
    }

    public class ConductorState
    implements ScalaObject,
    Product,
    Serializable {
        public final /* synthetic */ Conductor $outer;
        private final boolean testIsFinished;
        private final boolean testWasStarted;

        public ConductorState(Conductor $outer, boolean testWasStarted, boolean testIsFinished) {
            this.testWasStarted = testWasStarted;
            this.testIsFinished = testIsFinished;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            Product.class.$init$((Product)this);
        }

        private final /* synthetic */ boolean gd3$1(boolean bl, boolean bl2) {
            return bl == this.testWasStarted() && bl2 == this.testIsFinished();
        }

        public /* synthetic */ Conductor org$scalatest$concurrent$Conductor$ConductorState$$$outer() {
            return this.$outer;
        }

        public boolean canEqual(Object object) {
            return object instanceof ConductorState;
        }

        public Object productElement(int n) {
            int temp16;
            block6: {
                Boolean bl;
                temp16 = n;
                switch (temp16) {
                    default: {
                        if (true) {
                            throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)n)).toString());
                        }
                        throw new MatchError(((Object)BoxesRunTime.boxToInteger((int)temp16)).toString());
                    }
                    case 1: {
                        if (true) {
                            bl = BoxesRunTime.boxToBoolean((boolean)this.testIsFinished());
                            break;
                        }
                        throw new MatchError(((Object)BoxesRunTime.boxToInteger((int)temp16)).toString());
                    }
                    case 0: {
                        if (!true) break block6;
                        bl = BoxesRunTime.boxToBoolean((boolean)this.testWasStarted());
                    }
                }
                return bl;
            }
            throw new MatchError(((Object)BoxesRunTime.boxToInteger((int)temp16)).toString());
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "ConductorState";
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object object) {
            boolean temp15;
            boolean testIsFinished$1;
            boolean testWasStarted$1;
            boolean temp14;
            if (this == object) return true;
            Object temp12 = object;
            if (temp12 instanceof ConductorState && ((ConductorState)temp12).org$scalatest$concurrent$Conductor$ConductorState$$$outer() == this.org$scalatest$concurrent$Conductor$ConductorState$$$outer()) {
                ConductorState temp13 = (ConductorState)temp12;
                temp14 = temp13.testWasStarted();
                testWasStarted$1 = temp14;
                if (!this.gd3$1(testWasStarted$1, testIsFinished$1 = (temp15 = temp13.testIsFinished()))) {
                    if (!true) throw new MatchError(temp12.toString());
                    return false;
                }
            } else {
                if (!true) throw new MatchError(temp12.toString());
                return false;
            }
            testWasStarted$1 = temp14;
            testIsFinished$1 = temp15;
            boolean bl = ((ConductorState)object).canEqual(this);
            if (!bl) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public boolean testIsFinished() {
            return this.testIsFinished;
        }

        public boolean testWasStarted() {
            return this.testWasStarted;
        }

        public /* synthetic */ boolean copy$default$1() {
            return this.testWasStarted();
        }

        public /* synthetic */ boolean copy$default$2() {
            return this.testIsFinished();
        }

        public /* synthetic */ ConductorState copy(boolean testWasStarted, boolean testIsFinished) {
            return new ConductorState(this.org$scalatest$concurrent$Conductor$ConductorState$$$outer(), testWasStarted, testIsFinished);
        }

        public Iterator productElements() {
            return Product.class.productElements((Product)this);
        }

        public Iterator productIterator() {
            return Product.class.productIterator((Product)this);
        }
    }
}

