/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.lamp.fjbg;

import ch.epfl.lamp.fjbg.JObjectType;
import ch.epfl.lamp.fjbg.JReferenceType;
import ch.epfl.lamp.fjbg.JType;

public class JArrayType
extends JReferenceType {
    protected final JType elementType;
    protected String signature = null;
    public static JArrayType BOOLEAN = new JArrayType(JType.BOOLEAN);
    public static JArrayType BYTE = new JArrayType(JType.BYTE);
    public static JArrayType CHAR = new JArrayType(JType.CHAR);
    public static JArrayType SHORT = new JArrayType(JType.SHORT);
    public static JArrayType INT = new JArrayType(JType.INT);
    public static JArrayType FLOAT = new JArrayType(JType.FLOAT);
    public static JArrayType LONG = new JArrayType(JType.LONG);
    public static JArrayType DOUBLE = new JArrayType(JType.DOUBLE);
    public static JArrayType REFERENCE = new JArrayType(JType.REFERENCE);

    public JArrayType(JType elementType) {
        this.elementType = elementType;
    }

    public int getSize() {
        return 1;
    }

    public String getSignature() {
        if (this.signature == null) {
            this.signature = "[" + this.elementType.getSignature();
        }
        return this.signature;
    }

    public String getDescriptor() {
        return this.getSignature();
    }

    public int getTag() {
        return 13;
    }

    public JType getElementType() {
        return this.elementType;
    }

    public String toString() {
        return this.elementType.toString() + "[]";
    }

    public boolean isArrayType() {
        return true;
    }

    public boolean isCompatibleWith(JType other) {
        if (other instanceof JObjectType) {
            return (JObjectType)other == JObjectType.JAVA_LANG_OBJECT;
        }
        if (other instanceof JArrayType) {
            return this.elementType.isCompatibleWith(((JArrayType)other).elementType);
        }
        return other == JType.REFERENCE;
    }
}

