/*
 * Decompiled with CFR 0.152.
 */
package extra166y;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantLock;
import sun.misc.Unsafe;

public class CustomConcurrentHashMap<K, V>
extends AbstractMap<K, V>
implements ConcurrentMap<K, V>,
Serializable {
    private static final long serialVersionUID = 7249069246764182397L;
    public static final Strength STRONG = Strength.strong;
    public static final Strength WEAK = Strength.weak;
    public static final Strength SOFT = Strength.soft;
    private static final String SELF_STRING = "Self";
    private static final String INT_STRING = "Int";
    public static final Equivalence<Object> IDENTITY = new EquivalenceUsingIdentity();
    public static final Equivalence<Object> EQUALS = new EquivalenceUsingEquals();
    static final int SEGMENT_BITS = 6;
    static final int NSEGMENTS = 64;
    static final int SEGMENT_MASK = 63;
    static final int SEGMENT_SHIFT = 26;
    static final int MIN_SEGMENT_CAPACITY = 4;
    static final int MAX_SEGMENT_CAPACITY = 0x4000000;
    volatile transient Segment[] segments;
    final NodeFactory factory;
    final Equivalence<? super K> keyEquivalence;
    final Equivalence<? super V> valueEquivalence;
    final int initialSegmentCapacity;
    transient Set<K> keySet;
    transient Set<Map.Entry<K, V>> entrySet;
    transient Collection<V> values;
    static volatile ReferenceQueue<Object> refQueue;
    static final Unsafe _unsafe;
    static final long tableBase;
    static final int tableShift;
    static final long segmentsBase;
    static final int segmentsShift;

    static {
        try {
            _unsafe = CustomConcurrentHashMap.getUnsafe();
            tableBase = _unsafe.arrayBaseOffset(Node[].class);
            int s = _unsafe.arrayIndexScale(Node[].class);
            if ((s & s - 1) != 0) {
                throw new Error("data type scale not a power of two");
            }
            tableShift = 31 - Integer.numberOfLeadingZeros(s);
            segmentsBase = _unsafe.arrayBaseOffset(Segment[].class);
            s = _unsafe.arrayIndexScale(Segment[].class);
            if ((s & s - 1) != 0) {
                throw new Error("data type scale not a power of two");
            }
            segmentsShift = 31 - Integer.numberOfLeadingZeros(s);
        }
        catch (Throwable e) {
            throw new RuntimeException("Could not initialize intrinsics", e);
        }
    }

    static int spreadHash(int h) {
        h += h << 15 ^ 0xFFFFCD7D;
        h ^= h >>> 10;
        h += h << 3;
        h ^= h >>> 6;
        h += (h << 2) + (h << 14);
        return h ^ h >>> 16;
    }

    CustomConcurrentHashMap(String ks, Equivalence<? super K> keq, String vs, Equivalence<? super V> veq, int expectedSize) {
        if (keq == null || veq == null) {
            throw new NullPointerException();
        }
        this.keyEquivalence = keq;
        this.valueEquivalence = veq;
        String factoryName = String.valueOf(CustomConcurrentHashMap.class.getName()) + "$" + ks + "Key" + vs + "ValueNodeFactory";
        try {
            this.factory = (NodeFactory)Class.forName(factoryName).newInstance();
        }
        catch (Exception ex) {
            throw new Error("Cannot instantiate " + factoryName);
        }
        int es = expectedSize;
        if (es == 0) {
            this.initialSegmentCapacity = 4;
        } else {
            int sc = (int)(1L + 4L * (long)es / 3L >>> 6);
            if (sc < 4) {
                sc = 4;
            }
            int capacity = 4;
            while (capacity < sc) {
                capacity <<= 1;
            }
            if (capacity > 0x4000000) {
                capacity = 0x4000000;
            }
            this.initialSegmentCapacity = capacity;
        }
        this.segments = new Segment[64];
    }

    public CustomConcurrentHashMap(Strength keyStrength, Equivalence<? super K> keyEquivalence, Strength valueStrength, Equivalence<? super V> valueEquivalence, int expectedSize) {
        this(keyStrength.getName(), keyEquivalence, valueStrength.getName(), valueEquivalence, expectedSize);
    }

    public CustomConcurrentHashMap() {
        this(STRONG, EQUALS, STRONG, EQUALS, 0);
    }

    public static <ValueType> CustomConcurrentHashMap<Integer, ValueType> newIntKeyMap(Strength valueStrength, Equivalence<? super ValueType> valueEquivalence, int expectedSize) {
        return new CustomConcurrentHashMap<Object, ValueType>(INT_STRING, EQUALS, valueStrength.getName(), valueEquivalence, expectedSize);
    }

    public static <KeyType> CustomConcurrentHashMap<KeyType, Integer> newIntValueMap(Strength keyStrength, Equivalence<? super KeyType> keyEquivalence, int expectedSize) {
        return new CustomConcurrentHashMap<KeyType, Object>(keyStrength.getName(), keyEquivalence, INT_STRING, EQUALS, expectedSize);
    }

    public static CustomConcurrentHashMap<Integer, Integer> newIntKeyIntValueMap(int expectedSize) {
        return new CustomConcurrentHashMap<Object, Object>(INT_STRING, EQUALS, INT_STRING, EQUALS, expectedSize);
    }

    final Segment getSegmentForTraversal(int hash) {
        return this.segments[hash >>> 26 & 0x3F];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final Segment getSegmentForAdd(int hash) {
        Segment[] segs = this.segments;
        int index = hash >>> 26 & 0x3F;
        Segment seg = segs[index];
        if (seg != null) return seg;
        Segment[] segmentArray = segs;
        synchronized (segs) {
            seg = segs[index];
            if (seg != null) return seg;
            seg = new Segment();
            CustomConcurrentHashMap.storeSegment(segs, index, seg);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return seg;
        }
    }

    final Node findNode(Object key, int hash, Segment seg) {
        Node[] tab;
        if (seg != null && (tab = seg.getTableForTraversal()) != null) {
            Node p = tab[hash & tab.length - 1];
            while (p != null) {
                Object k = p.get();
                if (k == key || k != null && p.getLocator() == hash && this.keyEquivalence.equal(k, key)) {
                    return p;
                }
                p = p.getLinkage();
            }
        }
        return null;
    }

    @Override
    public boolean containsKey(Object key) {
        Segment seg;
        if (key == null) {
            throw new NullPointerException();
        }
        int hash = CustomConcurrentHashMap.spreadHash(this.keyEquivalence.hash(key));
        Node r = this.findNode(key, hash, seg = this.getSegmentForTraversal(hash));
        return r != null && r.getValue() != null;
    }

    @Override
    public V get(Object key) {
        Segment seg;
        if (key == null) {
            throw new NullPointerException();
        }
        int hash = CustomConcurrentHashMap.spreadHash(this.keyEquivalence.hash(key));
        Node r = this.findNode(key, hash, seg = this.getSegmentForTraversal(hash));
        if (r == null) {
            return null;
        }
        return (V)r.getValue();
    }

    final V doPut(K key, V value, boolean onlyIfNull) {
        if (key == null || value == null) {
            throw new NullPointerException();
        }
        Object oldValue = null;
        int hash = CustomConcurrentHashMap.spreadHash(this.keyEquivalence.hash(key));
        Segment seg = this.getSegmentForAdd(hash);
        seg.lock();
        try {
            Node r = this.findNode(key, hash, seg);
            if (r != null) {
                oldValue = r.getValue();
                if (!onlyIfNull || oldValue == null) {
                    r.setValue(value);
                }
            } else {
                Node[] tab = seg.getTableForAdd(this);
                int i = hash & tab.length - 1;
                r = this.factory.newNode(hash, key, value, this, tab[i]);
                CustomConcurrentHashMap.storeNode(tab, i, r);
                seg.incrementCount();
            }
        }
        finally {
            seg.unlock();
        }
        return (V)oldValue;
    }

    @Override
    public V put(K key, V value) {
        return this.doPut(key, value, false);
    }

    @Override
    public V putIfAbsent(K key, V value) {
        return this.doPut(key, value, true);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public V replace(K key, V value) {
        if (key == null || value == null) {
            throw new NullPointerException();
        }
        Object oldValue = null;
        int hash = CustomConcurrentHashMap.spreadHash(this.keyEquivalence.hash(key));
        Segment seg = this.getSegmentForTraversal(hash);
        if (seg != null) {
            seg.lock();
            try {
                Node r = this.findNode(key, hash, seg);
                if (r != null) {
                    oldValue = r.getValue();
                    r.setValue(value);
                }
            }
            finally {
                seg.unlock();
            }
        }
        return (V)oldValue;
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        if (key == null || oldValue == null || newValue == null) {
            throw new NullPointerException();
        }
        boolean replaced = false;
        int hash = CustomConcurrentHashMap.spreadHash(this.keyEquivalence.hash(key));
        Segment seg = this.getSegmentForTraversal(hash);
        if (seg != null) {
            seg.lock();
            try {
                Object v;
                Node r = this.findNode(key, hash, seg);
                if (r != null && ((v = r.getValue()) == oldValue || v != null && this.valueEquivalence.equal(v, oldValue))) {
                    r.setValue(newValue);
                    replaced = true;
                }
            }
            finally {
                seg.unlock();
            }
        }
        return replaced;
    }

    @Override
    public V remove(Object key) {
        Object oldValue;
        block9: {
            if (key == null) {
                throw new NullPointerException();
            }
            oldValue = null;
            int hash = CustomConcurrentHashMap.spreadHash(this.keyEquivalence.hash(key));
            Segment seg = this.getSegmentForTraversal(hash);
            if (seg != null) {
                seg.lock();
                try {
                    Node[] tab = seg.getTableForTraversal();
                    if (tab == null) break block9;
                    int i = hash & tab.length - 1;
                    Node pred = null;
                    Node p = tab[i];
                    while (p != null) {
                        Node n = p.getLinkage();
                        Object k = p.get();
                        if (k == key || k != null && p.getLocator() == hash && this.keyEquivalence.equal(k, key)) {
                            oldValue = p.getValue();
                            if (pred == null) {
                                tab[i] = n;
                            } else {
                                pred.setLinkage(n);
                            }
                            seg.decrementCount();
                            break;
                        }
                        pred = p;
                        p = n;
                    }
                }
                finally {
                    seg.unlock();
                }
            }
        }
        return (V)oldValue;
    }

    @Override
    public boolean remove(Object key, Object value) {
        boolean removed;
        block11: {
            if (key == null) {
                throw new NullPointerException();
            }
            if (value == null) {
                return false;
            }
            removed = false;
            int hash = CustomConcurrentHashMap.spreadHash(this.keyEquivalence.hash(key));
            Segment seg = this.getSegmentForTraversal(hash);
            if (seg != null) {
                seg.lock();
                try {
                    Node[] tab = seg.getTableForTraversal();
                    if (tab == null) break block11;
                    int i = hash & tab.length - 1;
                    Node pred = null;
                    Node p = tab[i];
                    while (p != null) {
                        Node n = p.getLinkage();
                        Object k = p.get();
                        if (k == key || k != null && p.getLocator() == hash && this.keyEquivalence.equal(k, key)) {
                            Object v = p.getValue();
                            if (v == value || v != null && this.valueEquivalence.equal(v, value)) {
                                if (pred == null) {
                                    tab[i] = n;
                                } else {
                                    pred.setLinkage(n);
                                }
                                seg.decrementCount();
                                removed = true;
                            }
                            break;
                        }
                        pred = p;
                        p = n;
                    }
                }
                finally {
                    seg.unlock();
                }
            }
        }
        return removed;
    }

    final void removeIfReclaimed(Node r) {
        int hash = r.getLocator();
        Segment seg = this.getSegmentForTraversal(hash);
        if (seg != null) {
            seg.lock();
            try {
                Node[] tab = seg.getTableForTraversal();
                if (tab != null) {
                    int i = hash & tab.length - 1;
                    Node pred = null;
                    Node p = tab[i];
                    while (p != null) {
                        Node n = p.getLinkage();
                        if (p.get() != null && p.getValue() != null) {
                            pred = p;
                            p = n;
                            continue;
                        }
                        if (pred == null) {
                            tab[i] = n;
                        } else {
                            pred.setLinkage(n);
                        }
                        seg.decrementCount();
                        p = n;
                    }
                }
            }
            finally {
                seg.unlock();
            }
        }
    }

    @Override
    public final boolean isEmpty() {
        Segment[] segs = this.segments;
        int i = 0;
        while (i < segs.length) {
            Segment seg = segs[i];
            if (seg != null && seg.getTableForTraversal() != null && seg.count != 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public final int size() {
        long sum = 0L;
        Segment[] segs = this.segments;
        int i = 0;
        while (i < segs.length) {
            Segment seg = segs[i];
            if (seg != null && seg.getTableForTraversal() != null) {
                sum += (long)seg.count;
            }
            ++i;
        }
        return sum >= Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)sum;
    }

    @Override
    public final boolean containsValue(Object value) {
        if (value == null) {
            throw new NullPointerException();
        }
        Segment[] segs = this.segments;
        int i = 0;
        while (i < segs.length) {
            Node[] tab;
            Segment seg = segs[i];
            if (seg != null && (tab = seg.getTableForTraversal()) != null) {
                int j = 0;
                while (j < tab.length) {
                    Node p = tab[j];
                    while (p != null) {
                        Object v = p.getValue();
                        if (v == value || v != null && this.valueEquivalence.equal(v, value)) {
                            return true;
                        }
                        p = p.getLinkage();
                    }
                    ++j;
                }
            }
            ++i;
        }
        return false;
    }

    @Override
    public final void clear() {
        Segment[] segs = this.segments;
        int i = 0;
        while (i < segs.length) {
            Segment seg = segs[i];
            if (seg != null) {
                seg.lock();
                try {
                    seg.clearCount();
                }
                finally {
                    seg.unlock();
                }
            }
            ++i;
        }
    }

    @Override
    public V computeIfAbsent(K key, MappingFunction<? super K, ? extends V> mappingFunction) {
        if (key == null || mappingFunction == null) {
            throw new NullPointerException();
        }
        int hash = CustomConcurrentHashMap.spreadHash(this.keyEquivalence.hash(key));
        Segment seg = this.getSegmentForTraversal(hash);
        Node r = this.findNode(key, hash, seg);
        Object v = null;
        if (r == null) {
            if (seg == null) {
                seg = this.getSegmentForAdd(hash);
            }
            seg.lock();
            try {
                r = this.findNode(key, hash, seg);
                if ((r == null || (v = r.getValue()) == null) && (v = mappingFunction.map(key)) != null) {
                    if (r != null) {
                        r.setValue(v);
                    } else {
                        Node[] tab = seg.getTableForAdd(this);
                        int i = hash & tab.length - 1;
                        r = this.factory.newNode(hash, key, v, this, tab[i]);
                        CustomConcurrentHashMap.storeNode(tab, i, r);
                        seg.incrementCount();
                    }
                }
            }
            finally {
                seg.unlock();
            }
        }
        if (r != null && v == null) {
            this.removeIfReclaimed(r);
        }
        return (V)v;
    }

    public V compute(K key, RemappingFunction<? super K, V> remappingFunction) {
        if (key == null || remappingFunction == null) {
            throw new NullPointerException();
        }
        int hash = CustomConcurrentHashMap.spreadHash(this.keyEquivalence.hash(key));
        Object value = null;
        Segment seg = this.getSegmentForAdd(hash);
        seg.lock();
        try {
            Node[] tab = seg.getTableForAdd(this);
            int i = hash & tab.length - 1;
            Node pred = null;
            Node p = tab[i];
            while (p != null) {
                Object k = p.get();
                if (k == key || k != null && p.getLocator() == hash && this.keyEquivalence.equal(k, key)) {
                    value = p.getValue();
                    break;
                }
                pred = p;
                p = p.getLinkage();
            }
            value = remappingFunction.remap(key, value);
            if (p != null) {
                if (value != null) {
                    p.setValue(value);
                } else {
                    Node n = p.getLinkage();
                    if (pred == null) {
                        tab[i] = n;
                    } else {
                        pred.setLinkage(n);
                    }
                    seg.decrementCount();
                }
            } else if (value != null) {
                Node r = this.factory.newNode(hash, key, value, this, tab[i]);
                CustomConcurrentHashMap.storeNode(tab, i, r);
                seg.incrementCount();
            }
        }
        finally {
            seg.unlock();
        }
        return (V)value;
    }

    final KeyIterator keyIterator() {
        return new KeyIterator();
    }

    @Override
    public Set<K> keySet() {
        KeySetView ks = this.keySet;
        return ks != null ? ks : (this.keySet = new KeySetView());
    }

    @Override
    public Collection<V> values() {
        Values vs = this.values;
        return vs != null ? vs : (this.values = new Values());
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        EntrySet es = this.entrySet;
        return es != null ? es : (this.entrySet = new EntrySet());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map m = (Map)o;
        if (m.size() != this.size()) {
            return false;
        }
        try {
            Iterator<Map.Entry<K, V>> i = this.entrySet().iterator();
            while (true) {
                if (!i.hasNext()) {
                    return true;
                }
                Map.Entry<K, V> e = i.next();
                K key = e.getKey();
                V value = e.getValue();
                if (value == null) continue;
                Object mv = m.get(key);
                if (mv == null) {
                    return false;
                }
                if (!this.valueEquivalence.equal(mv, value)) break;
            }
            return false;
        }
        catch (ClassCastException unused) {
            return false;
        }
        catch (NullPointerException unused) {
            return false;
        }
    }

    @Override
    public int hashCode() {
        int h = 0;
        Iterator<Map.Entry<K, V>> i = this.entrySet().iterator();
        while (i.hasNext()) {
            h += i.next().hashCode();
        }
        return h;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        for (Map.Entry<K, V> e : this.entrySet()) {
            s.writeObject(e.getKey());
            s.writeObject(e.getValue());
        }
        s.writeObject(null);
        s.writeObject(null);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.segments = new Segment[64];
        while (true) {
            Object key = s.readObject();
            Object value = s.readObject();
            if (key == null) break;
            this.put(key, value);
        }
    }

    static ReferenceQueue<Object> getReclamationQueue() {
        ReferenceQueue<Object> q = refQueue;
        if (q != null) {
            return q;
        }
        return CustomConcurrentHashMap.startReclamation();
    }

    static synchronized ReferenceQueue<Object> startReclamation() {
        ReferenceQueue<Object> q = refQueue;
        if (q == null) {
            refQueue = q = new ReferenceQueue();
            new ReclamationThread(q).start();
        }
        return q;
    }

    private static Unsafe getUnsafe() throws Throwable {
        try {
            return Unsafe.getUnsafe();
        }
        catch (SecurityException se) {
            try {
                return AccessController.doPrivileged(new PrivilegedExceptionAction<Unsafe>(){

                    @Override
                    public Unsafe run() throws Exception {
                        return CustomConcurrentHashMap.getUnsafePrivileged();
                    }
                });
            }
            catch (PrivilegedActionException e) {
                throw e.getCause();
            }
        }
    }

    private static Unsafe getUnsafePrivileged() throws NoSuchFieldException, IllegalAccessException {
        Field f = Unsafe.class.getDeclaredField("theUnsafe");
        f.setAccessible(true);
        return (Unsafe)f.get(null);
    }

    static final void storeNode(Node[] table, int i, Node r) {
        long nodeOffset = ((long)i << tableShift) + tableBase;
        _unsafe.putOrderedObject(table, nodeOffset, r);
    }

    static final void storeSegment(Segment[] segs, int i, Segment s) {
        long segmentOffset = ((long)i << segmentsShift) + segmentsBase;
        _unsafe.putOrderedObject(segs, segmentOffset, s);
    }

    static class EmbeddedSoftReference
    extends SoftReference
    implements Reclaimable {
        final Reclaimable outer;

        EmbeddedSoftReference(Object x, Reclaimable outer) {
            super(x, CustomConcurrentHashMap.getReclamationQueue());
            this.outer = outer;
        }

        @Override
        public final void onReclamation() {
            this.clear();
            this.outer.onReclamation();
        }
    }

    static class EmbeddedWeakReference
    extends WeakReference
    implements Reclaimable {
        final Reclaimable outer;

        EmbeddedWeakReference(Object x, Reclaimable outer) {
            super(x, CustomConcurrentHashMap.getReclamationQueue());
            this.outer = outer;
        }

        @Override
        public final void onReclamation() {
            this.clear();
            this.outer.onReclamation();
        }
    }

    final class EntryIterator
    extends HashIterator
    implements Iterator<Map.Entry<K, V>> {
        EntryIterator() {
        }

        @Override
        public Map.Entry<K, V> next() {
            return super.nextEntry();
        }
    }

    final class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object v = CustomConcurrentHashMap.this.get(e.getKey());
            return v != null && CustomConcurrentHashMap.this.valueEquivalence.equal(v, e.getValue());
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return CustomConcurrentHashMap.this.remove(e.getKey(), e.getValue());
        }

        @Override
        public int size() {
            return CustomConcurrentHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return CustomConcurrentHashMap.this.isEmpty();
        }

        @Override
        public void clear() {
            CustomConcurrentHashMap.this.clear();
        }
    }

    public static interface Equivalence<K> {
        public boolean equal(K var1, Object var2);

        public int hash(Object var1);
    }

    static final class EquivalenceUsingEquals
    implements Equivalence<Object>,
    Serializable {
        private static final long serialVersionUID = 7259069247764182397L;

        EquivalenceUsingEquals() {
        }

        @Override
        public final boolean equal(Object a, Object b) {
            return a.equals(b);
        }

        @Override
        public final int hash(Object a) {
            return a.hashCode();
        }
    }

    static final class EquivalenceUsingIdentity
    implements Equivalence<Object>,
    Serializable {
        private static final long serialVersionUID = 7259069246764182397L;

        EquivalenceUsingIdentity() {
        }

        @Override
        public final boolean equal(Object a, Object b) {
            return a == b;
        }

        @Override
        public final int hash(Object a) {
            return System.identityHashCode(a);
        }
    }

    abstract class HashIterator {
        int nextSegmentIndex;
        int nextTableIndex;
        Node[] currentTable;
        Node nextNode;
        Object nextKey;
        Object nextValue;
        Object lastKey;

        HashIterator() {
            this.nextSegmentIndex = CustomConcurrentHashMap.this.segments.length - 1;
            this.nextTableIndex = -1;
            this.advance();
        }

        public final boolean hasNext() {
            return this.nextNode != null;
        }

        final void advance() {
            this.lastKey = this.nextKey;
            if (this.nextNode != null) {
                this.nextNode = this.nextNode.getLinkage();
            }
            while (true) {
                Node[] t;
                Segment seg;
                if (this.nextNode != null) {
                    this.nextKey = this.nextNode.get();
                    if (this.nextKey != null && (this.nextValue = this.nextNode.getValue()) != null) {
                        return;
                    }
                    Node n = this.nextNode.getLinkage();
                    CustomConcurrentHashMap.this.removeIfReclaimed(this.nextNode);
                    this.nextNode = n;
                    continue;
                }
                if (this.nextTableIndex >= 0) {
                    this.nextNode = this.currentTable[this.nextTableIndex--];
                    continue;
                }
                if (this.nextSegmentIndex < 0) break;
                if ((seg = CustomConcurrentHashMap.this.segments[this.nextSegmentIndex--]) == null || (t = seg.getTableForTraversal()) == null) continue;
                this.currentTable = t;
                this.nextTableIndex = t.length - 1;
            }
            this.nextKey = null;
            this.nextValue = null;
        }

        final K nextKey() {
            if (this.nextNode == null) {
                throw new NoSuchElementException();
            }
            Object k = this.nextKey;
            this.advance();
            return k;
        }

        final V nextValue() {
            if (this.nextNode == null) {
                throw new NoSuchElementException();
            }
            Object v = this.nextValue;
            this.advance();
            return v;
        }

        final Map.Entry<K, V> nextEntry() {
            if (this.nextNode == null) {
                throw new NoSuchElementException();
            }
            WriteThroughEntry e = new WriteThroughEntry(this.nextKey, this.nextValue);
            this.advance();
            return e;
        }

        public void remove() {
            if (this.lastKey == null) {
                throw new IllegalStateException();
            }
            CustomConcurrentHashMap.this.remove(this.lastKey);
            this.lastKey = null;
        }
    }

    static abstract class IntKeyIntValueNode
    extends IntKeyNode {
        volatile int value;

        IntKeyIntValueNode(int locator, Object key, Object value) {
            super(locator, key);
            this.value = (Integer)value;
        }

        @Override
        public final Object getValue() {
            return this.value;
        }

        @Override
        public final void setValue(Object value) {
            this.value = (Integer)value;
        }

        @Override
        public final void onReclamation() {
        }
    }

    static final class IntKeyIntValueNodeFactory
    implements NodeFactory,
    Serializable {
        private static final long serialVersionUID = 7249069346764182397L;

        IntKeyIntValueNodeFactory() {
        }

        @Override
        public final Node newNode(int locator, Object key, Object value, CustomConcurrentHashMap cchm, Node linkage) {
            if (linkage == null) {
                return new TerminalIntKeyIntValueNode(locator, key, value);
            }
            return new LinkedIntKeyIntValueNode(locator, key, value, linkage);
        }
    }

    static abstract class IntKeyNode
    implements Node {
        final int key;

        IntKeyNode(int locator, Object key) {
            this.key = (Integer)key;
        }

        @Override
        public final Object get() {
            return this.key;
        }

        @Override
        public final int getLocator() {
            return CustomConcurrentHashMap.spreadHash(this.key);
        }
    }

    static abstract class IntKeySelfValueNode
    extends IntKeyNode {
        IntKeySelfValueNode(int locator, Object key) {
            super(locator, key);
        }

        @Override
        public final Object getValue() {
            return this.key;
        }

        @Override
        public final void setValue(Object value) {
        }

        @Override
        public final void onReclamation() {
        }
    }

    static final class IntKeySelfValueNodeFactory
    implements NodeFactory,
    Serializable {
        private static final long serialVersionUID = 7249069346764182397L;

        IntKeySelfValueNodeFactory() {
        }

        @Override
        public final Node newNode(int locator, Object key, Object value, CustomConcurrentHashMap cchm, Node linkage) {
            if (linkage == null) {
                return new TerminalIntKeySelfValueNode(locator, key);
            }
            return new LinkedIntKeySelfValueNode(locator, key, linkage);
        }
    }

    static abstract class IntKeySoftValueNode
    extends IntKeyNode {
        volatile EmbeddedSoftReference valueRef;
        final CustomConcurrentHashMap cchm;

        IntKeySoftValueNode(int locator, Object key, Object value, CustomConcurrentHashMap cchm) {
            super(locator, key);
            this.cchm = cchm;
            if (value != null) {
                this.valueRef = new EmbeddedSoftReference(value, this);
            }
        }

        @Override
        public final void onReclamation() {
            this.cchm.removeIfReclaimed(this);
        }

        @Override
        public final Object getValue() {
            EmbeddedSoftReference vr = this.valueRef;
            return vr == null ? null : vr.get();
        }

        @Override
        public final void setValue(Object value) {
            this.valueRef = value == null ? null : new EmbeddedSoftReference(value, this);
        }
    }

    static final class IntKeySoftValueNodeFactory
    implements NodeFactory,
    Serializable {
        private static final long serialVersionUID = 7249069346764182397L;

        IntKeySoftValueNodeFactory() {
        }

        @Override
        public final Node newNode(int locator, Object key, Object value, CustomConcurrentHashMap cchm, Node linkage) {
            if (linkage == null) {
                return new TerminalIntKeySoftValueNode(locator, key, value, cchm);
            }
            return new LinkedIntKeySoftValueNode(locator, key, value, cchm, linkage);
        }
    }

    static abstract class IntKeyStrongValueNode
    extends IntKeyNode {
        volatile Object value;

        IntKeyStrongValueNode(int locator, Object key, Object value) {
            super(locator, key);
            this.value = value;
        }

        @Override
        public final Object getValue() {
            return this.value;
        }

        @Override
        public final void setValue(Object value) {
            this.value = value;
        }

        @Override
        public final void onReclamation() {
        }
    }

    static final class IntKeyStrongValueNodeFactory
    implements NodeFactory,
    Serializable {
        private static final long serialVersionUID = 7249069346764182397L;

        IntKeyStrongValueNodeFactory() {
        }

        @Override
        public final Node newNode(int locator, Object key, Object value, CustomConcurrentHashMap cchm, Node linkage) {
            if (linkage == null) {
                return new TerminalIntKeyStrongValueNode(locator, key, value);
            }
            return new LinkedIntKeyStrongValueNode(locator, key, value, linkage);
        }
    }

    static abstract class IntKeyWeakValueNode
    extends IntKeyNode {
        volatile EmbeddedWeakReference valueRef;
        final CustomConcurrentHashMap cchm;

        IntKeyWeakValueNode(int locator, Object key, Object value, CustomConcurrentHashMap cchm) {
            super(locator, key);
            this.cchm = cchm;
            if (value != null) {
                this.valueRef = new EmbeddedWeakReference(value, this);
            }
        }

        @Override
        public final void onReclamation() {
            this.cchm.removeIfReclaimed(this);
        }

        @Override
        public final Object getValue() {
            EmbeddedWeakReference vr = this.valueRef;
            return vr == null ? null : vr.get();
        }

        @Override
        public final void setValue(Object value) {
            this.valueRef = value == null ? null : new EmbeddedWeakReference(value, this);
        }
    }

    static final class IntKeyWeakValueNodeFactory
    implements NodeFactory,
    Serializable {
        private static final long serialVersionUID = 7249069346764182397L;

        IntKeyWeakValueNodeFactory() {
        }

        @Override
        public final Node newNode(int locator, Object key, Object value, CustomConcurrentHashMap cchm, Node linkage) {
            if (linkage == null) {
                return new TerminalIntKeyWeakValueNode(locator, key, value, cchm);
            }
            return new LinkedIntKeyWeakValueNode(locator, key, value, cchm, linkage);
        }
    }

    final class KeyIterator
    extends HashIterator
    implements Iterator<K> {
        KeyIterator() {
        }

        @Override
        public K next() {
            return super.nextKey();
        }
    }

    public static class KeySet<K>
    extends AbstractSet<K>
    implements Set<K>,
    Serializable {
        final CustomConcurrentHashMap<K, K> cchm;

        public KeySet(Strength strength, Equivalence<? super K> equivalence, int expectedSize) {
            this.cchm = new CustomConcurrentHashMap<K, K>(strength.getName(), equivalence, CustomConcurrentHashMap.SELF_STRING, equivalence, expectedSize);
        }

        public K intern(K e) {
            K oldElement = this.cchm.doPut(e, e, true);
            return oldElement != null ? oldElement : e;
        }

        @Override
        public boolean contains(Object o) {
            return this.cchm.containsKey(o);
        }

        @Override
        public Iterator<K> iterator() {
            return this.cchm.keyIterator();
        }

        @Override
        public boolean add(K e) {
            return this.cchm.doPut(e, e, true) != null;
        }

        @Override
        public boolean remove(Object o) {
            return this.cchm.remove(o) != null;
        }

        @Override
        public boolean isEmpty() {
            return this.cchm.isEmpty();
        }

        @Override
        public int size() {
            return this.cchm.size();
        }

        @Override
        public void clear() {
            this.cchm.clear();
        }

        @Override
        public int hashCode() {
            int h = 0;
            Iterator<K> i = this.iterator();
            while (i.hasNext()) {
                h += this.cchm.keyEquivalence.hash(i.next());
            }
            return h;
        }
    }

    final class KeySetView
    extends AbstractSet<K> {
        KeySetView() {
        }

        @Override
        public Iterator<K> iterator() {
            return new KeyIterator();
        }

        @Override
        public int size() {
            return CustomConcurrentHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return CustomConcurrentHashMap.this.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return CustomConcurrentHashMap.this.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            return CustomConcurrentHashMap.this.remove(o) != null;
        }

        @Override
        public void clear() {
            CustomConcurrentHashMap.this.clear();
        }
    }

    static final class LinkedIntKeyIntValueNode
    extends IntKeyIntValueNode {
        volatile Node linkage;

        LinkedIntKeyIntValueNode(int locator, Object key, Object value, Node linkage) {
            super(locator, key, value);
            this.linkage = linkage;
        }

        @Override
        public final Node getLinkage() {
            return this.linkage;
        }

        @Override
        public final void setLinkage(Node r) {
            this.linkage = r;
        }
    }

    static final class LinkedIntKeySelfValueNode
    extends IntKeySelfValueNode {
        volatile Node linkage;

        LinkedIntKeySelfValueNode(int locator, Object key, Node linkage) {
            super(locator, key);
            this.linkage = linkage;
        }

        @Override
        public final Node getLinkage() {
            return this.linkage;
        }

        @Override
        public final void setLinkage(Node r) {
            this.linkage = r;
        }
    }

    static final class LinkedIntKeySoftValueNode
    extends IntKeySoftValueNode {
        volatile Node linkage;

        LinkedIntKeySoftValueNode(int locator, Object key, Object value, CustomConcurrentHashMap cchm, Node linkage) {
            super(locator, key, value, cchm);
            this.linkage = linkage;
        }

        @Override
        public final Node getLinkage() {
            return this.linkage;
        }

        @Override
        public final void setLinkage(Node r) {
            this.linkage = r;
        }
    }

    static final class LinkedIntKeyStrongValueNode
    extends IntKeyStrongValueNode {
        volatile Node linkage;

        LinkedIntKeyStrongValueNode(int locator, Object key, Object value, Node linkage) {
            super(locator, key, value);
            this.linkage = linkage;
        }

        @Override
        public final Node getLinkage() {
            return this.linkage;
        }

        @Override
        public final void setLinkage(Node r) {
            this.linkage = r;
        }
    }

    static final class LinkedIntKeyWeakValueNode
    extends IntKeyWeakValueNode {
        volatile Node linkage;

        LinkedIntKeyWeakValueNode(int locator, Object key, Object value, CustomConcurrentHashMap cchm, Node linkage) {
            super(locator, key, value, cchm);
            this.linkage = linkage;
        }

        @Override
        public final Node getLinkage() {
            return this.linkage;
        }

        @Override
        public final void setLinkage(Node r) {
            this.linkage = r;
        }
    }

    static final class LinkedSoftKeyIntValueNode
    extends SoftKeyIntValueNode {
        volatile Node linkage;

        LinkedSoftKeyIntValueNode(int locator, Object key, Object value, CustomConcurrentHashMap cchm, Node linkage) {
            super(locator, key, value, cchm);
            this.linkage = linkage;
        }

        @Override
        public final Node getLinkage() {
            return this.linkage;
        }

        @Override
        public final void setLinkage(Node r) {
            this.linkage = r;
        }
    }

    static final class LinkedSoftKeySelfValueNode
    extends SoftKeySelfValueNode {
        volatile Node linkage;

        LinkedSoftKeySelfValueNode(int locator, Object key, CustomConcurrentHashMap cchm, Node linkage) {
            super(locator, key, cchm);
            this.linkage = linkage;
        }

        @Override
        public final Node getLinkage() {
            return this.linkage;
        }

        @Override
        public final void setLinkage(Node r) {
            this.linkage = r;
        }
    }

    static final class LinkedSoftKeySoftValueNode
    extends SoftKeySoftValueNode {
        volatile Node linkage;

        LinkedSoftKeySoftValueNode(int locator, Object key, Object value, CustomConcurrentHashMap cchm, Node linkage) {
            super(locator, key, value, cchm);
            this.linkage = linkage;
        }

        @Override
        public final Node getLinkage() {
            return this.linkage;
        }

        @Override
        public final void setLinkage(Node r) {
            this.linkage = r;
        }
    }

    static final class LinkedSoftKeyStrongValueNode
    extends SoftKeyStrongValueNode {
        volatile Node linkage;

        LinkedSoftKeyStrongValueNode(int locator, Object key, Object value, CustomConcurrentHashMap cchm, Node linkage) {
            super(locator, key, value, cchm);
            this.linkage = linkage;
        }

        @Override
        public final Node getLinkage() {
            return this.linkage;
        }

        @Override
        public final void setLinkage(Node r) {
            this.linkage = r;
        }
    }

    static final class LinkedSoftKeyWeakValueNode
    extends SoftKeyWeakValueNode {
        volatile Node linkage;

        LinkedSoftKeyWeakValueNode(int locator, Object key, Object value, CustomConcurrentHashMap cchm, Node linkage) {
            super(locator, key, value, cchm);
            this.linkage = linkage;
        }

        @Override
        public final Node getLinkage() {
            return this.linkage;
        }

        @Override
        public final void setLinkage(Node r) {
            this.linkage = r;
        }
    }

    static final class LinkedStrongKeyIntValueNode
    extends StrongKeyIntValueNode {
        volatile Node linkage;

        LinkedStrongKeyIntValueNode(int locator, Object key, Object value, Node linkage) {
            super(locator, key, value);
            this.linkage = linkage;
        }

        @Override
        public final Node getLinkage() {
            return this.linkage;
        }

        @Override
        public final void setLinkage(Node r) {
            this.linkage = r;
        }
    }

    static final class LinkedStrongKeySelfValueNode
    extends StrongKeySelfValueNode {
        volatile Node linkage;

        LinkedStrongKeySelfValueNode(int locator, Object key, Node linkage) {
            super(locator, key);
            this.linkage = linkage;
        }

        @Override
        public final Node getLinkage() {
            return this.linkage;
        }

        @Override
        public final void setLinkage(Node r) {
            this.linkage = r;
        }
    }

    static final class LinkedStrongKeySoftValueNode
    extends StrongKeySoftValueNode {
        volatile Node linkage;

        LinkedStrongKeySoftValueNode(int locator, Object key, Object value, CustomConcurrentHashMap cchm, Node linkage) {
            super(locator, key, value, cchm);
            this.linkage = linkage;
        }

        @Override
        public final Node getLinkage() {
            return this.linkage;
        }

        @Override
        public final void setLinkage(Node r) {
            this.linkage = r;
        }
    }

    static final class LinkedStrongKeyStrongValueNode
    extends StrongKeyStrongValueNode {
        volatile Node linkage;

        LinkedStrongKeyStrongValueNode(int locator, Object key, Object value, Node linkage) {
            super(locator, key, value);
            this.linkage = linkage;
        }

        @Override
        public final Node getLinkage() {
            return this.linkage;
        }

        @Override
        public final void setLinkage(Node r) {
            this.linkage = r;
        }
    }

    static final class LinkedStrongKeyWeakValueNode
    extends StrongKeyWeakValueNode {
        volatile Node linkage;

        LinkedStrongKeyWeakValueNode(int locator, Object key, Object value, CustomConcurrentHashMap cchm, Node linkage) {
            super(locator, key, value, cchm);
            this.linkage = linkage;
        }

        @Override
        public final Node getLinkage() {
            return this.linkage;
        }

        @Override
        public final void setLinkage(Node r) {
            this.linkage = r;
        }
    }

    static final class LinkedWeakKeyIntValueNode
    extends WeakKeyIntValueNode {
        volatile Node linkage;

        LinkedWeakKeyIntValueNode(int locator, Object key, Object value, CustomConcurrentHashMap cchm, Node linkage) {
            super(locator, key, value, cchm);
            this.linkage = linkage;
        }

        @Override
        public final Node getLinkage() {
            return this.linkage;
        }

        @Override
        public final void setLinkage(Node r) {
            this.linkage = r;
        }
    }

    static final class LinkedWeakKeySelfValueNode
    extends WeakKeySelfValueNode {
        volatile Node linkage;

        LinkedWeakKeySelfValueNode(int locator, Object key, CustomConcurrentHashMap cchm, Node linkage) {
            super(locator, key, cchm);
            this.linkage = linkage;
        }

        @Override
        public final Node getLinkage() {
            return this.linkage;
        }

        @Override
        public final void setLinkage(Node r) {
            this.linkage = r;
        }
    }

    static final class LinkedWeakKeySoftValueNode
    extends WeakKeySoftValueNode {
        volatile Node linkage;

        LinkedWeakKeySoftValueNode(int locator, Object key, Object value, CustomConcurrentHashMap cchm, Node linkage) {
            super(locator, key, value, cchm);
            this.linkage = linkage;
        }

        @Override
        public final Node getLinkage() {
            return this.linkage;
        }

        @Override
        public final void setLinkage(Node r) {
            this.linkage = r;
        }
    }

    static final class LinkedWeakKeyStrongValueNode
    extends WeakKeyStrongValueNode {
        volatile Node linkage;

        LinkedWeakKeyStrongValueNode(int locator, Object key, Object value, CustomConcurrentHashMap cchm, Node linkage) {
            super(locator, key, value, cchm);
            this.linkage = linkage;
        }

        @Override
        public final Node getLinkage() {
            return this.linkage;
        }

        @Override
        public final void setLinkage(Node r) {
            this.linkage = r;
        }
    }

    static final class LinkedWeakKeyWeakValueNode
    extends WeakKeyWeakValueNode {
        volatile Node linkage;

        LinkedWeakKeyWeakValueNode(int locator, Object key, Object value, CustomConcurrentHashMap cchm, Node linkage) {
            super(locator, key, value, cchm);
            this.linkage = linkage;
        }

        @Override
        public final Node getLinkage() {
            return this.linkage;
        }

        @Override
        public final void setLinkage(Node r) {
            this.linkage = r;
        }
    }

    public static interface MappingFunction<K, V> {
        public V map(K var1);
    }

    static interface Node
    extends Reclaimable {
        public Object get();

        public int getLocator();

        public Object getValue();

        public void setValue(Object var1);

        public Node getLinkage();

        public void setLinkage(Node var1);
    }

    static interface NodeFactory
    extends Serializable {
        public Node newNode(int var1, Object var2, Object var3, CustomConcurrentHashMap var4, Node var5);
    }

    static interface Reclaimable {
        public void onReclamation();
    }

    static final class ReclamationThread
    extends Thread {
        final ReferenceQueue<Object> queue;

        ReclamationThread(ReferenceQueue<Object> q) {
            this.queue = q;
            this.setDaemon(true);
        }

        @Override
        public void run() {
            ReferenceQueue<Object> q = this.queue;
            while (true) {
                try {
                    while (true) {
                        Reference<Object> r;
                        if (!((r = q.remove()) instanceof Reclaimable)) {
                            continue;
                        }
                        ((Reclaimable)((Object)r)).onReclamation();
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }

    public static interface RemappingFunction<K, V> {
        public V remap(K var1, V var2);
    }

    static final class Segment
    extends ReentrantLock {
        volatile Node[] table;
        int count;

        Segment() {
        }

        final void decrementCount() {
            if (--this.count == 0) {
                this.table = null;
            }
        }

        final void clearCount() {
            this.count = 0;
            this.table = null;
        }

        final void incrementCount() {
            ++this.count;
        }

        final Node[] getTableForTraversal() {
            return this.table;
        }

        final Node[] getTableForAdd(CustomConcurrentHashMap cchm) {
            int len;
            Node[] tab = this.table;
            if (tab == null || (len = tab.length) - (len >>> 2) < this.count) {
                return this.resizeTable(cchm);
            }
            return tab;
        }

        final Node[] resizeTable(CustomConcurrentHashMap cchm) {
            Node[] oldTable = this.table;
            if (oldTable == null) {
                this.table = new Node[cchm.initialSegmentCapacity];
                return this.table;
            }
            int oldCapacity = oldTable.length;
            if (oldCapacity >= 0x4000000) {
                return oldTable;
            }
            Node[] newTable = new Node[oldCapacity << 1];
            int sizeMask = newTable.length - 1;
            NodeFactory fac = cchm.factory;
            int i = 0;
            while (i < oldCapacity) {
                Node e = oldTable[i];
                if (e != null) {
                    Node next = e.getLinkage();
                    int idx = e.getLocator() & sizeMask;
                    if (next == null) {
                        newTable[idx] = e;
                    } else {
                        Node lastRun = e;
                        int lastIdx = idx;
                        Node last = next;
                        while (last != null) {
                            int k = last.getLocator() & sizeMask;
                            if (k != lastIdx) {
                                lastIdx = k;
                                lastRun = last;
                            }
                            last = last.getLinkage();
                        }
                        newTable[lastIdx] = lastRun;
                        Node p = e;
                        while (p != lastRun) {
                            Object pv;
                            int ph = p.getLocator();
                            int k = ph & sizeMask;
                            Object pk = p.get();
                            if (pk == null || (pv = p.getValue()) == null) {
                                --this.count;
                            } else {
                                newTable[k] = fac.newNode(ph, pk, pv, cchm, newTable[k]);
                            }
                            p = p.getLinkage();
                        }
                    }
                }
                ++i;
            }
            this.table = newTable;
            return newTable;
        }
    }

    static abstract class SoftKeyIntValueNode
    extends SoftKeyNode {
        volatile int value;

        SoftKeyIntValueNode(int locator, Object key, Object value, CustomConcurrentHashMap cchm) {
            super(locator, key, cchm);
            this.value = (Integer)value;
        }

        @Override
        public final Object getValue() {
            return this.value;
        }

        @Override
        public final void setValue(Object value) {
            this.value = (Integer)value;
        }
    }

    static final class SoftKeyIntValueNodeFactory
    implements NodeFactory,
    Serializable {
        private static final long serialVersionUID = 7249069346764182397L;

        SoftKeyIntValueNodeFactory() {
        }

        @Override
        public final Node newNode(int locator, Object key, Object value, CustomConcurrentHashMap cchm, Node linkage) {
            if (linkage == null) {
                return new TerminalSoftKeyIntValueNode(locator, key, value, cchm);
            }
            return new LinkedSoftKeyIntValueNode(locator, key, value, cchm, linkage);
        }
    }

    static abstract class SoftKeyNode
    extends SoftReference
    implements Node {
        final int locator;
        final CustomConcurrentHashMap cchm;

        SoftKeyNode(int locator, Object key, CustomConcurrentHashMap cchm) {
            super(key);
            this.locator = locator;
            this.cchm = cchm;
        }

        @Override
        public final int getLocator() {
            return this.locator;
        }

        @Override
        public final void onReclamation() {
            this.clear();
            this.cchm.removeIfReclaimed(this);
        }
    }

    static abstract class SoftKeySelfValueNode
    extends SoftKeyNode {
        SoftKeySelfValueNode(int locator, Object key, CustomConcurrentHashMap cchm) {
            super(locator, key, cchm);
        }

        @Override
        public final Object getValue() {
            return this.get();
        }

        @Override
        public final void setValue(Object value) {
        }
    }

    static final class SoftKeySelfValueNodeFactory
    implements NodeFactory,
    Serializable {
        private static final long serialVersionUID = 7249069346764182397L;

        SoftKeySelfValueNodeFactory() {
        }

        @Override
        public final Node newNode(int locator, Object key, Object value, CustomConcurrentHashMap cchm, Node linkage) {
            if (linkage == null) {
                return new TerminalSoftKeySelfValueNode(locator, key, cchm);
            }
            return new LinkedSoftKeySelfValueNode(locator, key, cchm, linkage);
        }
    }

    static abstract class SoftKeySoftValueNode
    extends SoftKeyNode {
        volatile EmbeddedSoftReference valueRef;

        SoftKeySoftValueNode(int locator, Object key, Object value, CustomConcurrentHashMap cchm) {
            super(locator, key, cchm);
            if (value != null) {
                this.valueRef = new EmbeddedSoftReference(value, this);
            }
        }

        @Override
        public final Object getValue() {
            EmbeddedSoftReference vr = this.valueRef;
            return vr == null ? null : vr.get();
        }

        @Override
        public final void setValue(Object value) {
            this.valueRef = value == null ? null : new EmbeddedSoftReference(value, this);
        }
    }

    static final class SoftKeySoftValueNodeFactory
    implements NodeFactory,
    Serializable {
        private static final long serialVersionUID = 7249069346764182397L;

        SoftKeySoftValueNodeFactory() {
        }

        @Override
        public final Node newNode(int locator, Object key, Object value, CustomConcurrentHashMap cchm, Node linkage) {
            if (linkage == null) {
                return new TerminalSoftKeySoftValueNode(locator, key, value, cchm);
            }
            return new LinkedSoftKeySoftValueNode(locator, key, value, cchm, linkage);
        }
    }

    static abstract class SoftKeyStrongValueNode
    extends SoftKeyNode {
        volatile Object value;

        SoftKeyStrongValueNode(int locator, Object key, Object value, CustomConcurrentHashMap cchm) {
            super(locator, key, cchm);
            this.value = value;
        }

        @Override
        public final Object getValue() {
            return this.value;
        }

        @Override
        public final void setValue(Object value) {
            this.value = value;
        }
    }

    static final class SoftKeyStrongValueNodeFactory
    implements NodeFactory,
    Serializable {
        private static final long serialVersionUID = 7249069346764182397L;

        SoftKeyStrongValueNodeFactory() {
        }

        @Override
        public final Node newNode(int locator, Object key, Object value, CustomConcurrentHashMap cchm, Node linkage) {
            if (linkage == null) {
                return new TerminalSoftKeyStrongValueNode(locator, key, value, cchm);
            }
            return new LinkedSoftKeyStrongValueNode(locator, key, value, cchm, linkage);
        }
    }

    static abstract class SoftKeyWeakValueNode
    extends SoftKeyNode {
        volatile EmbeddedWeakReference valueRef;

        SoftKeyWeakValueNode(int locator, Object key, Object value, CustomConcurrentHashMap cchm) {
            super(locator, key, cchm);
            if (value != null) {
                this.valueRef = new EmbeddedWeakReference(value, this);
            }
        }

        @Override
        public final Object getValue() {
            EmbeddedWeakReference vr = this.valueRef;
            return vr == null ? null : vr.get();
        }

        @Override
        public final void setValue(Object value) {
            this.valueRef = value == null ? null : new EmbeddedWeakReference(value, this);
        }
    }

    static final class SoftKeyWeakValueNodeFactory
    implements NodeFactory,
    Serializable {
        private static final long serialVersionUID = 7249069346764182397L;

        SoftKeyWeakValueNodeFactory() {
        }

        @Override
        public final Node newNode(int locator, Object key, Object value, CustomConcurrentHashMap cchm, Node linkage) {
            if (linkage == null) {
                return new TerminalSoftKeyWeakValueNode(locator, key, value, cchm);
            }
            return new LinkedSoftKeyWeakValueNode(locator, key, value, cchm, linkage);
        }
    }

    public static enum Strength {
        strong("Strong"),
        weak("Weak"),
        soft("Soft");

        private final String name;

        private Strength(String name) {
            this.name = name;
        }

        String getName() {
            return this.name;
        }
    }

    static abstract class StrongKeyIntValueNode
    extends StrongKeyNode {
        volatile int value;

        StrongKeyIntValueNode(int locator, Object key, Object value) {
            super(locator, key);
            this.value = (Integer)value;
        }

        @Override
        public final Object getValue() {
            return this.value;
        }

        @Override
        public final void setValue(Object value) {
            this.value = (Integer)value;
        }

        @Override
        public final void onReclamation() {
        }
    }

    static final class StrongKeyIntValueNodeFactory
    implements NodeFactory,
    Serializable {
        private static final long serialVersionUID = 7249069346764182397L;

        StrongKeyIntValueNodeFactory() {
        }

        @Override
        public final Node newNode(int locator, Object key, Object value, CustomConcurrentHashMap cchm, Node linkage) {
            if (linkage == null) {
                return new TerminalStrongKeyIntValueNode(locator, key, value);
            }
            return new LinkedStrongKeyIntValueNode(locator, key, value, linkage);
        }
    }

    static abstract class StrongKeyNode
    implements Node {
        final Object key;
        final int locator;

        StrongKeyNode(int locator, Object key) {
            this.locator = locator;
            this.key = key;
        }

        @Override
        public final Object get() {
            return this.key;
        }

        @Override
        public final int getLocator() {
            return this.locator;
        }
    }

    static abstract class StrongKeySelfValueNode
    extends StrongKeyNode {
        StrongKeySelfValueNode(int locator, Object key) {
            super(locator, key);
        }

        @Override
        public final Object getValue() {
            return this.key;
        }

        @Override
        public final void setValue(Object value) {
        }

        @Override
        public final void onReclamation() {
        }
    }

    static final class StrongKeySelfValueNodeFactory
    implements NodeFactory,
    Serializable {
        private static final long serialVersionUID = 7249069346764182397L;

        StrongKeySelfValueNodeFactory() {
        }

        @Override
        public final Node newNode(int locator, Object key, Object value, CustomConcurrentHashMap cchm, Node linkage) {
            if (linkage == null) {
                return new TerminalStrongKeySelfValueNode(locator, key);
            }
            return new LinkedStrongKeySelfValueNode(locator, key, linkage);
        }
    }

    static abstract class StrongKeySoftValueNode
    extends StrongKeyNode {
        volatile EmbeddedSoftReference valueRef;
        final CustomConcurrentHashMap cchm;

        StrongKeySoftValueNode(int locator, Object key, Object value, CustomConcurrentHashMap cchm) {
            super(locator, key);
            this.cchm = cchm;
            if (value != null) {
                this.valueRef = new EmbeddedSoftReference(value, this);
            }
        }

        @Override
        public final void onReclamation() {
            this.cchm.removeIfReclaimed(this);
        }

        @Override
        public final Object getValue() {
            EmbeddedSoftReference vr = this.valueRef;
            return vr == null ? null : vr.get();
        }

        @Override
        public final void setValue(Object value) {
            this.valueRef = value == null ? null : new EmbeddedSoftReference(value, this);
        }
    }

    static final class StrongKeySoftValueNodeFactory
    implements NodeFactory,
    Serializable {
        private static final long serialVersionUID = 7249069346764182397L;

        StrongKeySoftValueNodeFactory() {
        }

        @Override
        public final Node newNode(int locator, Object key, Object value, CustomConcurrentHashMap cchm, Node linkage) {
            if (linkage == null) {
                return new TerminalStrongKeySoftValueNode(locator, key, value, cchm);
            }
            return new LinkedStrongKeySoftValueNode(locator, key, value, cchm, linkage);
        }
    }

    static abstract class StrongKeyStrongValueNode
    extends StrongKeyNode {
        volatile Object value;

        StrongKeyStrongValueNode(int locator, Object key, Object value) {
            super(locator, key);
            this.value = value;
        }

        @Override
        public final Object getValue() {
            return this.value;
        }

        @Override
        public final void setValue(Object value) {
            this.value = value;
        }

        @Override
        public final void onReclamation() {
        }
    }

    static final class StrongKeyStrongValueNodeFactory
    implements NodeFactory,
    Serializable {
        private static final long serialVersionUID = 7249069346764182397L;

        StrongKeyStrongValueNodeFactory() {
        }

        @Override
        public final Node newNode(int locator, Object key, Object value, CustomConcurrentHashMap cchm, Node linkage) {
            if (linkage == null) {
                return new TerminalStrongKeyStrongValueNode(locator, key, value);
            }
            return new LinkedStrongKeyStrongValueNode(locator, key, value, linkage);
        }
    }

    static abstract class StrongKeyWeakValueNode
    extends StrongKeyNode {
        volatile EmbeddedWeakReference valueRef;
        final CustomConcurrentHashMap cchm;

        StrongKeyWeakValueNode(int locator, Object key, Object value, CustomConcurrentHashMap cchm) {
            super(locator, key);
            this.cchm = cchm;
            if (value != null) {
                this.valueRef = new EmbeddedWeakReference(value, this);
            }
        }

        @Override
        public final void onReclamation() {
            this.cchm.removeIfReclaimed(this);
        }

        @Override
        public final Object getValue() {
            EmbeddedWeakReference vr = this.valueRef;
            return vr == null ? null : vr.get();
        }

        @Override
        public final void setValue(Object value) {
            this.valueRef = value == null ? null : new EmbeddedWeakReference(value, this);
        }
    }

    static final class StrongKeyWeakValueNodeFactory
    implements NodeFactory,
    Serializable {
        private static final long serialVersionUID = 7249069346764182397L;

        StrongKeyWeakValueNodeFactory() {
        }

        @Override
        public final Node newNode(int locator, Object key, Object value, CustomConcurrentHashMap cchm, Node linkage) {
            if (linkage == null) {
                return new TerminalStrongKeyWeakValueNode(locator, key, value, cchm);
            }
            return new LinkedStrongKeyWeakValueNode(locator, key, value, cchm, linkage);
        }
    }

    static final class TerminalIntKeyIntValueNode
    extends IntKeyIntValueNode {
        TerminalIntKeyIntValueNode(int locator, Object key, Object value) {
            super(locator, key, value);
        }

        @Override
        public final Node getLinkage() {
            return null;
        }

        @Override
        public final void setLinkage(Node r) {
        }
    }

    static final class TerminalIntKeySelfValueNode
    extends IntKeySelfValueNode {
        TerminalIntKeySelfValueNode(int locator, Object key) {
            super(locator, key);
        }

        @Override
        public final Node getLinkage() {
            return null;
        }

        @Override
        public final void setLinkage(Node r) {
        }
    }

    static final class TerminalIntKeySoftValueNode
    extends IntKeySoftValueNode {
        TerminalIntKeySoftValueNode(int locator, Object key, Object value, CustomConcurrentHashMap cchm) {
            super(locator, key, value, cchm);
        }

        @Override
        public final Node getLinkage() {
            return null;
        }

        @Override
        public final void setLinkage(Node r) {
        }
    }

    static final class TerminalIntKeyStrongValueNode
    extends IntKeyStrongValueNode {
        TerminalIntKeyStrongValueNode(int locator, Object key, Object value) {
            super(locator, key, value);
        }

        @Override
        public final Node getLinkage() {
            return null;
        }

        @Override
        public final void setLinkage(Node r) {
        }
    }

    static final class TerminalIntKeyWeakValueNode
    extends IntKeyWeakValueNode {
        TerminalIntKeyWeakValueNode(int locator, Object key, Object value, CustomConcurrentHashMap cchm) {
            super(locator, key, value, cchm);
        }

        @Override
        public final Node getLinkage() {
            return null;
        }

        @Override
        public final void setLinkage(Node r) {
        }
    }

    static final class TerminalSoftKeyIntValueNode
    extends SoftKeyIntValueNode {
        TerminalSoftKeyIntValueNode(int locator, Object key, Object value, CustomConcurrentHashMap cchm) {
            super(locator, key, value, cchm);
        }

        @Override
        public final Node getLinkage() {
            return null;
        }

        @Override
        public final void setLinkage(Node r) {
        }
    }

    static final class TerminalSoftKeySelfValueNode
    extends SoftKeySelfValueNode {
        TerminalSoftKeySelfValueNode(int locator, Object key, CustomConcurrentHashMap cchm) {
            super(locator, key, cchm);
        }

        @Override
        public final Node getLinkage() {
            return null;
        }

        @Override
        public final void setLinkage(Node r) {
        }
    }

    static final class TerminalSoftKeySoftValueNode
    extends SoftKeySoftValueNode {
        TerminalSoftKeySoftValueNode(int locator, Object key, Object value, CustomConcurrentHashMap cchm) {
            super(locator, key, value, cchm);
        }

        @Override
        public final Node getLinkage() {
            return null;
        }

        @Override
        public final void setLinkage(Node r) {
        }
    }

    static final class TerminalSoftKeyStrongValueNode
    extends SoftKeyStrongValueNode {
        TerminalSoftKeyStrongValueNode(int locator, Object key, Object value, CustomConcurrentHashMap cchm) {
            super(locator, key, value, cchm);
        }

        @Override
        public final Node getLinkage() {
            return null;
        }

        @Override
        public final void setLinkage(Node r) {
        }
    }

    static final class TerminalSoftKeyWeakValueNode
    extends SoftKeyWeakValueNode {
        TerminalSoftKeyWeakValueNode(int locator, Object key, Object value, CustomConcurrentHashMap cchm) {
            super(locator, key, value, cchm);
        }

        @Override
        public final Node getLinkage() {
            return null;
        }

        @Override
        public final void setLinkage(Node r) {
        }
    }

    static final class TerminalStrongKeyIntValueNode
    extends StrongKeyIntValueNode {
        TerminalStrongKeyIntValueNode(int locator, Object key, Object value) {
            super(locator, key, value);
        }

        @Override
        public final Node getLinkage() {
            return null;
        }

        @Override
        public final void setLinkage(Node r) {
        }
    }

    static final class TerminalStrongKeySelfValueNode
    extends StrongKeySelfValueNode {
        TerminalStrongKeySelfValueNode(int locator, Object key) {
            super(locator, key);
        }

        @Override
        public final Node getLinkage() {
            return null;
        }

        @Override
        public final void setLinkage(Node r) {
        }
    }

    static final class TerminalStrongKeySoftValueNode
    extends StrongKeySoftValueNode {
        TerminalStrongKeySoftValueNode(int locator, Object key, Object value, CustomConcurrentHashMap cchm) {
            super(locator, key, value, cchm);
        }

        @Override
        public final Node getLinkage() {
            return null;
        }

        @Override
        public final void setLinkage(Node r) {
        }
    }

    static final class TerminalStrongKeyStrongValueNode
    extends StrongKeyStrongValueNode {
        TerminalStrongKeyStrongValueNode(int locator, Object key, Object value) {
            super(locator, key, value);
        }

        @Override
        public final Node getLinkage() {
            return null;
        }

        @Override
        public final void setLinkage(Node r) {
        }
    }

    static final class TerminalStrongKeyWeakValueNode
    extends StrongKeyWeakValueNode {
        TerminalStrongKeyWeakValueNode(int locator, Object key, Object value, CustomConcurrentHashMap cchm) {
            super(locator, key, value, cchm);
        }

        @Override
        public final Node getLinkage() {
            return null;
        }

        @Override
        public final void setLinkage(Node r) {
        }
    }

    static final class TerminalWeakKeyIntValueNode
    extends WeakKeyIntValueNode {
        TerminalWeakKeyIntValueNode(int locator, Object key, Object value, CustomConcurrentHashMap cchm) {
            super(locator, key, value, cchm);
        }

        @Override
        public final Node getLinkage() {
            return null;
        }

        @Override
        public final void setLinkage(Node r) {
        }
    }

    static final class TerminalWeakKeySelfValueNode
    extends WeakKeySelfValueNode {
        TerminalWeakKeySelfValueNode(int locator, Object key, CustomConcurrentHashMap cchm) {
            super(locator, key, cchm);
        }

        @Override
        public final Node getLinkage() {
            return null;
        }

        @Override
        public final void setLinkage(Node r) {
        }
    }

    static final class TerminalWeakKeySoftValueNode
    extends WeakKeySoftValueNode {
        TerminalWeakKeySoftValueNode(int locator, Object key, Object value, CustomConcurrentHashMap cchm) {
            super(locator, key, value, cchm);
        }

        @Override
        public final Node getLinkage() {
            return null;
        }

        @Override
        public final void setLinkage(Node r) {
        }
    }

    static final class TerminalWeakKeyStrongValueNode
    extends WeakKeyStrongValueNode {
        TerminalWeakKeyStrongValueNode(int locator, Object key, Object value, CustomConcurrentHashMap cchm) {
            super(locator, key, value, cchm);
        }

        @Override
        public final Node getLinkage() {
            return null;
        }

        @Override
        public final void setLinkage(Node r) {
        }
    }

    static final class TerminalWeakKeyWeakValueNode
    extends WeakKeyWeakValueNode {
        TerminalWeakKeyWeakValueNode(int locator, Object key, Object value, CustomConcurrentHashMap cchm) {
            super(locator, key, value, cchm);
        }

        @Override
        public final Node getLinkage() {
            return null;
        }

        @Override
        public final void setLinkage(Node r) {
        }
    }

    final class ValueIterator
    extends HashIterator
    implements Iterator<V> {
        ValueIterator() {
        }

        @Override
        public V next() {
            return super.nextValue();
        }
    }

    final class Values
    extends AbstractCollection<V> {
        Values() {
        }

        @Override
        public Iterator<V> iterator() {
            return new ValueIterator();
        }

        @Override
        public int size() {
            return CustomConcurrentHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return CustomConcurrentHashMap.this.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return CustomConcurrentHashMap.this.containsValue(o);
        }

        @Override
        public void clear() {
            CustomConcurrentHashMap.this.clear();
        }
    }

    static abstract class WeakKeyIntValueNode
    extends WeakKeyNode {
        volatile int value;

        WeakKeyIntValueNode(int locator, Object key, Object value, CustomConcurrentHashMap cchm) {
            super(locator, key, cchm);
            this.value = (Integer)value;
        }

        @Override
        public final Object getValue() {
            return this.value;
        }

        @Override
        public final void setValue(Object value) {
            this.value = (Integer)value;
        }
    }

    static final class WeakKeyIntValueNodeFactory
    implements NodeFactory,
    Serializable {
        private static final long serialVersionUID = 7249069346764182397L;

        WeakKeyIntValueNodeFactory() {
        }

        @Override
        public final Node newNode(int locator, Object key, Object value, CustomConcurrentHashMap cchm, Node linkage) {
            if (linkage == null) {
                return new TerminalWeakKeyIntValueNode(locator, key, value, cchm);
            }
            return new LinkedWeakKeyIntValueNode(locator, key, value, cchm, linkage);
        }
    }

    static abstract class WeakKeyNode
    extends WeakReference
    implements Node {
        final int locator;
        final CustomConcurrentHashMap cchm;

        WeakKeyNode(int locator, Object key, CustomConcurrentHashMap cchm) {
            super(key);
            this.locator = locator;
            this.cchm = cchm;
        }

        @Override
        public final int getLocator() {
            return this.locator;
        }

        @Override
        public final void onReclamation() {
            this.clear();
            this.cchm.removeIfReclaimed(this);
        }
    }

    static abstract class WeakKeySelfValueNode
    extends WeakKeyNode {
        WeakKeySelfValueNode(int locator, Object key, CustomConcurrentHashMap cchm) {
            super(locator, key, cchm);
        }

        @Override
        public final Object getValue() {
            return this.get();
        }

        @Override
        public final void setValue(Object value) {
        }
    }

    static final class WeakKeySelfValueNodeFactory
    implements NodeFactory,
    Serializable {
        private static final long serialVersionUID = 7249069346764182397L;

        WeakKeySelfValueNodeFactory() {
        }

        @Override
        public final Node newNode(int locator, Object key, Object value, CustomConcurrentHashMap cchm, Node linkage) {
            if (linkage == null) {
                return new TerminalWeakKeySelfValueNode(locator, key, cchm);
            }
            return new LinkedWeakKeySelfValueNode(locator, key, cchm, linkage);
        }
    }

    static abstract class WeakKeySoftValueNode
    extends WeakKeyNode {
        volatile EmbeddedSoftReference valueRef;

        WeakKeySoftValueNode(int locator, Object key, Object value, CustomConcurrentHashMap cchm) {
            super(locator, key, cchm);
            if (value != null) {
                this.valueRef = new EmbeddedSoftReference(value, this);
            }
        }

        @Override
        public final Object getValue() {
            EmbeddedSoftReference vr = this.valueRef;
            return vr == null ? null : vr.get();
        }

        @Override
        public final void setValue(Object value) {
            this.valueRef = value == null ? null : new EmbeddedSoftReference(value, this);
        }
    }

    static final class WeakKeySoftValueNodeFactory
    implements NodeFactory,
    Serializable {
        private static final long serialVersionUID = 7249069346764182397L;

        WeakKeySoftValueNodeFactory() {
        }

        @Override
        public final Node newNode(int locator, Object key, Object value, CustomConcurrentHashMap cchm, Node linkage) {
            if (linkage == null) {
                return new TerminalWeakKeySoftValueNode(locator, key, value, cchm);
            }
            return new LinkedWeakKeySoftValueNode(locator, key, value, cchm, linkage);
        }
    }

    static abstract class WeakKeyStrongValueNode
    extends WeakKeyNode {
        volatile Object value;

        WeakKeyStrongValueNode(int locator, Object key, Object value, CustomConcurrentHashMap cchm) {
            super(locator, key, cchm);
            this.value = value;
        }

        @Override
        public final Object getValue() {
            return this.value;
        }

        @Override
        public final void setValue(Object value) {
            this.value = value;
        }
    }

    static final class WeakKeyStrongValueNodeFactory
    implements NodeFactory,
    Serializable {
        private static final long serialVersionUID = 7249069346764182397L;

        WeakKeyStrongValueNodeFactory() {
        }

        @Override
        public final Node newNode(int locator, Object key, Object value, CustomConcurrentHashMap cchm, Node linkage) {
            if (linkage == null) {
                return new TerminalWeakKeyStrongValueNode(locator, key, value, cchm);
            }
            return new LinkedWeakKeyStrongValueNode(locator, key, value, cchm, linkage);
        }
    }

    static abstract class WeakKeyWeakValueNode
    extends WeakKeyNode {
        volatile EmbeddedWeakReference valueRef;

        WeakKeyWeakValueNode(int locator, Object key, Object value, CustomConcurrentHashMap cchm) {
            super(locator, key, cchm);
            if (value != null) {
                this.valueRef = new EmbeddedWeakReference(value, this);
            }
        }

        @Override
        public final Object getValue() {
            EmbeddedWeakReference vr = this.valueRef;
            return vr == null ? null : vr.get();
        }

        @Override
        public final void setValue(Object value) {
            this.valueRef = value == null ? null : new EmbeddedWeakReference(value, this);
        }
    }

    static final class WeakKeyWeakValueNodeFactory
    implements NodeFactory,
    Serializable {
        private static final long serialVersionUID = 7249069346764182397L;

        WeakKeyWeakValueNodeFactory() {
        }

        @Override
        public final Node newNode(int locator, Object key, Object value, CustomConcurrentHashMap cchm, Node linkage) {
            if (linkage == null) {
                return new TerminalWeakKeyWeakValueNode(locator, key, value, cchm);
            }
            return new LinkedWeakKeyWeakValueNode(locator, key, value, cchm, linkage);
        }
    }

    final class WriteThroughEntry
    implements Map.Entry<K, V>,
    Serializable {
        private static final long serialVersionUID = 7249069346764182397L;
        final K key;
        V value;

        WriteThroughEntry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Object v = this.value;
            this.value = value;
            CustomConcurrentHashMap.this.doPut(this.key, value, false);
            return v;
        }

        @Override
        public int hashCode() {
            return CustomConcurrentHashMap.this.keyEquivalence.hash(this.key) ^ CustomConcurrentHashMap.this.valueEquivalence.hash(this.value);
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return CustomConcurrentHashMap.this.keyEquivalence.equal(this.key, e.getKey()) && CustomConcurrentHashMap.this.valueEquivalence.equal(this.value, e.getValue());
        }
    }
}

