from scitools.std import *   # for curve plotting

def f1(t):
    return t**2*exp(-t**2)

def f2(t):
    return t**2*f1(t)

t = linspace(0, 3, 51)
y1 = f1(t)
y2 = f2(t)

plot(t, y1, 'r-', t, y2, 'bo',
     xlabel='t', ylabel='y',
     axis=[0, 4, -0.1, 0.6],
     legend=('t^2*exp(-t^2)', 't^4*exp(-t^2)'),
     title='Plotting two curves in the same plot',
     savefig='tmp2.eps')

# grab the backend plotting object and work with the plotting
# program directly:

if backend == 'gnuplot':
    g = get_backend()
    #g.__class__.__name__ == 'Gnuplot'
    # g is a Gnuplot object, work with Gnuplot commands directly:
    g('set label "global maximum" at 0.1,0.5 font "Times,18"')
    g('set arrow from 0.5,0.48 to 0.98,0.37 linewidth 2')
    g('save "tmp.gnu"')  # save all settings for later tuning
    g.refresh()
    g.hardcopy('tmp2.eps')  # make new hardcopy

fig = gcf(); print fig.dump()

raw_input('Press Return key to quit: ')
