#ifndef _messagecontainertypes_h
#define _messagecontainertypes_h


#include <list>
#include "messagebasictypes.h"


namespace Msg
{


template <class T>
void pushFront(Message & message, const std::list<T>  & value)
{
  typename std::list<T>::const_reverse_iterator it = value.rbegin();  // http://de.wikibooks.org/wiki/C++-Programmierung/_Die_STL/_Iteratoren
  int listCountDown=value.size();
  bool lastPart=true;
  do
  {
    int partSize=listCountDown;
    if (partSize>127)
    {
      partSize=127;
    }
    int partCountDown=partSize;
    while (partCountDown>0)
    {
      pushFront(message, *it);
      it++;
      listCountDown--;
      partCountDown--;
    }
    if (true==lastPart)
    {
      pushFrontuint8(message,partSize );
      lastPart=false;
    }
    else
    {
      pushFrontuint8(message,partSize | 0x80 ); // continue flag
    }
  }
  while (it != value.rend());
}


template <class T>
void popFront(Message & message, std::list<T>  & returnValue)
{
  returnValue.erase(returnValue.begin(),returnValue.end());

  bool continueFlag=true;
  while (continueFlag)
  {
    uint8 partSize;
    popFrontuint8(message,partSize);
    if (0x80 == (partSize&0x80) )
    {
      continueFlag=true;
      partSize&=0x7f;
    }
    else
    {
      continueFlag=false;
    }
    for (int i=0; i<partSize; i++)
    {
      T oneValue;
      popFront(message, oneValue);
      returnValue.push_back(oneValue);
    }
  }
}


}


#endif
