#ifndef _tcpmessageserver_h
#define _tcpmessageserver_h

#include <asio.hpp>
#include <string>
#include <boost/noncopyable.hpp>
#include "tcpmessageserverconnection.h"


class TCPMessageServer : private boost::noncopyable
{
private:
  asio::io_service & ioservice;
  asio::ip::tcp::acceptor acceptor;

  ServerConnectorFactoryBase & serverConnectorFactoryBase;

  void handleAccept(const asio::error_code& e);
  void handleStop();

  TCPMessageServerConnectionManager tcpMessageServerConnectionManager;

  connection_ptr newConnection;

public:
  explicit TCPMessageServer(asio::io_service& io_service, const asio::ip::tcp::endpoint & endpoint, ServerConnectorFactoryBase & serverConnectorFactoryBase);

  void run();

  void stop();
};


#endif
