#ifndef _protocoltimerasio_h
#define _protocoltimerasio_h


#include "protocoltimer.h"
#include <asio.hpp>


class ProtocolIOAsio : public ProtocolIO
{
private:
  asio::io_service & ioservice;

public:
  ProtocolIOAsio(asio::io_service & ioservice);

  boost::posix_time::ptime currentTimeUTC();
  TheTimerObjectBase * getTimer();
};


class TheTimerObjectAsio : public TheTimerObjectBase
{
private:
  asio::io_service & ioservice;
  asio::deadline_timer timer;

  void timerExpiredEvent(const asio::error_code& err);

public:
  TheTimerObjectAsio(asio::io_service & ioservice);
  ~TheTimerObjectAsio();

  void startAlarmAt(const boost::posix_time::ptime & time, TimerEventHandlerBase * handler);
  void startAlarmAfter(const boost::posix_time::time_duration & expiry_time, TimerEventHandlerBase * handler);
  void stop();
};


#endif
