/* emacs edit mode for this file is -*- C++ -*- */
/* $Id: feval.m4,v 1.8 1999/02/16 16:14:06 schmidt Exp $ */

ftestSetNameOfGame( feval, `"
Usage: feval [<options>] [<envSpec>] [expand=<n>] <f>
  evaluates canonical form <f>.

  In contrast to the other programs of the Factory Test
  Environment, <f> may span more than one argument.  More
  precisely, all arguments are textually pasted together and are
  then evaluated as one canonical form.  If there are not any
  arguments (except options), neither time nor status nor result
  nor data information is printed.

  The `-a' and `-c' options are ignored by `feval'.

  If the optional argument `expand' is given, <f> is printed
  in a format dependent on <n>:
  <n> = 0: print <f> in standard format (default)
  <n> = 1: print <f> in NTL format, i.e., as a dense vector of
           coefficients (for univariate polynomials only)
"'`' )
dnl // the trailing quotes at the end of the second argument
dnl // are for font-lock only (another font-lock-trick)

//{{{ docu
//
// ftestAlgorithm.m4 - ftestAlgorithm test program.
//
// To create ftestAlgorithm.cc, run m4 using the ftest_util.m4 library in
// the following way:
//
// m4 ftest_util.m4 ftestAlgorithm.m4 > ftestAlgorithm.cc
//
//}}}

// necessary to paste the arguments together
#include <string.h>

ftestPreprocInit();

ftestGlobalInit();

//
// - main program.
//
int
main ( int argc, char ** argv )
{
    // initialization
    ftestMainInit();
    check = Passed;

    // print long usage if called with exactly one argument `-?'
    if ( argc == 2 && strcmp( "-?", argv[1] ) == 0 ) {
	ftestUsagePrint( "

              Options common to all test programs
               of the Factory Test Environment:
               --------------------------------


Some examples first:

feval /13/xy <f>

  Evaluates <f> in the finite field with 13 elements and
  with x < y.  Prints result of evaluation.

feval -oa /x,y,i=x^2+1/+SW_RATIONAL <f>

  Evaluates <f> in the field Q[i], where the algebraic element
  i has the minimal polynomial x^2+1.  DO NOT FORGET TO SET
  `SW_RATIONAL' WHEN CALCULATING WITH ALGEBRAIC ELEMENTS OF
  CHARACTERISTIC 0.  Variable ordering is as above.
  Prints result and the complete environment.

feval /13^2,Z/x,y,a=x^2+Z^3 <f>

  Evaluate <f> over the field GF(13^2)[a], where GF(13^2) is
  generated by a primitive element Z and a has the minimal
  polynomial x^2+Z^3.  DO NOT FORGET TO SPECIFY THE
  CHARACTERISTIC BEFORE YOU SPECIFY ANY MINIMAL POLYNOMIAL.
  Variable ordering is as above.


Now for the detailed options:

  <options>:
            -a <time>:  sets maximal running time (in seconds)
            -c <times>: sets number of runs
            -o <outputOptions>: specifies what information to
              print

            An option `--' may be used to terminate parsing
            of the options.  This is especially useful if the
            some of the arguments start with a negative number.

  <outputOptions>:
            a: everything
            c: check                            r: result
            e: computing environment            t: time

            Without any output options, prints the result only.

  <envSpec>:
            /<charSpec><envSpec>
            /<varSpec><envSpec>
            /<switchSpec><envSpec>
            /<randomSpec><envSpec>

            Sets the computing environment, e.g., the variable
            ordering, the characteristic, etc.

  <charSpec>:
            <n>
               where <n> is either zero or a prime number
            <p>^<d>[,<Z>]
               where <p> is a prime number and <d> an integer
               greater or equal 2.  The optional <Z> should be
               a single character.

            Sets the characteristic to <charSpec>.  With <n> = 0
            calculations are done in characteristic zero.  With
            <n> being a prime number, calculations are done over
            the finite field with <n> elements.  With <p>^<d>
            calculations are done over the finite Galois field
            with <p>^<d> elements.  The optional character <Z>
            specifies the symbol to print for the generator of
            that field.

  <varSpec>:
            <varName[=<minPoly>]>[,]<varSpec>
               where <varName> is a single character and the
               optional <minPoly> is an irreducible polynomial
               over the current domain.  The `,' between
               variables may be omitted if there is no
               minimal polynomial specified.

            Defines variable ordering and algebraic elements.
            Variables occurring later in the list get higher
            level.  If <minPoly> is specified, the corresponding
            variable is defined to be an algebraic variable with
            minimal polynomial <minPoly>.

  <switchSpec>:
            [+|-]<switchName>
               where <switchName> is one of the switches
               specified in `cf_defs.h'.

            Turns switch <switchName> on resp off.  The most
            useful switches are:
            SW_RATIONAL: to calculate over the rational
              numbers instead of the rational integers;
            SW_SYMMETRIC_FF: to use symmetric
              representation of finite fields;
            SW_USE_EZGCD: to use EZ-GCD to compute the
              gcd of multivariate polynomials over the
              integers.

  <randomSpec>:
            @<n>
               where <n> is an integer

            Sets random generator seed to <n>.
" );
	exit( 0 );
    }

    // declare input and output variables
    ftestInVar( int, expand );
    ftestOutVar( CanonicalForm, f );

    // process argument list and set environment
    ftestGetOpts();
    ftestGetEnv();
    ftestGetInVar( expand, 0, "expand" );

    if ( argv[optind] ) {
	int i = optind;
	int len = 0;

	// get length of arguments
	while ( argv[i] ) {
	    len += strlen( argv[i] );
	    i++;
	}

	// paste arguments together
	char * argString = new char[len+1];
	argString[0] = '\0';
	while ( optind < i ) {
	    strcat( argString, argv[optind] );
	    optind++;
	}
	
	ftestReadString( argString, f );
	delete [] argString;
	ftestOutput( "f", f );
    }

    // clean up
    ftestMainExit();
}
