/*
 * ----------------------------------------------------------------
 *
 * Memory and IO-Memory Access for 64 Bit bus with
 * IO-Handler registration and Translation Tables from Targets Physical
 * address (TPA) to hosts virtual Address (HVA)
 *
 * (C) 2008 Jochen Karrer 
 *   Author: Jochen Karrer
 *
 *  Status:
 *	not implemented
 *
 *  This program is free software; you can distribute it and/or modify it
 *  under the terms of the GNU General Public License (Version 2) as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope it will be useful, but WITHOUT
 *  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 *  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 *  for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place - Suite 330, Boston MA 02111-1307, USA.
 *
 * ----------------------------------------------------------------
 */
#include <stdint.h>
#define PG_TRACED		(1)
#define PG_TRANS_FINISHED	(2)
#define PG_TYPE_MASK		(3)

typedef struct PageDirectory {
	void *pte[16484];
	int use_count;
} PageDirectory;

static int level_shift[4] = { 50, 36, 22, 10 };
static uint32_t level_mask[4] = { 0x3fff,0x3fff,0x3fff,0x0fff};
static uint32_t level_nr_entries[4] = { 0x4000,0x4000,0x4000,0x1000};

static uint8_t *flvl[16384]; 

void *
Bus64ToHVA(uint64_t addr) {
	int i;
	int shift;
	unsigned long pg_type;
	uint32_t mask;	
	uint8_t **ptr = flvl;	
	for(i=0;i<4;i++) {
		shift = level_shift[i];	
		mask = level_mask[i];	
		int index = (addr >> shift) & mask;
		ptr = (uint8_t **)ptr[index];		
		pg_type = ((unsigned long) ptr) & PG_TYPE_MASK;
		if(pg_type & PG_TRANS_FINISHED) {
			ptr-=pg_type;
			mask = ((1<<shift) - 1);
				
			return ptr + (addr & mask);
		}	
	}
	/* Bug if reached */
	return NULL;	
}

/* 
 * ---------------------------------------------------------------------------------- 
 *
 * ---------------------------------------------------------------------------------- 
 */
void
Bus64_MapMem(uint64_t map_addr,uint8_t *start_mem,uint64_t devsize,uint64_t mapsize) 
{
	uint64_t addr;
	for(addr=map_addr;addr < mapsize;addr += pagesize) {
		
	}
}
