/*
 * ----------------------------------------------------
 *
 * Emulation of the MCF5282 FlexCAN module
 * (C) 2008 Jochen Karrer
 *   Author: Jochen Karrer
 *
 * State:
 *      Not implemented
 *
 *  This program is free software; you can distribute it and/or modify it
 *  under the terms of the GNU General Public License (Version 2) as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope it will be useful, but WITHOUT
 *  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 *  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 *  for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place - Suite 330, Boston MA 02111-1307, USA.
 *
 * ----------------------------------------------------
 */

#include <fcntl.h>
#include <unistd.h>
#include <string.h>
#include <stdint.h>
#include <errno.h>
#include <fio.h>
#include <bus.h>
#include <signode.h>
#include <cycletimer.h>
#include <sgstring.h>
#include <mcf5282_flexcan.h>

#define FC_MCB(base) 		((base) + 0x1c0000)
#define FC_CANCTRL0(base)	((base) + 0x1c0006)
#define FC_CANCTRL1(base)	((base) + 0x1c0007)
#define FC_PRESDIV(base)	((base) + 0x1c0008)
#define FC_CANCTRL2(base)	((base) + 0x1c0009)
#define FC_TIMER(base)		((base) + 0x1c000a)
#define FC_RXGMASK(base)	((base) + 0x1c0010)
#define FC_RX14MASK(base)	((base) + 0x1c0014)
#define FC_RX15MASK(base)	((base) + 0x1c0018)
#define FC_ESTAT(base)		((base) + 0x1c0020)
#define FC_IMASK(base)		((base) + 0x1c0022)
#define FC_IFLAG(base)		((base) + 0x1c0024)
#define FC_RXECTR(base)		((base) + 0x1c0026)
#define FC_TXECTR(base)		((base) + 0x1c0027)

/* Offsets in messagebuffers */
#define EXMSGB_CTRL_STAT(base)	((base)+0)
#define EXMSGB_ID_HIGH(base)	((base)+2)	
#define EXMSGB_ID_LOW(base)	((base)+4)
#define EXMSGB_DATABYTE0(base)	((base)+6)
#define EXMSGB_DATABYTE1(base)	((base)+7)
#define EXMSGB_DATABYTE2(base)	((base)+8)
#define EXMSGB_DATABYTE3(base)	((base)+9)
#define EXMSGB_DATABYTE4(base)	((base)+0xa)
#define EXMSGB_DATABYTE5(base)	((base)+0xb)
#define EXMSGB_DATABYTE6(base)	((base)+0xc)
#define EXMSGB_DATABYTE7(base)	((base)+0xd)


typedef struct FlexCAN {
        BusDevice bdev;
} FlexCAN;

static void
FlexCAN_Unmap(void *owner,uint32_t base,uint32_t mask)
{
//        IOH_Delete32(SCM_IPSBAR(base));
}

static void
FlexCAN_Map(void *owner,uint32_t base,uint32_t mask,uint32_t mapflags)
{
//       FlexCAN *can = (FlexCAN *) owner;
//        IOH_New32(SCM_IPSBAR(base),ipsbar_read,ipsbar_write,scm);
}

BusDevice *
MCF5282_FlexCANNew(const char *name)
{
        FlexCAN *can = sg_calloc(sizeof(FlexCAN));
        can->bdev.first_mapping=NULL;
        can->bdev.Map=FlexCAN_Map;
        can->bdev.UnMap=FlexCAN_Unmap;
        can->bdev.owner=can;
        can->bdev.hw_flags=MEM_FLAG_WRITABLE|MEM_FLAG_READABLE;
        return &can->bdev;

}

