2.4 Duración con Sobres

# Duración con Sobres

En una sección anterior, miramos cómo utilizar el comando `sleep` 
para controlar cuándo disparar sonidos. Sin embargo, aún no hemos
podido controlar la duración de nuestros sonidos.

A manera de tener una sencilla, pero poderosa manera de *controlar
la duración* de nuestros sonidos, Sonic Pi provee la noción de un
*sobre de amplitud ADSR* (después cubriremos lo que significa 
ADSR). Un sobre de amplitud ofrece dos útiles aspectos de contro:

* control sobre la duración del sonido
* control sobre la amplitud del sonido

## Duración

Duración es la longitud del sonido. Una mayor duración significa que
escucharás el sonido por más tiempo. Todos los sonidos de Sonic -Pi
tienen un sobre de control de la amplitud y la duración total del sobre
es la duración del sonido. Por lo tanto, al controlar el sobre, controlas
la duración.

## Amplitud

El sobre ADSR no sólo controla la duración, también te permite
control fino de la amplitud del sonido. Todos los sonidos audibles
comienzan y terminan en silencio, conteniendo partes no-silentes
en medio. Los sobres permiten deslizar y mantener la amplitud de 
las partes no-silente. Es como darle instrucciones a alguien sobre
cómo subir y bajar el volumen del amplificador de una guitarra.
Por ejemplo, puedes pedirle a alguien "comienza en silencio, 
lentamente llega a máximo volumen, manténlo por un momento y
rápidamente vuelve a silencio". Sonic Pi te permite controlar
exactamente esta conducta con los sobres.

Recapitulando lo visto anteriormente, una amplitud de 0 es silencio
y una amplitud de 1 es volumen normal

Ahora, veamos cada parte del sobre.

## Fase Release (desenganche)

La única parte del sobre que es utilizada predeterminadamente
es el release, que es el tiempo que le toma al sintetizador para 
apagar el sonido completamente. Todos los sintetizadores tienen
un tiempo de release de 1, lo que significa que tienen una duración
de un pulso (el cual por defecto es 1 segundo, si el BPM es 60)


```
play 70
```

La nota será audible por 1 segundo. Vamos, cronométralo!
Esta es la manera abreviada de decir lo mismo que:

```
play 70, release: 1
```

¡Notas que suenan exactamente igual los últimos dos comandos!
Sin embargo, es ahora muy fácil cambiar la duración con tan sólo
modificar el valor del `release:` :

```
play 60, release: 2
```

Podemos hacer que el sintetizador suene por un periodo de tiempo muy
corto al poner un valor de release muy pequeño:


```
play 60, release: 0.2
```
La duración del apagado del sonido es lo que llamamos
*fase de release* y por defecto es una transición lineal. El siguiente
diagrama ilustra esta transición:


![release envelope](../images/tutorial/env-release.png)

La línea vertical en la izquierda del diagrama muestra que el sonido
comienza con 0 amplitud, pero llega a amplitud completa (esto es el 
ataque, que cubriremos próximamente). Una vez que la amplitud es 
máxima, se mueve en línea recta hacia abajo hasta llegar a cero, 
tomando el tiempo que para ello se especificó en `release:`.
*Entre más largos son los tiempos de release, más tiempo le toma
al sintetizador desvanecerse.*

Puedes, por tanto, cambiar la duración de tu sonido, cambiando el 
tiempo de release. ¡Prueba varios tiempos de release en tu música!

## Fase de Ataque

Por defecto, la *fase de ataque* es 0 para todos los sintetizadores, lo 
que significa que pasan de amplitud 0 a 1 inmediatamente. Esto le da
al sintetizador un percusivo sonido inicial. Sin embargo, podrías desear
encender tu sonido de a poco. Esto se logra con el operador `attack:` . 
Prueba encender tu sonido de a poco:

```
play 60, attack: 2
sleep 3
play 65, attack: 0.5
```


Puedes utilizar múltiples operadores al mismo tiempo. Por ejemplo
para un ataque corto y un largo release, prueba:

```
play 60, attack: 0.7, release: 4
```
Este sobre con ataque corto y largo release queda ilustrado en el 
siguiente diagrama:


![attack release envelope](../images/tutorial/env-attack-release.png)

También puedes invertir las cosas. Intenta con un ataque largo y un
release corto:


```
play 60, attack: 4, release: 0.7
```

![long attack short release envelope](../images/tutorial/env-long-attack-short-release.png)


Finalmente, puedes tener el ataque y el release cortos, para obtener
sonidos cortos.


```
play 60, attack: 0.5, release: 0.5
```

![short attack short release envelope](../images/tutorial/env-short-attack-short-release.png)

## Fase de Sostenimiento

Adicionalmente a especificar los tiempos de ataque y release, también
puedes especificar el tiempo de sostenimiento para controlar la *fase de
sostenimiento*. Este es el tiempo en el cual el sonido es mantenido a 
máxima amplitud entre las fases de ataque y release.

```
play 60, attack: 0.3, sustain: 1, release: 1
```

![ASR envelope](../images/tutorial/env-attack-sustain-release.png)

El sostenimiento es útil para importantes sonidos a los que desees
darles máxima presencia a la mezcla antes de entrar a la fase de
release. Claro, es totalmente válido usar ambos operandos, `attack:`
y `release:` opts a 0 y dejar el sostenimiento sin aparecimiento
gradual ni desvanecimiento. Sin embargo, ten en cuenta que un release
de 0 puede producir clicks en el audio y es aconsejable usar un valor
muy pequeño como 0.2.


## Fase de Decaimiento

Para un nivel extra de control, también puedes especificar el tiempo 
de decaimiento. Esta es la fase del sobre que está entre el ataque el
ataque y el sostenimiento, especifica el tiempo donde la amplitud
bajará desde el nivel de ataque al de desvanecimiento `attack_level:` 
`decay_level:` (a menos que especiques que será sujetado al nivel de 
sostenimiento `sustain_level:`). De hecho, el `decay:` operando es 0
y tanto el ataque como el sostenimiento tienen valor 1, así que deberás
especificarlos para que el tiempo de decaimiento tenga efecto.

```
play 60, attack: 0.1, attack_level: 1, decay: 0.2, sustain_level: 0.4, sustain: 1, release: 0.5
```

![ADSR envelope](../images/tutorial/env-attack-decay-sustain-release.png)


## Nivel de Decaimiento

Un último truco es que aunque el `decay_level:` opt está predeterminado
a ser el mismo valor que el `sustain_level:` puedes ser explícito y 
asignarles diferentes valores para un completo control del sobre.
Esto permite crear sobres como el siguiente:

```
play 60, attack: 0.1, attack_level: 1, decay: 0.2, decay_level: 0.3, sustain: 1, sustain_level: 0.4, release: 0.5
```

![ASR envelope](../images/tutorial/env-decay-level.png)

También es posible poner el `decay_level:` más elevado que el
`sustain_level:`:

```
play 60, attack: 0.1, attack_level: 0.1, decay: 0.2, decay_level: 1, sustain: 0.5, sustain_level: 0.8, release: 1.5
```

![ASR envelope](../images/tutorial/env-decay-level-2.png)

## Sobres ADSR 

Para resumir, los sobres ADSR de Sonic Pi tienen las siguientes
fases:

1. *ataque* - tiempo desde amplitude 0 hasta el `attack_level`,
2. *decaimiento* - tiempo para mover la amplitud desde `attack_level` a `decay_level`,
3. *sostenimiento* - tiempo para mover la amplitud desde `decay_level` a `sustain_level`,
4. *release* - tiempo para mover la amplitud desde `sustain_level` a 0

Es importante recalcar que la duración de un  sonido es la sumatoria
de los tiempos de todas las fases. Por tanto, el siguiente sonido tendrá
una duración de 0.5 + 1 + 2 + 0.5 = 4 pulsos:

```
play 60, attack: 0.5, attack_level: 1, decay: 1, sustain_level: 0.4, sustain: 2, release: 0.5
```

Ahora ve a jugar con sobres en tus sonidos...
