/*
 * The Spread Toolkit.
 *     
 * The contents of this file are subject to the Spread Open-Source
 * License, Version 1.0 (the ``License''); you may not use
 * this file except in compliance with the License.  You may obtain a
 * copy of the License at:
 *
 * http://www.spread.org/license/
 *
 * or in the file ``license.txt'' found in this distribution.
 *
 * Software distributed under the License is distributed on an AS IS basis, 
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License 
 * for the specific language governing rights and limitations under the 
 * License.
 *
 * The Creators of Spread are:
 *  Yair Amir, Michal Miskin-Amir, Jonathan Stanton.
 *
 *  Copyright (C) 1993-2004 Spread Concepts LLC <spread@spreadconcepts.com>
 *
 *  All Rights Reserved.
 *
 * Major Contributor(s):
 * ---------------
 *    Cristina Nita-Rotaru crisn@cs.purdue.edu - group communication security.
 *    Theo Schlossnagle    jesus@omniti.com - Perl, skiplists, autoconf.
 *    Dan Schoenblum       dansch@cnds.jhu.edu - Java interface.
 *    John Schultz         jschultz@cnds.jhu.edu - contribution to process group membership.
 *
 */

#ifndef INC_AUTH_PWORD_CLIENT
#define INC_AUTH_PWORD_CLIENT

#define MAX_PWORD_USERNAME 32
#define MAX_PWORD_PASSWORD 8
#define MAX_PWORD_CRYPTPASSWORD 13

struct user_password {
    char username[MAX_PWORD_USERNAME + 1];
    char password[MAX_PWORD_PASSWORD + 1];
};

/* callbacks */
int  pword_authenticate(int fd, void *data_p);

#endif /* INC_AUTH_PWORD_CLIENT */
