#include "common.h"
#ifndef OPENSSL_NO_DH
#define DN_new DH_new
#ifndef HEADER_DH_H
# include <openssl/dh.h>
#endif

DH *get_dh2048()
{
    static unsigned char dhp_2048[] = {
	0x98, 0x96, 0x59, 0xBA, 0x22, 0x10, 0xC4, 0x90, 0x2E, 0xC5, 
	0x16, 0xAE, 0xE7, 0x0E, 0xC9, 0x97, 0xDB, 0xE9, 0x85, 0x28, 
	0xBA, 0x05, 0x5A, 0x50, 0x99, 0x72, 0xFE, 0xEC, 0x36, 0x12, 
	0xF7, 0x7A, 0x27, 0x62, 0x20, 0x2E, 0xB9, 0xD5, 0x6C, 0xCD, 
	0x15, 0x70, 0xEE, 0xA3, 0x07, 0x2B, 0xE7, 0x75, 0x0C, 0xBE, 
	0xCB, 0x28, 0x00, 0x23, 0x43, 0xD7, 0xAA, 0x37, 0xD5, 0x64, 
	0xFD, 0x41, 0x35, 0x6E, 0x0D, 0xA5, 0x85, 0x2E, 0x77, 0x92, 
	0xD2, 0xE8, 0xBC, 0x08, 0xAF, 0xBB, 0x43, 0x67, 0x1B, 0xFA, 
	0x68, 0x68, 0x19, 0x76, 0xE3, 0xE9, 0x30, 0xC4, 0xD2, 0x8E, 
	0x28, 0x3D, 0x42, 0x9D, 0x6C, 0xAE, 0xC7, 0x89, 0x8A, 0x30, 
	0x52, 0xC0, 0x37, 0xA6, 0xC1, 0x82, 0xFB, 0xE2, 0xB2, 0x8A, 
	0x31, 0x02, 0xCA, 0x6A, 0x39, 0x9A, 0x72, 0xBD, 0x6D, 0xF9, 
	0xB6, 0x12, 0x16, 0x75, 0xA8, 0xAA, 0xF7, 0x28, 0xD7, 0x70, 
	0x55, 0xCF, 0x24, 0xF1, 0x63, 0xC5, 0xA6, 0x7F, 0x01, 0xC1, 
	0x7A, 0xDC, 0x8F, 0x3D, 0x27, 0xBA, 0xD6, 0x24, 0xDF, 0x40, 
	0x93, 0xF3, 0x8E, 0xB2, 0xAF, 0x0D, 0xB0, 0xF3, 0xC7, 0xB3, 
	0x72, 0x42, 0xBE, 0x7E, 0xA8, 0x60, 0x31, 0x43, 0x69, 0x4F, 
	0x37, 0xD8, 0x61, 0x98, 0x86, 0x0F, 0x4D, 0xE8, 0xBE, 0xAA, 
	0x40, 0xD8, 0xF5, 0xD0, 0x5B, 0x94, 0x53, 0x59, 0x6E, 0x38, 
	0xA3, 0x23, 0x21, 0xC7, 0xE4, 0x47, 0x88, 0x96, 0x77, 0xF1, 
	0xC1, 0x50, 0x1F, 0xE8, 0xB9, 0xA8, 0xF4, 0xAB, 0x31, 0x67, 
	0x53, 0x67, 0xD7, 0x18, 0x92, 0x89, 0xF3, 0xF9, 0x34, 0xC2, 
	0x6E, 0x12, 0x2B, 0xAC, 0xEA, 0x6B, 0xA5, 0xE3, 0x5B, 0xC9, 
	0x61, 0x7B, 0xDE, 0x4A, 0x0B, 0x8A, 0xFD, 0x43, 0x72, 0xDE, 
	0x78, 0x0D, 0x8E, 0xE9, 0x26, 0x69, 0x35, 0x1C, 0xAD, 0xF1, 
	0x82, 0xAA, 0xA2, 0x80, 0x75, 0x13
    };
    static unsigned char dhg_2048[] = {
	0x02
    };
    DH *dh = DH_new();
    BIGNUM *dhp_bn, *dhg_bn;

    if (dh == NULL)
        return NULL;
    dhp_bn = BN_bin2bn(dhp_2048, sizeof (dhp_2048), NULL);
    dhg_bn = BN_bin2bn(dhg_2048, sizeof (dhg_2048), NULL);
    if (dhp_bn == NULL || dhg_bn == NULL
            || !DH_set0_pqg(dh, dhp_bn, NULL, dhg_bn)) {
        DH_free(dh);
        BN_free(dhp_bn);
        BN_free(dhg_bn);
        return NULL;
    }
    return dh;
}
#endif /* OPENSSL_NO_DH */
