/*----------------------------------------------------------------------------*/
/*                                                                            */
/* [cfg_dfn.h]       Context Free Grammar: symbol and production types        */
/*                                                                            */
/* Copyright (c) 1993 by Doelle, Manns                                        */
/*----------------------------------------------------------------------------*/

/* File generated by 'ctoh'. Don't change manually. */

#ifndef cfg_dfn_INCL
#define cfg_dfn_INCL


#include "standard.h"


#ifdef __cplusplus
extern "C" {
#endif


/* ----------------------- Symbol types ------------------------------------- */


#define PLR_TYP_NTM  0 /* Nonterminal       */
#define PLR_TYP_TOK  1 /* Token             */
#define PLR_TYP_KEY  2 /* Keyword           */
#define PLR_TYP_WKY  3 /* Wide Keyword      */
#define PLR_TYP_CFG  4 /* Language token    */
#define PLR_TYP_COM  5 /* Comment           */

/* Terminal <--> Comment */

#define CFG_TERM_TO_COM(typ) ( (typ) + PLR_TYP_COM )
#define CFG_COM_TO_TERM(typ) ( (typ) - PLR_TYP_COM )

/* Recognizer */

#define CFG_NTM(typ)      ( (typ) == PLR_TYP_NTM )
#define CFG_CFG(typ)      ( (typ) == PLR_TYP_CFG )
#define CFG_TOK(typ)      ( (typ) == PLR_TYP_TOK || (typ) == PLR_TYP_CFG )
#define CFG_KEY(typ)      ( (typ) == PLR_TYP_KEY || (typ) == PLR_TYP_WKY )
#define CFG_WCKEY(typ)    ( (typ) == PLR_TYP_WKY )
#define CFG_COM(typ)      ( (typ) >= PLR_TYP_COM )

#define CFG_TOK_NTM(typ)  ( CFG_TOK(typ)     || CFG_NTM(typ) )
#define CFG_TOK_KEY(typ)  ( CFG_TOK(typ)     || CFG_KEY(typ) )
#define CFG_TERMINAL(typ) ( CFG_TOK_KEY(typ) || \
                            ( CFG_COM(typ) && (typ) != PLR_TYP_COM ) )

/* ------------------- Production types: special recognizer ----------------- */

c_bool nilProd(c_string prod);         /* production name = "nil" ?         */
c_bool consProd(c_string prod);        /* production name = "cons" ?        */
c_bool ignProd(c_string prod);         /* production name = "ign#*" ?       */
c_bool noneProd(c_string prod);        /* production name = "none" ?        */
c_bool someProd(c_string prod);        /* production name = "some" ?        */


#ifdef __cplusplus
}
#endif

#endif
