/* ====================================================================
 * Copyright (c) 2003-2008  Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_LISTWIDGET_H
#define _SC_LISTWIDGET_H

// sc
#include "svn/DirEntry.h"
#include "svn/WcStatus.h"
#include "svn/Revision.h"
#include "util/Id.h"
class ScModel;
class Project;
class ScLvi;
class RepositoryLvi;
class RepositoryModel;
class WcModel;
class Controller;
class Bookmark;
class BookmarkView;
class BookmarkViewModel;
class Splitter;
class WcViewLogWidget;
class WcViewModel;
class RpViewModel;
class LogViewModel;
class DiffViewModel;
class MergeViewModel;
class BlameViewModel;
class LogGraphViewModel;
class ActionStorage;
class UpdateParam;
class ExportParam;
class CopyParam;
class LockParam;
class UnlockParam;
class CommitParam;
class CheckoutParam;
class SwitchParam;

// qt
#include <QtGui/QWidget>
class Q3WidgetStack;

// sys
#include <map>

typedef std::map< ID, int > Ids;

class ListWidget : public QWidget 
{
  typedef QWidget super;
  Q_OBJECT 

public:
  ListWidget( Controller*, ActionStorage* as, QWidget *parent=0 );
  virtual ~ListWidget();

  ScModel* getModel() const;

  void addProject( Project* prj );

  // QWidget overwrite
  void customEvent( QEvent* ce );
  void installChildEventFilter( const QObject* filter );

public slots:
  void showEmptyFiles();
  void showProject();

  /** create a new working copy view */
  void newView( ID id, WcViewModel* model );
  /** create a new repository view */
  void newView( ID id, RpViewModel* model );
  /** delete the given view */
  void delView( ID id );
  /** show the given view */
  void showView( ID id );

  /** show the given patch file */
  void showPatch( const QString& source, const QString& patch );
  /** show the given file content */
  void showCat( const QString& source, const QString& content );
  /** show commit dialog */
  void showCommit( bool bookmark, WcViewModel* );
  /** show property dialog */
  void showProps( WcViewModel* );
  /** show log dialog */
  void showLog( LogViewModel* );
  /** show diff dialog */
  void showDiff( DiffViewModel* );
  /** show merge dialog */
  void showMerge( MergeViewModel* );
  /** show log graph dialog */
  void showLogGraph( LogGraphViewModel* model );
  /** show blame dialog */
  void showBlame( BlameViewModel* model );
  // show bookmark dialogs
  void showEditBookmark( Bookmark*, bool& changed );
  // show project wizard
  void showNewProjectBookmark( Project*, bool& changed );
  // show remove bookmark confirm request
  void showRemoveBookmark( Bookmark*, bool& changed );

  /** show parameters/confirmation request */
  void confirmRevert( bool& proceed );
  void confirmRemove( bool unversioned, bool& force, bool& proceed );
  void confirmRemove( bool& proceed );
  void confirmUpdate( UpdateParam*, bool& proceed );
  void confirmExport( ExportParam*, bool& proceed );
  void confirmMkdir( sc::String& dir, bool& proceed );
  void confirmCopy( CopyParam*, Project*, bool& proceed );
  void confirmLock( LockParam*, bool& proceed );
  void confirmUnlock( UnlockParam*, bool& proceed );
  void confirmResolved( bool& proceed );
  void confirmCheckout( CheckoutParam*, Project*, bool& proceed );
  void confirmSwitch( SwitchParam*, Project*, bool& proceed );
  void confirmAutoUpdate( bool& proceed );
  void confirmCreateRepository( bool& proceed );

private:
  Splitter*        _splith;
  Q3WidgetStack*   _stackFiles;
  Splitter*        _splitv;
  WcViewLogWidget* _log;
  
  ScModel*         _model;

  Controller*      _controller;
  BookmarkView*    _bookmarkView;
  ActionStorage*   _actions;

  Ids              _ids;
};

#endif // _SC_LISTWIDGET_H
