/* ====================================================================
 * Copyright (c) 2003-2007, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

// sc
#include "config.h"
#include "RemoveDialog.h"
#include "sublib/Gui.h"

// qt
#include <QtGui/QLayout>
#include <QtGui/QPushButton>
#include <QtGui/QLabel>
#include <QtGui/QComboBox>
#include <QtGui/QFileDialog>
#include <QtGui/QToolTip>
#include <QtGui/QCheckBox>
#include <QtGui/QTextEdit>
#include <QtGui/QListView>
#include <Qt3Support/Q3GroupBox>
#include <Qt3Support/Q3VBox>



RemoveDialog::RemoveDialog( QWidget *parent, bool force, bool unversioned )
: super( parent, 0, true )
{
  setCaption( _q("subcommander:remove") );

  QVBoxLayout *vbl = new QVBoxLayout(this,5,8);
  vbl->setSpacing(10);
  {
    Q3GroupBox* gb = new Q3GroupBox(1,Qt::Vertical,this);
    gb->setTitle( _q("remove options: ") );
    //gb->setInsideSpacing(10);
    gb->setInsideMargin(0);
    gb->setFlat(true);
    vbl->addWidget(gb);

    QHBoxLayout* h1 = new QHBoxLayout;
    vbl->addLayout(h1);
    {
      _force = new QCheckBox(_q("&remove modified and/or unversioned items"),this);
      _force->setChecked(force);
      h1->addWidget(_force);
    }

    if( unversioned )
    {
      QLabel* l1 = new QLabel(this);
      l1->setText(_q("You have selected unversioned items. Note that these items can not be restored!"));
      vbl->addWidget(l1);
    }

    QHBoxLayout* hu = new QHBoxLayout;
    vbl->addLayout(hu);
    {
      // eats extra space, so the buttons keep their size
      hu->addStretch(1); 

      _ok = new QPushButton(this);
      _ok->setText( _q("&Remove") );
      _ok->setDefault(true);
      hu->addWidget(_ok);
      QPushButton* ca = new QPushButton(this);
      ca->setText( _q("&Cancel") );
      hu->addWidget(ca);
      
      hu->addSpacing(getSizeGripSpacing());

      connect( _ok, SIGNAL(clicked()), SLOT(accept()) );
      connect( ca, SIGNAL(clicked()), SLOT(reject()) );
    }
  }

  // don't resize vertically.
  setMaximumHeight( sizeHint().height() );
}

RemoveDialog::~RemoveDialog()
{
}

bool RemoveDialog::getForce() const
{
  return _force->isChecked();
}
