/* ====================================================================
 * Copyright (c) 2007-2008  Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_RPVIEWMODEL_H
#define _SC_RPVIEWMODEL_H

// sc
#include "ListCache.h"
#include "RpSelection.h"
#include "sublib/TargetId.h"
#include "svn/ClientTypes.h"
#include "svn/Revision.h"
class Bookmark;
class Project;
class ScModel;
class DiffViewModel;
class MergeViewModel;
class ListParam;
class DiffParam;
class MoveParam;
class CopyParam;
class CheckoutParam;
class SwitchParam;
namespace sc {
  class Error;
}

// qt
#include <QtCore/QObject>

// sys
#include <map>
#include <set> 


class EntriesInfo
{
public:
  svn::DirEntries entries;
};

typedef std::map< sc::String, EntriesInfo > Entries;
typedef std::set< sc::String >              Running;


class RpViewModel : public QObject, public ListCache, public TargetId
{
  typedef QObject super;
  Q_OBJECT

public:
  RpViewModel( Bookmark* bm, ScModel* model );
  ~RpViewModel();

  // QObject
  bool event( QEvent* e );

  // ListCache
  void setRpList( const sc::String& url, svn::Revnumber rev, const svn::DirEntries& list );
  bool getRpList( const sc::String& url, svn::Revnumber rev, svn::DirEntries& list );

  // Commands
  void reload();

  void list();
  void listRefresh( const sc::String& path );
  void listRefresh( const svn::Paths& paths );
  void list( const sc::String& url, bool refresh );
  void listResult( ListParam*, const sc::Error* );
  void branchTag( bool bookmark = false );
  void checkout( bool bookmark = false );
  void switchx( bool bookmark = false );
  void diff( bool bookmark = false );
  void merge( bool bookmark = false );
  void mkdir( bool bookmark = false );
  void import( bool bookmark = false );
  void exportx( bool bookmark = false );
  void remove();
  void cat();

  // RpViewModel
  /** get latest entries for the given path */
  void getEntries( const sc::String& path, svn::DirEntries& entries );
  /** get current entries for the given path, use from updateOld signal */
  void getEntriesOld( const sc::String& path, svn::DirEntries& entries );
  const sc::String& getRootPath() const;

  Bookmark* getBookmark();

  const RpSelection& getSelection();

public slots:
  void move( const sc::String& to, bool base );
  void copy( const sc::String& to );
  void setSelection( const RpSelection& sel );

signals:
  void updatedOld( const sc::String&, const svn::DirEntries& entries );
  void updatedNew( const sc::String&, const svn::DirEntries& entries );
  void confirmCopy( CopyParam*, Project*, bool& proceed );
  void confirmCheckout( CheckoutParam*, Project*, bool& proceed );
  void confirmSwitch( SwitchParam*, Project*, bool&  proceed );
  void confirmMove( bool& force, bool& proceed );
  void showDiff( DiffViewModel* );
  void showMerge( MergeViewModel* );
  void confirmMkdir( sc::String& dir, bool& proceed );
  void confirmRemove( bool& proceed );
  void confirmImport( bool& proceed );
  void confirmExport( bool& proceed );

public:
  bool getAutoRefresh();

private:
  Bookmark*            _bookmark;
  ScModel*             _model;

  svn::Revnumber       _rev;
  Entries              _entries;
  Running              _running;

  RpSelection          _selection;
};


#endif // _SC_RPVIEWMODEL_H
