/* ====================================================================
 * Copyright (c) 2003-2008  Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

// sc
#include "config.h"
#include "UpdateDialog.h"
#include "RevisionWidget.h"
#include "ExternProvider.h"
#include "Settings.h"
#include "sublib/Gui.h"
#include "sublib/ExternButton.h"
#include "sublib/settings/LayoutSettings.h"
#include "util/String.h"
#include "util/max.h"

// qt
#include <QtGui/QLayout>
#include <QtGui/QPushButton>
#include <QtGui/QLabel>
#include <QtGui/QComboBox>
#include <QtGui/QFileDialog>
#include <QtGui/QToolTip>
#include <QtGui/QCheckBox>
#include <QtGui/QGroupBox>
#include <QtGui/QDialogButtonBox>


UpdateDialog::UpdateDialog( ExternProvider* p, bool recurse, QWidget *parent )
: super(parent, 0, true/*, Qt::Sheet*/), _p(p)
{
  setName( "UpdateDialog" );
  setCaption( _q("subcommander:update") );

  QVBoxLayout *vbl = new QVBoxLayout(this);
  vbl->setContentsMargins(5,5,5,5);
  vbl->setSpacing(5);
  {
    QGroupBox* gb = new QGroupBox(this);
    gb->setTitle( _q("update options: ") );
    gb->setFlat(true);
    vbl->addWidget(gb);
    {
      QVBoxLayout* gbl = new QVBoxLayout(gb);
      gbl->setContentsMargins(0,10,0,0);
      {
        QLabel* l = new QLabel(this);
        l->setText( _q("&working copy folder/file:") );
        gbl->addWidget(l);
        
        QHBoxLayout* h0 = new QHBoxLayout;
        h0->setContentsMargins(0,0,0,0);
        gbl->addLayout(h0);
        {
          _wc = new QComboBox(this);
          _wc->setAutoCompletion(true);
          _wc->setEditable(true);
          h0->addWidget(_wc);

          _wcEx = new ExternButton(this);
          h0->addWidget(_wcEx);
          l->setBuddy(_wcEx);

          connect( _wc, SIGNAL(activated(const QString&)), SLOT(checkOk(const QString&)) );
          connect( _wc, SIGNAL(highlighted(const QString&)), SLOT(checkOk(const QString&)) );
          connect( _wc, SIGNAL(textChanged(const QString&)), SLOT(checkOk(const QString&)) );
          
          connect( _wcEx, SIGNAL(clicked()), SLOT(selectWcPath()) );
          
          QToolTip::add( _wc, _q("the local working copy folder or file you like to update") );
        }
        
        QHBoxLayout* h1 = new QHBoxLayout;
        h1->setContentsMargins(0,0,0,0);
        gbl->addLayout(h1);
        {
          _rw = new RevisionWidget(false,"SDN","UH",0,this);
          h1->addWidget( _rw );
          
          _recurse = new QCheckBox(_q("&recursive"),this);
          _recurse->setChecked(recurse);
          h1->addWidget( _recurse );
          //h1->setAlignment( _recurse, Qt::AlignTop );

          //h1->addStretch(1);
        }
      }
    }

    QDialogButtonBox* db = new QDialogButtonBox(this);
    db->setContentsMargins(5,5,5,5);
    vbl->addWidget(db);
    {
      int minWidth = 0;
      
      _ok = new QPushButton(this);
      _ok->setEnabled(false);
      _ok->setText( _q("&Ok") );
      _ok->setDefault(true);
      db->addButton( _ok, QDialogButtonBox::AcceptRole );
      minWidth = std::max( minWidth, _ok->sizeHint().width() );
      
      _ca = new QPushButton(this);
      _ca->setText( _q("&Cancel") );
      _ok->setAutoDefault(true);
      db->addButton( _ca, QDialogButtonBox::RejectRole );
      minWidth = std::max( minWidth, _ca->sizeHint().width() );
      
      _ok->setMinimumWidth(minWidth);
      _ca->setMinimumWidth(minWidth);
      
      connect( _ok, SIGNAL(clicked()), SLOT(accept()) );
      connect( _ca, SIGNAL(clicked()), SLOT(reject()) );
    }
  }

  Settings s;
  resize( s.layout().getSize( name(), QSize(350,100) ) );
  setMaximumHeight( sizeHint().height() );
}

UpdateDialog::~UpdateDialog()
{
  Settings s;
  s.layout().setSize( name(), geometry().size() );
}

void UpdateDialog::selectWcPath()
{
  sc::String res;

  if( _p->selectPath( this, sc::String(_wc->currentText().utf8()), res, ExternProvider::Dir ) )
  {
    _wc->insertItem( 0, QString::fromUtf8(res) );
    _wc->setCurrentIndex(0);
  }
}

void UpdateDialog::setWorkingCopyPath( QString& path )
{
  _wc->insertItem( 0, path );
  _wc->setCurrentIndex(0);
}

QString UpdateDialog::getWorkingCopyPath()
{
  return _wc->currentText();
}

svn::Revision* UpdateDialog::getRevision()
{
  return _rw->getRevision();
}

bool UpdateDialog::isRecursive()
{
  return _recurse->isChecked();
}

void UpdateDialog::enableWorkingCopyPath( bool enable )
{
  _wc->setEnabled(enable);
  _wcEx->setEnabled(enable);
}

void UpdateDialog::checkOk( const QString& text )
{
  QString wc  = _wc->currentText();

  if( ! wc.isEmpty()  )
  {
    _ok->setEnabled(true);
  }
  else
  {
    _ok->setEnabled(false);
  }
}
