/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_PROPGETPARAM_H
#define _SC_PROPGETPARAM_H

// sc
#include "ScParam.h"
#include "ScParamVisitor.h"
#include "util/String.h"
#include "svn/Revision.h"
#include "svn/PropGetItemTypes.h"

/**
 * Parameter class for PropGetCmd.
 */
class PropGetParam : public ScParam
{
public:
  PropGetParam( const sc::String& propName, const sc::String& pathOrUrl, const svn::Revision* rev,
    bool recurse ) : _propName(propName), _pathOrUrl(pathOrUrl), _rev(rev), _recurse(recurse)
  {
  }

  ~PropGetParam()
  {
    delete _rev;
  }

  const sc::String& getPropName() const
  {
    return _propName;
  }

  const sc::String& getPathOrUrl() const
  {
    return _pathOrUrl;
  }

  const svn::Revision* getRevision() const
  {
    return _rev;
  }

  bool getRecurse() const
  {
    return _recurse;
  }

  svn::PropGetItems& getItems()
  {
    return _items;
  }

  ScParamAccept(PropGetParam);

private:
  // in
  sc::String           _propName;
  sc::String           _pathOrUrl;
  const svn::Revision* _rev;
  bool                 _recurse;
  
  // out
  svn::PropGetItems    _items;
};

#endif // _SC_PROPGETPARAM_H
