/* ====================================================================
 * Copyright (c) 2003-2007, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

// sc
#include "ExternButton.h"

// qt
#include <QtGui/QApplication>
#include <QtGui/QStyle>

const QString ButtonText("...");

ExternButton::ExternButton( QWidget *parent )
: super( ButtonText, parent )
{
  setAutoDefault(false);

#ifndef Q_WS_MAC
 // On MacOSX the button is automatically sized to a proper width. Setting
 // a width that's too small for the MacStyle button will change the frame
 // to an ugly rectangle frame. So skip this on MacOSX.

  QFontMetrics m(font());
  setFixedWidth( m.width(ButtonText) + 
    2 * style()->pixelMetric(QStyle::PM_ButtonMargin) );
  setFixedHeight( m.height() + 
    style()->pixelMetric(QStyle::PM_ButtonMargin) );
#endif // Q_WS_MAC

  setSizePolicy( QSizePolicy::Fixed, QSizePolicy::Fixed );
}
