# -*- coding: utf-8 -*-

from ui_Calculation_progress import Ui_Calculation_progress
from CpStatusTip import CpStatusTip # classe des messages de la barre de statut du suivis de calcul
from CpToolTip import CpToolTip # classe des infobulles du suivis de calcul
from CpWhatsThis import CpWhatsThis # classe des what's this du suivis de calcul
from syrthesIHMContext import syrthesIHMContext

#-------------------------------------------------------------------------------
# importation des bibliothèques standard
#-------------------------------------------------------------------------------

import os, sys, string, subprocess, shutil, time, datetime, filecmp, threading, re

#-------------------------------------------------------------------------------
# importation des bibliothèques IHM
#-------------------------------------------------------------------------------
from PyQt4 import QtCore, QtGui
from PyQt4.QtCore import *
from PyQt4.QtGui  import *

try:
    if os.name=='nt':
        import numpy, _winreg
    import PyQt4.Qt as Qt
    import PyQt4.Qwt5 as Qwt
except:
    print "ATTENTION PROBLEME A L'IMPORTATION DE PYQWT OU _WINREG"
    

class Tracker(QObject):
    def __init__(self, parent):
        QObject.__init__(self,parent)
        parent.setMouseTracking(True)
        parent.installEventFilter(self)
        pass
    
    def eventFilter(self, _, event):
        if event.type() == QEvent.MouseMove:
            self.emit(SIGNAL("MouseMoveTracked"), event.pos())
        return False
    pass

class calcView(QMainWindow, Ui_Calculation_progress, CpStatusTip, CpToolTip, CpWhatsThis, object): 
# classe du suivis de calcul
    def __init__(self, Home_form_copy, Control_form_copy, Filename_form_copy, Output_2D_form_copy, Output_3D_form_copy, Running_options_form_copy, case_copy, lastDir_copy, runProcess_copy, parent=None): # fonction d'initialisation de la fenêtre de suivis de calcul
        # respecter l'ordre des appels
        QMainWindow.__init__(self)
        Ui_Calculation_progress.__init__(self)
        CpStatusTip.__init__(self)
        CpToolTip.__init__(self)
        CpWhatsThis.__init__(self)
        Ui_Calculation_progress.setupUi(self,self)

        self.Home_form_copy = Home_form_copy
        self.Control_form_copy = Control_form_copy
        self.Filename_form_copy = Filename_form_copy
        self.Output_2D_form_copy = Output_2D_form_copy
        self.Output_3D_form_copy = Output_3D_form_copy
        self.Running_options_form_copy = Running_options_form_copy
        self.case_copy = case_copy
        self.lastDir_copy = lastDir_copy
        self.runProcess_copy = runProcess_copy
        self.nline=0
        self.running=False
        self.step=-1
        self.substep=0
        self.updateCalcView()
        
    def updateCalcView(self):    
        # définir le style de QGroupBox
        path = syrthesIHMContext.getExeAbsDirPath()
        qssname = path + os.sep + "22x22" + os.sep + "stylesheet.qss"
        if os.access(qssname, os.F_OK) :
            qss = open(qssname, "r")
            qstr = ""
            for line in qss.readlines() :
                qstr += line
            self.centralwidget.setStyleSheet(qstr)

        self.dictProbe = {} # empty dictionnary. will be of format { "N": filename, ...}, value = "-1" if probe is not found in any files
        self.listColor = [Qt.Qt.green, Qt.Qt.red, Qt.Qt.blue, Qt.Qt.darkYellow, Qt.Qt.cyan, Qt.Qt.magenta, Qt.Qt.gray, Qt.Qt.darkGreen, Qt.Qt.darkRed, Qt.Qt.darkBlue, Qt.Qt.darkGray, Qt.Qt.darkCyan, Qt.Qt.darkMagenta, Qt.Qt.black, Qt.Qt.yellow]        
        nbcl = len(self.listColor)        
        for cl in range(nbcl) :
            self.listColor.append(self.listColor[cl])
        nbcl = len(self.listColor) 
        for cl in range(nbcl) :
            self.listColor.append(self.listColor[cl])
        nbcl = len(self.listColor) 
        for cl in range(nbcl) :
            self.listColor.append(self.listColor[cl]) 
        self.fn = self.fontInfo().family()
        self.iLastLineListing = -1
        self.tickflag=True
        
        ##########################################################################
        # Combobox - choix de sondes
        # curves - préparer les courbes vides pour chaque sonde
        self.__init_Cb_Tops()
        
        ##########################################################################
        # create Combobox - nature variable (température, pression...)        
        self.Cb_Vars = []
        self.gridLayout_tabs = []
        self.gridLayout_tabs.append(self.gridLayout_tab1)
        self.gridLayout_tabs.append(self.gridLayout_tab2)
        self.gridLayout_tabs.append(self.gridLayout_tab3)
        self.gridLayout_tabs.append(self.gridLayout_tab4)
                
        for i in range(self.tabPlot.count()) :
            self.Cb_Vars.append(QtGui.QComboBox(self.centralwidget))
            sizePolicy = QtGui.QSizePolicy(QtGui.QSizePolicy.Preferred, QtGui.QSizePolicy.Fixed)
            sizePolicy.setHorizontalStretch(0)
            sizePolicy.setVerticalStretch(0)
            sizePolicy.setHeightForWidth(self.Cb_Vars[i].sizePolicy().hasHeightForWidth())
            self.Cb_Vars[i].setSizePolicy(sizePolicy)
            self.Cb_Vars[i].setObjectName("Cb_Var_tab" + str(i+1))
            self.Cb_Vars[i].addItem("Temperature of probe:")
            if self.Home_form_copy.Ho_Hm_ch.isChecked():
                self.Cb_Vars[i].addItem("Vapor pressure of probe:")
                if self.Home_form_copy.Hm_cmb.currentIndex()==1:
                    self.Cb_Vars[i].addItem("Total pressure of probe:")
            if self.nbRefSURF != 0 : self.Cb_Vars[i].addItem("Surface balance:")
            if self.nbRefVOL != 0 : self.Cb_Vars[i].addItem("Volume balance:")
            self.gridLayout_tabs[i].addWidget(self.Cb_Vars[i], 1, 1, 1, 1) # 2e ligne, 2e colonne, 1 span horizontal, 2 span vertical                     
        
        ##########################################################################
        # create Combobox - line style
        self.ne_pas_repondre_style = False
        self.Cb_LineStyles = []
        self.Cb_LineStyles.append(self.cbStyle_tab1)
        self.Cb_LineStyles.append(self.cbStyle_tab2)
        self.Cb_LineStyles.append(self.cbStyle_tab3)
        self.Cb_LineStyles.append(self.cbStyle_tab4)
        
        for i in range(self.tabPlot.count()) :
            # line style
            self.Cb_LineStyles[i].setIconSize(QtCore.QSize(52,12))
            
            # "———————"
            #self.Cb_LineStyles[i].addItem(chr(151) + chr(151) + chr(151) + chr(150) + chr(150))
            iconpath = syrthesIHMContext.getExeAbsDirPath() + os.sep + "22x22" + os.sep + "dash52x12.png"
            icon = QIcon(iconpath)
            self.Cb_LineStyles[i].addItem("")            
            self.Cb_LineStyles[i].setItemIcon(0, icon)
            
            # "— — — — — — —"            
            #self.Cb_LineStyles[i].addItem(chr(150) + ' ' + chr(150) + ' ' + chr(150) + ' ' + chr(150) + ' ' + chr(150))
            iconpath = syrthesIHMContext.getExeAbsDirPath() + os.sep + "22x22" + os.sep + "dashespace52x12.png"
            icon = QIcon(iconpath)
            self.Cb_LineStyles[i].addItem("") 
            self.Cb_LineStyles[i].setItemIcon(1, icon)
            
            # "•••••••••"
            #self.Cb_LineStyles[i].addItem(chr(149) + chr(149) + chr(149) + chr(149) + chr(149) + chr(149) + chr(149) + chr(149) + chr(149) + chr(149))
            iconpath = syrthesIHMContext.getExeAbsDirPath() + os.sep + "22x22" + os.sep + "dot52x12.png"
            icon = QIcon(iconpath)
            self.Cb_LineStyles[i].addItem("") 
            self.Cb_LineStyles[i].setItemIcon(2, icon)
            
            # "— • — • — • —"
            #self.Cb_LineStyles[i].addItem(chr(150) + ' ' + chr(183) + ' ' + chr(150) + ' ' + chr(183) + ' ' + chr(150)) 
            iconpath = syrthesIHMContext.getExeAbsDirPath() + os.sep + "22x22" + os.sep + "dashdot52x12.png"
            icon = QIcon(iconpath)
            self.Cb_LineStyles[i].addItem("") 
            self.Cb_LineStyles[i].setItemIcon(3, icon)
        
        ###########################################################################
        # plot
        self.xposold=None
        self.yposold=None
        self.mark=False
        
        self.plot = Qwt.QwtPlot()
        self.plot.setObjectName("plot") 
        self.verticalLayout.addWidget(self.plot)
        self.plot.setCanvasBackground(Qt.Qt.white)
        self.plot.plotLayout().setCanvasMargin(0)
        self.plot.plotLayout().setAlignCanvasToScales(False) 
        
        # init titre des axes du plot
        text = Qwt.QwtText(u'Temperature (°C)')
        text.setFont(QFont(self.fn, 8, QFont.Normal))
        self.plot.setAxisTitle(Qwt.QwtPlot.yLeft, text)

        btext = Qwt.QwtText('Time (s)')
        btext.setFont(QFont(self.fn, 8, QFont.Normal))
        self.plot.setAxisTitle(Qwt.QwtPlot.xBottom, btext)
        
        # titre du graphique n'est plus nécessaire car on a des légendes
        # init titre du plot - dépendant du 1ère sonde
        #if self.Home_form_copy.Dim_Comb.currentIndex()==0:
        #    table=self.Output_2D_form_copy.Op_Dc_3D_table
        #    x = table.item(0,1).text()
        #    y = table.item(0,2).text()
        #    z = table.item(0,3).text()
        #    ttext = Qwt.QwtText(self.Cb_Vars[0].currentText()+' ['+x+';'+y+';'+z+']')
        #    ttext.setFont(QFont(self.fn, 8, QFont.Normal))
        #    self.plot.setTitle(ttext)
        #else:
        #    table=self.Output_2D_form_copy.Le2_2D_Op
        #    x = table.item(0,1).text()
        #    y = table.item(0,2).text()
        #    ttext = Qwt.QwtText(self.Cb_Vars[0].currentText()+' ['+x+';'+y+']')
        #    ttext.setFont(QFont(self.fn, 8, QFont.Normal))
        #    self.plot.setTitle(ttext)
            
        ###########################################################################
        # grid
        grid = Qwt.QwtPlotGrid()
        pen = Qt.QPen(Qt.Qt.DotLine)
        pen.setColor(Qt.Qt.black)
        pen.setWidth(0)
        grid.setPen(pen)
        grid.attach(self.plot)                  
            
        ###########################################################################
        # check availability of data
            
        self.marker=Qwt.QwtPlotMarker()
        self.marker.setValue(500, 500)
        text=Qwt.QwtText('Awaiting data')
        self.marker.setLabel(text)
        if not os.access(self.case_copy.getHisFullPath(0), os.F_OK): 
            self.marker.attach(self.plot)
            self.mark=True
        
        # enregistrer les coordonnées de la sonde dans l'objet curves[j]                
        # curves - préparer les courbes vides pour chaque sonde
        self.curves = []

        if self.Home_form_copy.Dim_Comb.currentIndex()==0:
            Table = self.Output_3D_form_copy.Op_Dc_3D_table
            TableSURF = self.Output_3D_form_copy.Op_Sb_3D_table
            TableVOL = self.Output_3D_form_copy.Op_Vb_3D_table
        else:
            Table=self.Output_2D_form_copy.Op_Dc_2D_table
            TableSURF = self.Output_2D_form_copy.Op_Sb_2D_table
            TableVOL = self.Output_2D_form_copy.Op_Vb_2D_table
        
        i = 0 # numéro de ligne-1 dans le tableau output
        j = 0 # nombre de courbes existantes
        while i<Table.rowCount():
            if ((Table.cellWidget(i, 0).isChecked()==True) and
                (Table.item(i, 1)!=None and Table.item(i, 2)!=None)): # ligne checké et non vide
                if Table.item(i, 1).text() != "" and Table.item(i,2).text() != "" :
                    legend = "Temp. "
                    if self.Home_form_copy.Dim_Comb.currentIndex()==0: # 3D                        
                        try :
                            legend = legend + Table.item(i,4).text() # par défaut légende = user commentaire du sonde
                        except :
                            pass
                        if legend == "Temp. " : # sinon légende = coordonnées du sonde
                            legend = legend + "["+str(Table.item(i,1).text())+";"+str(Table.item(i,2).text())+";"+str(Table.item(i,3).text())+"]"
                    else:                        
                        try :
                            legend = legend + Table.item(i,3).text()
                        except :
                            pass
                        if legend == "Temp. " :
                            legend = legend + "["+str(Table.item(i,1).text())+";"+str(Table.item(i,2).text())+"]"
                    curve = clCurve(legend)
                    self.curves.append(curve)
                    self.curves[j].setColor(self.listColor[i])
                    self.curves[j].x = Table.item(i,1).text()
                    self.curves[j].y = Table.item(i,2).text()
                    if self.Home_form_copy.Dim_Comb.currentIndex()==0:
                        self.curves[j].z = Table.item(i,3).text()
                        self.curves[j].dimension = 3
                    else:
                        self.curves[j].z = '999'
                        self.curves[j].dimension = 2
                    j=j+1
                    pass # end if
            i=i+1 # end while
            
        # humidité 2D -> créer curves[4] qui reprendre x, y, (z) de curves[0]...
        # humidité 3D -> créer curves[4] et curves[9] qui reprendre x, y, (z) de curves[0]...
        #if self.Home_form_copy.Ho_Hm_ch.isChecked() : # si modèle humidité est activé            
        for i in range(self.nbProbes) :
            lg = ''.join(str(self.curves[i].legend))
            lg = lg.replace("Temp.", "Vap. Pres.")
            curve = clCurve(lg) 
            curve.setColor(self.listColor[i])
            curve.x = self.curves[i].x
            curve.y = self.curves[i].y
            curve.z = self.curves[i].z
            if self.Home_form_copy.Dim_Comb.currentIndex()==0:
                curve.z = self.curves[i].z
                curve.dimension = 3
            else:
                curve.z = '999'
                curve.dimension = 2
            self.curves.append(curve)
            
        for i in range(self.nbProbes) : # modèle 3 équations
            lg = ''.join(str(self.curves[i].legend))
            lg = lg.replace("Temp.", "Total Pres.")
            curve = clCurve(lg)            
            curve.setColor(self.listColor[i])                    
            curve.x = self.curves[i].x
            curve.y = self.curves[i].y
            curve.z = self.curves[i].z
            if self.Home_form_copy.Dim_Comb.currentIndex()==0:
                curve.z = self.curves[i].z
                curve.dimension = 3
            else:
                curve.z = '999'
                curve.dimension = 2
            self.curves.append(curve)

        # curves for surface balance -> ...
        i = 0 # numéro de ligne-1 dans le tableau Surface balance
        j = 3*self.nbProbes # nombre de courbes existantes
        while i<TableSURF.rowCount():
            if (TableSURF.cellWidget(i, 0).isChecked()==True) and (TableSURF.item(i, 1)!=None): # ligne checké et non vide
                if TableSURF.item(i, 1).text() != "" :
                    legend = ""
                    try :
                        legend = TableSURF.item(i,2).text() # par défaut légende = user commentaire du sonde
                    except :
                        pass
                    if legend == "" : # sinon légende = coordonnées du sonde
                        legend = "Surf. balance ref. " + str(TableSURF.item(i, 1).text())
                    
                    curve = clCurve(legend)
                    self.curves.append(curve)
                    self.curves[j].setColor(self.listColor[i])
                    self.curves[j].x = TableSURF.item(i,1).text()
                    self.curves[j].y = '999'
                    self.curves[j].z = '999'
                    j=j+1
                    pass # end if
            i=i+1 # end while
            
        # curves for volume balance -> ...
        i = 0 # numéro de ligne-1 dans le tableau Volume balance
        # j - nombre de courbes existantes
        while i<TableVOL.rowCount():
            if (TableVOL.cellWidget(i, 0).isChecked()==True) and (TableVOL.item(i, 1)!=None): # ligne checké et non vide
                if TableVOL.item(i, 1).text() != "" :
                    legend = ""
                    try :
                        legend = TableVOL.item(i,2).text() # par défaut légende = user commentaire du sonde
                    except :
                        pass
                    if legend == "" : # sinon légende = coordonnées du sonde
                        legend = "Vol. balance ref. " + str(TableVOL.item(i, 1).text())
                    
                    curve = clCurve(legend)
                    self.curves.append(curve)
                    self.curves[j].setColor(self.listColor[i])
                    self.curves[j].x = TableVOL.item(i,1).text()
                    self.curves[j].y = '999'
                    self.curves[j].z = '999'
                    j=j+1
                    pass # end if
            i=i+1 # end while
        #print "nbCurves:", len(self.curves)    
        # définir le choix par défaut du 1er combobox
        if self.nbProbes > 0 :
            self.Cb_Tops[0].setCurrentIndex(0)
            self.curves[0].tabIndexLinked = 0            
             
        ###########################################################################
        # déterminer le nombre de réf bilan surfacique/volumique
        
        ###########################################################################
        # réaffacter tabPlot à la classe fille (clPlotTab) pour plus de fonctionnalité !
        #self.tabPlot = clPlotTab(self.tabPlot)
        #print "tab2 :",self.tabPlot
        #print "tabtab :",self.tabPlot
        self.tabPlot.initView()
        
        ###########################################################################
        # signaux - slot
        self.connect(self.Cb_Top, SIGNAL("currentIndexChanged(int)"), self.Cb_Top_Clb2)
        self.connect(self.Cb_Top2, SIGNAL("currentIndexChanged(int)"), self.Cb_Top_Clb2)
        self.connect(self.Cb_Top3, SIGNAL("currentIndexChanged(int)"), self.Cb_Top_Clb2)
        self.connect(self.Cb_Top4, SIGNAL("currentIndexChanged(int)"), self.Cb_Top_Clb2)
        
        self.connect(self.Cb_Vars[0], SIGNAL("currentIndexChanged(int)"), self.Cb_Var_Clb)
        self.connect(self.Cb_Vars[1], SIGNAL("currentIndexChanged(int)"), self.Cb_Var_Clb)
        self.connect(self.Cb_Vars[2], SIGNAL("currentIndexChanged(int)"), self.Cb_Var_Clb)
        self.connect(self.Cb_Vars[3], SIGNAL("currentIndexChanged(int)"), self.Cb_Var_Clb)
        
        self.connect(self.cbStyle_tab1, SIGNAL("currentIndexChanged(int)"), self.Cb_Style_Clb)
        self.connect(self.cbStyle_tab2, SIGNAL("currentIndexChanged(int)"), self.Cb_Style_Clb)
        self.connect(self.cbStyle_tab3, SIGNAL("currentIndexChanged(int)"), self.Cb_Style_Clb)
        self.connect(self.cbStyle_tab4, SIGNAL("currentIndexChanged(int)"), self.Cb_Style_Clb)
        self.connect(self.Screenshot_pb, SIGNAL("clicked()"), self.Screenshot)
        self.connect(self.btnResetScale, SIGNAL("clicked()"), self.ResetScale) # reset scale in calculation progress
        self.connect(self.tabWidget, SIGNAL("currentChanged(int)"), self.RefreshListing)
        self.connect(Tracker(self.plot.canvas()), SIGNAL("MouseMoveTracked"), self.showCoordinates)
        
        self.widget=[self.progressBar, 
                     self.Cb_Top,
                     self.btnResetScale,
                     self.textBrowser_3, 
                     self.textEdit_2,
                     self.Screenshot_pb,
                     self.plot,
                     self.Cb_Vars[0],
                     self.Cb_Vars[1],
                     self.Cb_Vars[2],
                     self.Cb_Vars[3],
                     self.cbStyle_tab1,
                     self.cbStyle_tab2,
                     self.cbStyle_tab3,
                     self.cbStyle_tab4,
                     self.Cb_Top2,
                     self.Cb_Top3,
                     self.Cb_Top4]
    
        self.CpStatusTip()
        self.CpToolTip()
        self.CpWhatsThis()
      
        ###########################################################################
        # coups d'horloge pour le rafraîchissement de l'IHM du suivis de calcul
        self.timer= QtCore.QTimer()
        ticker=self.timer.singleShot(1000, self.Time_Clb)
      
        ###########################################################################
        # zoom
        self.plot.wheelEvent=self.wheel_event
        self.plot.mouseMoveEvent=self.grab_mouse
        self.plot.mouseReleaseEvent=self.raz_mouses
        self.Mag=Qwt.QwtPlotMagnifier(self.plot.canvas())
        
        self.plot.insertLegend(Qwt.QwtLegend(), Qwt.QwtPlot.BottomLegend)
        
        self.__initZooming()
        
        #panner = Qwt.QwtPlotPanner(self.plot.canvas())
        #panner.setAxisEnabled(Qwt.QwtPlot.)

    def __init_Cb_Tops(self):
        # Combobox - choix de sondes
        self.Cb_Top.setEnabled(True)
        self.Cb_Tops = []
        self.Cb_Tops.append(self.Cb_Top)
        self.Cb_Tops.append(self.Cb_Top2)
        self.Cb_Tops.append(self.Cb_Top3)
        self.Cb_Tops.append(self.Cb_Top4)
        
        if self.Home_form_copy.Dim_Comb.currentIndex()==0:
            Table = self.Output_3D_form_copy.Op_Dc_3D_table
            TableSURF = self.Output_3D_form_copy.Op_Sb_3D_table
            TableVOL = self.Output_3D_form_copy.Op_Vb_3D_table
        else:
            Table=self.Output_2D_form_copy.Op_Dc_2D_table
            TableSURF = self.Output_2D_form_copy.Op_Sb_2D_table
            TableVOL = self.Output_2D_form_copy.Op_Vb_2D_table
        
        # remplir les Cb_Top - bug potentiel : hasn't checked Table.item(i, 4)!=None yet
        # other possible bugs : i, j, ...
        
        pixmap = QPixmap(10,10) # mod GA 2011 (10,10) inside of 30*30
        for Cb_Top in self.Cb_Tops :            
            i = 0 # ligne non vide dans le tableau output
            j = 0 # numéro de courbe dans le combobox - devra-t-il correspondre au numéro de ligne dans le tableau ?
            while i<Table.rowCount():
                if ((Table.cellWidget(i, 0).isChecked()==True) and
                    (Table.item(i, 1)!=None and Table.item(i, 2)!=None)): # ligne checké et non vide
                    if Table.item(i, 1).text() != "" and Table.item(i,2).text() != "" :
                        if Cb_Top.findText(str(i+1))==-1:
                            Cb_Top.insertItem(j, str(i+1))
                            
                            # créer un carré de couleur self.listColor[j]
                            pixmap.fill(QtGui.QColor(self.listColor[i])); 
                            Cb_Top.setItemData(j, QtCore.QVariant(pixmap), Qt.Qt.DecorationRole)
                            
                            pass # end if not yet listed in Cb_top
                        j=j+1                                                       
                i=i+1 # end while
            
            Cb_Top.addItem("None")
            Cb_Top.setCurrentIndex(-1) # combobox vide au départ
            
        # sauvegarder le nombre de sondes pour utiliser plus tard    
        self.nbProbes = self.Cb_Tops[0].count() - 1
          
        # déterminer le nombre de réf Bilan SURF pour utiliser plus tard
        i = 0 # ligne non vide dans le tableau output
        j = 0 # numéro de courbe dans le combobox - devra-t-il correspondre au numéro de ligne dans le tableau ?
        while i<TableSURF.rowCount():
            if TableSURF.cellWidget(i, 0).isChecked() and (TableSURF.item(i, 1)!=None): # ligne checké et non vide
                if TableSURF.item(i, 1).text() != "" :
                    j=j+1                                                       
            i=i+1 # end while
        self.nbRefSURF = j
        
        # déterminer le nombre de réf Bilan VOL pour utiliser plus tard
        i = 0 # ligne non vide dans le tableau output
        j = 0 # numéro de courbe dans le combobox - devra-t-il correspondre au numéro de ligne dans le tableau ?
        while i<TableVOL.rowCount():
            if TableVOL.cellWidget(i, 0).isChecked() and (TableVOL.item(i, 1)!=None): # ligne checké et non vide
                if TableVOL.item(i, 1).text() != "" :
                    j=j+1                                                       
            i=i+1 # end while
        self.nbRefVOL = j
        print j
        
    def __initZooming(self):
#        self.zoomer = Qwt.QwtPlotZoomer(Qwt.QwtPlot.xBottom,
#                                        Qwt.QwtPlot.yLeft,
#                                        Qwt.QwtPicker.DragSelection,
#                                        Qwt.QwtPicker.AlwaysOff,
#                                        self.plot.canvas())
#        self.zoomer.setRubberBandPen(Qt.QPen(Qt.Qt.black))
#        zoomer = Qwt.QwtPlotZoomer(self.plot.canvas())
#        zoomer.setMousePattern(Qwt.QwtEventPattern.MouseSelect2, Qt.Qt.RightButton, Qt.Qt.ControlModifier)
#        zoomer.setMousePattern(Qwt.QwtEventPattern.MouseSelect3, Qt.Qt.RightButton)
#        zoomer.setRubberBandPen(Qt.QPen(Qt.Qt.black))
 
        # zooming
        self.zoomers = []
        zoomer = Qwt.QwtPlotZoomer(Qwt.QwtPlot.xBottom,
                               Qwt.QwtPlot.yLeft,
                               Qwt.QwtPicker.DragSelection,
                               Qwt.QwtPicker.AlwaysOff,
                               self.plot.canvas())
        zoomer.setRubberBandPen(Qt.QPen(Qt.Qt.black))
        self.zoomers.append(zoomer)
        zoomer = Qwt.QwtPlotZoomer(Qwt.QwtPlot.xTop,
                                   Qwt.QwtPlot.yRight,
                                   Qwt.QwtPicker.DragSelection,
                                   Qwt.QwtPicker.AlwaysOff,
                                   self.plot.canvas())
        zoomer.setRubberBand(Qwt.QwtPicker.NoRubberBand)
        self.zoomers.append(zoomer)
        self.setZoomerMouseEventSet(0)

    def setZoomerMouseEventSet(self, index):
        """Attach the Qwt.QwtPlotZoomer actions to a set of mouse events.
        """
        if index == 0:
            pattern = [
                Qwt.QwtEventPattern.MousePattern(Qt.Qt.LeftButton,
                                             Qt.Qt.NoModifier),
                #Qwt.QwtEventPattern.MousePattern(Qt.Qt.MidButton,
                #                             Qt.Qt.NoModifier),
                #Qwt.QwtEventPattern.MousePattern(Qt.Qt.RightButton,
                #                             Qt.Qt.NoModifier),
                Qwt.QwtEventPattern.MousePattern(Qt.Qt.LeftButton,
                                             Qt.Qt.ShiftModifier),
                #Qwt.QwtEventPattern.MousePattern(Qt.Qt.MidButton,
                #                             Qt.Qt.ShiftModifier),
                #Qwt.QwtEventPattern.MousePattern(Qt.Qt.RightButton,
                #                             Qt.Qt.ShiftModifier),
                ]
            for zoomer in self.zoomers:
                zoomer.setMousePattern(pattern)
        elif index in (1, 2, 3):
            for zoomer in self.zoomers:
                zoomer.initMousePattern(index)
        else:
            raise ValueError, 'index must be in (0, 1, 2, 3)'
        #self.__mouseEventSet = index

    def showCoordinates(self, position):
        result=[]
        
        #import pdb
        #pdb.set_trace()
        yAxisTitle = "%s"%(self.plot.axisTitle(Qwt.QwtPlot.yLeft).text().toUtf8())

        yunit='°C'
        ylabel='T'
        xunit="s"
        xlabel='t'

        if yAxisTitle.find("°C") != -1:
            ylabel='T'
            yunit='°C'
        elif yAxisTitle.find("Pa") != -1:
            ylabel='P'
            yunit="Pa"
        elif yAxisTitle.find("W") !=-1:
            ylabel='P'
            yunit="W"

        raw = ( (Qwt.QwtPlot.xBottom, "%s=%.6g %s", (xlabel, position.x(), xunit)), 
                (Qwt.QwtPlot.yLeft, "%s=%.6g %s", (ylabel, position.y(), yunit)) )
        for axis, template, value in raw:
            if self.plot.axisEnabled(axis):
                value = (value[0],self.plot.invTransform(axis, value[1]),value[2])
                result.append(template % value)
        self.plot.setToolTip(QtGui.QApplication.translate("MainWindow", '[ '+result[0] +' , ' +result[1]+' ]', None, QtGui.QApplication.UnicodeUTF8))
        pass
   
    def updateCb_Top(self, tabIndex): # fonction de rappel lorsque le combobox type de variable est changé
        if self.Cb_Vars[tabIndex].currentText() == "Surface balance:" :
            if self.Home_form_copy.Dim_Comb.currentIndex()==0:
                Table = self.Output_3D_form_copy.Op_Sb_3D_table
            else:
                Table = self.Output_2D_form_copy.Op_Sb_2D_table
            
        elif self.Cb_Vars[tabIndex].currentText() == "Volume balance:" :
            if self.Home_form_copy.Dim_Comb.currentIndex()==0:
                Table = self.Output_3D_form_copy.Op_Vb_3D_table
            else:
                Table = self.Output_2D_form_copy.Op_Vb_2D_table
        else:
            if self.Home_form_copy.Dim_Comb.currentIndex()==0:
                Table = self.Output_3D_form_copy.Op_Dc_3D_table
            else:
                Table = self.Output_2D_form_copy.Op_Dc_2D_table
        
        i = 0 # ligne non vide dans le tableau output
        j = 0 # numéro de courbe dans le combobox - devra-t-il correspondre au numéro de ligne dans le tableau ?
        Cb_Top = self.Cb_Tops[tabIndex]
        while Cb_Top.count() > 0 : Cb_Top.removeItem(0) # clear combobox
        pixmap = QPixmap(10,10) # mod GA 2011 (10,10) inside of 30*30
        while i<Table.rowCount():
            if ((Table.cellWidget(i, 0).isChecked()==True) and
                (Table.item(i, 1)!=None)): # ligne checké et non vide
                if Table.item(i,1).text() != "" :
                    if Cb_Top.findText(str(i+1))==-1:
                        Cb_Top.insertItem(j, str(i+1))
                        
                        # créer un carré de couleur self.listColor[j]
                        pixmap.fill(QtGui.QColor(self.listColor[i])); 
                        Cb_Top.setItemData(j, QtCore.QVariant(pixmap), Qt.Qt.DecorationRole)
                        
                        pass # end if not yet listed in Cb_top
                    j=j+1                                                       
            i=i+1 # end while
        Cb_Top.addItem("None")
        Cb_Top.setCurrentIndex(-1) # combobox vide au départ
    
    def Time_Clb(self, parent=None): # Fonction de rappel des coups d'horloge pour le rafraîchissement de l'IHM du suivis de calcul
        self.setCursor(QtCore.Qt.BusyCursor)
        for i in range(4) :
            Cb_Top = self.Cb_Tops[i]
            if Cb_Top.currentText() != '':
                if self.Cb_Vars[i].currentText() == "Surface balance:":
                    self.read_cp_SURF(self.tabPlot.curveIndexLinked[i])
                elif self.Cb_Vars[i].currentText() == "Volume balance:":
                    self.read_cp_VOL(self.tabPlot.curveIndexLinked[i])
                else:
                    self.read_cp_file2(self.tabPlot.curveIndexLinked[i])
            pass
        self.plot.replot()
        self.timer= QtCore.QTimer()
        
        # afficher listing dans les onglets
        listing = self.case_copy.dirPath + os.sep + str(self.Running_options_form_copy.Ro_Ln_le.text())
        #if (not os.access(listing, os.F_OK)) or (not os.access(self.case_copy.getHisFullPath(0), os.F_OK)):
        #if (not os.access(listing, os.F_OK)) and (not os.access(self.case_copy.getHisFullPath(0), os.F_OK)) or (not os.access(listing, os.F_OK)):
        if (not os.access(listing, os.F_OK)):
            #print '1 self.tickflag : ',self.tickflag
            # listing or file .his n'existe pas ou n'est pas créé
            # Mais on ne fait self.tickflag = False qu'après avoir vérifié self.runProcess_copy.poll()
            # pour éviter le cas où ces fichiers sont en train d'être créé
            
            try:                        
                # while the process has not terminated yet -> wait
                if self.runProcess_copy.poll() == None : 
                    ticker=self.timer.singleShot(500, self.Time_Clb)
                    return
                                    
                # if the process has terminated
                if self.runProcess_copy.poll() != None : 
                    self.tickflag = False # stop IHM from iterating   
                    #Main.Syrthes_stopping()
                    print "Syrthes_stopping : process terminated"
                    #self.ResetScale()
                    self.emit(SIGNAL("Syrthes_stopping"))
                    #restore cursor
                    self.unsetCursor()
                # printing Error Message
                self.afficherStdout()
                self.afficherStderr()
                
            except:
                print "Warning : SYRTHES hasn't run yet"
                self.tickflag = False
                #Main.Syrthes_stopping()
                self.emit(SIGNAL("Syrthes_stopping"))
                #restore cursor
                self.unsetCursor()
            
        else:
            #print '2 self.tickflag : ',self.tickflag
            listfile=open(self.case_copy.dirPath + os.sep + str(self.Running_options_form_copy.Ro_Ln_le.text()), "r")
            lines=listfile.readlines()
            length=len(lines)
            textlines=''
            
            self.textBrowser_3.clear()
            #monospace
            myCharFormat = QtGui.QTextCharFormat()    
            myCharFormat.setFontFixedPitch(True)
            self.textBrowser_3.setCurrentCharFormat(myCharFormat)
            
            i=0
            Tstep=-1
            count=length-self.nline
            #step=-1
            #substep=0
            for line in lines:
                #print '****************************************'
                #print line
                #print '****************************************'
                #self.textBrowser_3.insertPlainText(line)
                if i>=len(lines)-200:
                    self.textBrowser_3.insertPlainText(line)
                
                # trouver 'cpu time' --> fin de simulation ou bouton Stop actionné
                if line.find('cpu time=') != -1:
                    print "progress =", int((Tstep/float(self.Control_form_copy.Le_Nts.text()))*100)
                    self.tickflag=False
                    
                    # wait until the process really terminates
                    if self.runProcess_copy != None :
                        if self.runProcess_copy.poll() == None :
                            listfile.close()
                            ticker=self.timer.singleShot(500, self.Time_Clb)                        
                            return
                        
                        # print SYRTHES message
                        """self.textBrowser_4.clear()                    
                        myCharFormat = QtGui.QTextCharFormat()    
                        myCharFormat.setFontFixedPitch(True) #monospace
                        self.textBrowser_4.setCurrentCharFormat(myCharFormat) """
                        namefout = self.case_copy.dirPath + os.sep + "stdout.txt"
                        if os.access(namefout, os.F_OK) :
                            fout = open(namefout, "r+")
                            foutlines = fout.readlines()
                            for sline in foutlines :
                                if '\n' in sline :
                                    print sline.split('\n')[0] # \n has not to be printed
                                else:
                                    print sline
                                """self.textBrowser_4.insertPlainText(unicode(sline,"utf-8"))"""
                            if os.access(namefout, os.F_OK) :
                                fout.close()
                        #Main.Syrthes_stopping()
                        print "Syrthes_stopping : syrthes message"
                        #self.ResetScale()
                        self.emit(SIGNAL("Syrthes_stopping"))
                        #restore cursor
                        self.unsetCursor()
                if line.find('NTSYR=') != -1:
                    Tstep=line.split()
                    Tstep=float(Tstep[2])

                if i >= self.nline and not self.running :
                    if line.find("PRE-PROCESSOR  FOR  PARALLEL  COMPUTATION") != -1 or line.find("PRE-PROCESSEUR  POUR  TRAITEMENT  PARALLELE") != -1:
                        self.substep = 0
                        self.groupBox.setTitle(QtGui.QApplication.translate("Calculation_progress", "Pre processing", None, QtGui.QApplication.UnicodeUTF8))
                        self.step = 9
                        pass
                    if line.find(" CONDUCTION INITIALIZATIONS") != -1 or line.find(" INITIALISATIONS POUR LA CONDUCTION") != -1:
                        self.substep = 0
                        self.groupBox.setTitle(QtGui.QApplication.translate("Calculation_progress", "Conduction initialization", None, QtGui.QApplication.UnicodeUTF8))
                        self.step = 14
                        pass
                    if line.find("END OF PRE-PROCESSOR FOR PARALLEL COMPUTATION") != -1 or line.find("FIN NORMALE DU PRE-PROCESSING PARALLELE") != -1:
                        pass
                    if line.find(" RADIATION INITIALIZATIONS") != -1 or line.find("INITIALISATIONS POUR LE RAYONNEMENT") != -1:
                        self.substep = 0
                        self.groupBox.setTitle(QtGui.QApplication.translate("Calculation_progress", "Radiation initialization", None, QtGui.QApplication.UnicodeUTF8))
                        self.step = 13
                        pass
                    if line.find(" END OF INITIALIZATION PHASE") != -1 or line.find(" FIN DE LA PHASE D'INITIALISATION") != -1:
                        self.running = True
                        pass
                    if line.find(" *** ") != -1:
                        self.substep=self.substep+1
                        progress=int(100*self.substep/self.step)
                        self.progressBar.setValue(progress)
                        pass
                    pass

                i=i+1
            if Tstep>0:
                self.groupBox.setTitle(QtGui.QApplication.translate("Calculation_progress", "Progress of Syrthes run", None, QtGui.QApplication.UnicodeUTF8))
                Gtsn=float(self.Control_form_copy.Le_Nts.text())
                if self.Control_form_copy.Ch_res_cal.isChecked()==True:
# isa                    resfile=open(self.case_copy.dirPath + os.sep + self.Filename_form_copy.Fn_Rs_lne.text()+'.res', "r")
                    resfile=open(self.case_copy.dirPath + os.sep + self.Filename_form_copy.Fn_Rs_lne.text(), "r")
                    #print '!!!!!!!!!!!!!',resfile
                    reslines=resfile.readlines()
                    Nrt=reslines[3].split()
                    Nrt=int(Nrt[1])
                    progress=int(((Tstep-Nrt)/(Gtsn-Nrt))*100)
                    resfile.close()
                else:
                    progress=int((Tstep/Gtsn)*100)
                self.progressBar.setValue(progress)
                                
                if progress == 100 :
                    # supprimer syrthes.run 
                    #Main.Syrthes_stopping()
                    print "Syrthes_completed"
                    #self.ResetScale()
                    self.emit(SIGNAL("Syrthes_completed"))
                    #self.emit(SIGNAL("Syrthes_stopping"))
                    #restore cursor
                    self.unsetCursor()
            self.nline = length
            self.textBrowser_3.moveCursor(QtGui.QTextCursor.Down, QtGui.QTextCursor.MoveAnchor)
            listfile.close()
            
        if self.tickflag==True:
            ticker=self.timer.singleShot(1000, self.Time_Clb)
            
    def afficherStderr(self):
        nameferr = self.case_copy.dirPath + os.sep + "stderr.txt"
        #self.textBrowser_4.clear()                
        myCharFormat = QtGui.QTextCharFormat()    
        myCharFormat.setFontFixedPitch(True) #monospace
        self.textBrowser_4.setCurrentCharFormat(myCharFormat)
        if os.access(nameferr, os.F_OK) :
            ferr = open(nameferr, "r+")
            ferrlines = ferr.readlines()
            errorflag = False
            for sline in ferrlines :
                if '\n' in sline :
                    print sline.split('\n')[0] # \n has not to be printed
                else:
                    print sline
                self.textBrowser_4.insertPlainText(unicode(sline,"utf-8"))
                if ("Stop Syrthes execution" in sline) or ("Traceback" in sline) :                            
                    errorflag = True

            if errorflag :
                #QMessageBox.information(self, 'Error', "Physical error or Unrecognized advanced keywords", QMessageBox.Ok)                                                        
                self.tabWidget.insertTab(2, self.tab_log, "Log")
                self.tabWidget.setCurrentIndex(2)
                #self.textBrowser_4.setFocus()
 
            if os.access(nameferr, os.F_OK) :
                ferr.close()
        pass
    
    def afficherStdout(self):
        namefout = self.case_copy.dirPath + os.sep + "stdout.txt"
        self.textBrowser_4.clear()                
        myCharFormat = QtGui.QTextCharFormat()    
        myCharFormat.setFontFixedPitch(True) #monospace
        self.textBrowser_4.setCurrentCharFormat(myCharFormat)
        if os.access(namefout, os.F_OK) :
            fout = open(namefout, "r+")
            foutlines = fout.readlines()
            for sline in foutlines :
                if '\n' in sline :
                    print sline.split('\n')[0] # \n has not to be printed
                else:
                    print sline
                self.textBrowser_4.insertPlainText(unicode(sline,"utf-8"))
            if os.access(namefout, os.F_OK) :
                fout.close()
        pass    
        
    def read_cp_file2(self, curve_index): # fonction de lecture des fichiers de sortis pour le suivis de calcul
        # en mode Run, cette fonction sera appelée environ tous les 1000 milisecondes
        # chercher le fichier contenant la sonde en question
        if curve_index == -1 : return
        probe_index = self.Cb_Tops[self.curves[curve_index].tabIndexLinked].currentIndex()
        self.DefDictProbe()
        if self.Cb_Top.currentText()!='': 
            hisname = self.dictProbe[str(probe_index)]
        else:
            hisname = self.dictProbe['0'] # situate at the first probe if 1st time
      
        if os.access(hisname, os.F_OK):
            cp_file=open(hisname, "r")
            if self.Cb_Top.currentText()!='':
                # récupérer les coordonnées de la sonde en question
                if self.Home_form_copy.Dim_Comb.currentIndex()==0:
                    table=self.Output_3D_form_copy.Op_Dc_3D_table
                    x=float(table.item(probe_index,1).text())
                    y=float(table.item(probe_index,2).text())
                    z=float(table.item(probe_index,3).text())
                else:
                    table=self.Output_2D_form_copy.Op_Dc_2D_table
                    x=float(table.item(probe_index,1).text())
                    y=float(table.item(probe_index,2).text())
                
                # définir la colonne contenant la coordonnée x (ix)
                ix = 2
                if self.Home_form_copy.Ho_Hm_ch.isChecked() : # si modèle humidité est activé
                    if self.Home_form_copy.Hm_cmb.currentIndex() == 0 : # modèle 2 équations
                        ix = 3
                    else : # modèle 3 équations
                        ix = 4
                
                # charger les vecteurs Time_i et Temper_i
                Time_i = []
                Temper_i = []   
                vP_i = []
                taP_i = []            
                for line in cp_file:
                    line=line.split()
                    if self.Home_form_copy.Dim_Comb.currentIndex()==0:                        
                        if not(float(line[ix])==x and float(line[ix+1])==y and float(line[ix+2])==z):
                            continue
                    else:
                        if not(float(line[ix])==x and float(line[ix+1])==y):
                            continue                
                    Time_i.append(float(line[0]))
                    Temper_i.append(float(line[1]))
                    if ix > 2 : # si modèle 2 ou 3 équations
                        vP_i.append(float(line[2]))
                    if ix == 4 : # si modèle 3 équations
                        taP_i.append(float(line[3]))    
                
                # pression vapeur --> courbe i+4
                # pression totale --> courbe i+8
                tabIndexLink = self.curves[curve_index].tabIndexLinked
                currentVarText = self.Cb_Vars[tabIndexLink].currentText()
                            
                # mettre à jour la courbe correspondant à la sonde en question
                if Time_i != [] :
                    self.curves[curve_index].Time = Time_i
                    self.curves[curve_index].Temper = Temper_i
                    self.curves[curve_index].vP = vP_i
                    self.curves[curve_index].taP = taP_i                
                    if currentVarText == "Vapor pressure of probe:" : # modèle 2 équations
                        self.curves[curve_index].refreshVaporP()
                    elif currentVarText == "Total pressure of probe:" : # modèle 3 équations
                        self.curves[curve_index].refreshTotalAirP()
                    else :
                        self.curves[curve_index].refreshTemp()
                    self.curves[curve_index].setStyle(self.Cb_LineStyles[tabIndexLink].currentIndex()+1)
                    self.curves[curve_index].attach(self.plot) 
                    if self.mark==True:
                        self.marker.detach()
                        self.mark=False
                else:
                    # mis à jour les liens entre les onglets et les courbes     
                    # désaffecter cet onglet (tabIndexLinked) de cette courbe vide    
                    # contrôler si cette courbe courbe appartient à un autre onglet (variable "ailleur") 
                    ailleur = -1
                    for ti in range(self.tabPlot.nbActif) :
                        if ti != currentTabIndex and self.tabPlot.curveIndexLinked[ti] == curve_index :
                            ailleur = ti
                            break
                    self.curves[curve_index].tabIndexLinked = ailleur           
                    self.tabPlot.curveIndexLinked[currentTabIndex] = -1                    
                    self.curves[curve_index].razData()
                    self.curves[curve_index].detach()
                    # s'il n'y a plus de courbes, il faudra mettre "Awaiting data" au milieu
            cp_file.close()
    
    def read_cp_SURF(self, curve_index):
        fluname = self.case_copy.fluname
        
        if os.access(fluname, os.F_OK) :
            cp_file=open(fluname, "r+")
            currentTabIndex = self.tabPlot.currentIndex()
                    
            Time_i = []
            Temper_i = []
            i = 0
            for line in cp_file:
                i+=1
                line=line.split()
                if len(line)<8 :
                    #print "len:",i,len(line)
                    break
                elif line[0].strip() == "SURF" and line[4].strip() == str(curve_index +1 - 3*self.nbProbes) :
                    Time_i.append(float(line[2]))
                    if len(line)<10 :
                        Temper_i.append(float(line[7]))
                    elif len(line)<12 :
                        Temper_i.append(float(line[7])+float(line[9]))
                    else :                        
                        Temper_i.append(float(line[7])+float(line[9])+float(line[11]))
                                    
            # mettre à jour la courbe correspondant à la sonde en question
            if Time_i != [] :
                self.curves[curve_index].Time = Time_i
                self.curves[curve_index].Temper = Temper_i
                
                self.curves[curve_index].refreshTemp()
                self.curves[curve_index].setStyle(self.Cb_LineStyles[currentTabIndex].currentIndex()+1)
                self.curves[curve_index].attach(self.plot)
                if self.mark==True:
                    self.marker.detach()
                    self.mark=False
            else:
                # mis à jour les liens entre les onglets et les courbes     
                # désaffecter cet onglet (tabIndexLinked) de cette courbe vide    
                # contrôler si cette courbe courbe appartient à un autre onglet (variable "ailleur") 
                ailleur = -1
                for ti in range(self.tabPlot.nbActif) :
                    if ti != currentTabIndex and self.tabPlot.curveIndexLinked[ti] == curve_index :
                        ailleur = ti
                        break
                self.curves[curve_index].tabIndexLinked = ailleur           
                self.tabPlot.curveIndexLinked[currentTabIndex] = -1
                self.curves[curve_index].razData()
                self.curves[curve_index].detach()
                # s'il n'y a plus de courbes, il faudra mettre "Awaiting data" au milieu
            cp_file.close()
        
    def read_cp_VOL(self, curve_index):
        fluname = self.case_copy.fluname
        
        if os.access(fluname, os.F_OK) :
            cp_file=open(fluname, "r+")
            currentTabIndex = self.tabPlot.currentIndex()
                    
            Time_i = []
            Temper_i = []
            i = 0
            for line in cp_file:
                i+=1 
                line=line.split()
                if len(line)<8 :
                    #print "lenVOL:",i,len(line)
                    break
                elif line[0].strip() == "VOL" and line[4].strip() == str(curve_index +1 - 3*self.nbProbes - self.nbRefSURF) :
                    Time_i.append(float(line[2]))   
                    if len(line)<10 :                        
                        Temper_i.append(float(line[7]))
                    elif len(line)<12 :                        
                        Temper_i.append(float(line[7])+float(line[9]))
                    else :                        
                        Temper_i.append(float(line[7])+float(line[9])+float(line[11]))
                        
            # mettre à jour la courbe correspondant à la sonde en question
            if Time_i != [] :
                self.curves[curve_index].Time = Time_i
                self.curves[curve_index].Temper = Temper_i
                self.curves[curve_index].refreshTemp()
                self.curves[curve_index].setStyle(self.Cb_LineStyles[currentTabIndex].currentIndex()+1)
                self.curves[curve_index].attach(self.plot)
                if self.mark==True:
                    self.marker.detach()
                    self.mark=False
            else:
                # mis à jour les liens entre les onglets et les courbes     
                # désaffecter cet onglet (tabIndexLinked) de cette courbe vide    
                # contrôler si cette courbe courbe appartient à un autre onglet (variable "ailleur") 
                ailleur = -1
                for ti in range(self.tabPlot.nbActif) :
                    if ti != currentTabIndex and self.tabPlot.curveIndexLinked[ti] == curve_index :
                        ailleur = ti
                        break
                self.curves[curve_index].tabIndexLinked = ailleur           
                self.tabPlot.curveIndexLinked[currentTabIndex] = -1                
                self.curves[curve_index].razData()
                self.curves[curve_index].detach()
                # s'il n'y a plus de courbes, il faudra mettre "Awaiting data" au milieu
            cp_file.close()
    
    def DefDictProbe(self, parent=None):
        """ 
        Procedure defining the couples probe number <-> file name
        Will be called in self.Cb_Top_Clb, i.e. each time users change the probe
        """
    
        # définir la colonne contenant la coordonnée x (ix)
        ix = 2
        if self.Home_form_copy.Ho_Hm_ch.isChecked() : # si modèle humidité est activé
            if self.Home_form_copy.Hm_cmb.currentIndex() == 0 : # modèle 2 équations
                ix = 3
            else : # modèle 3 équations
                ix = 4

        for probei in range(self.nbProbes): # loop for probes
            # search for coordinates of this probe
            if self.Home_form_copy.Dim_Comb.currentIndex()==0:
                table=self.Output_3D_form_copy.Op_Dc_3D_table
                x=float(table.item(probei,1).text())
                y=float(table.item(probei,2).text())
                z=float(table.item(probei,3).text())
            else:
                table=self.Output_2D_form_copy.Op_Dc_2D_table
                x=float(table.item(probei,1).text())
                y=float(table.item(probei,2).text())
            
            if self.case_copy.getNbProc() > 1: 
                # parcourir tous les fichiers .his (autant nombreux que les proc)
                found = False # by default, probe is not found
                for filei in range(self.case_copy.getNbProc()): 
                    if os.access(self.case_copy.getHisFullPath(filei), os.F_OK): # .../PART/prefix_part0000n.his
                        cp_file=open(self.case_copy.getHisFullPath(filei), "r")
                        l1=''
                        # looking in all lines in the current file .his
                        lineNo = 0 # line number in file .his
                        for line in cp_file.readlines(): 
                            lineNo += 1
                            if lineNo > self.nbProbes : 
                                break # we don't have to read all lines in a file but the same line as the number of probes
                            if l1 == '' :
                                l1 = line.split() # save the first line to l1 (l + one)
                            
                            l = line.split() # 1st, 2nd line and so on
                            if l[0] != l1[0] : # stop because we only want to look at the first time step 
                                break               
            
                            # looking for probe
                            if self.Home_form_copy.Dim_Comb.currentIndex()==0: # 3D
                                if float(l[ix])==x and float(l[ix+1])==y and float(l[ix+2])==z: # probe 3D found
                                    self.dictProbe[str(probei)] = self.case_copy.getHisFullPath(filei)
                                    found = True
                                    break # break loop of lines because the probe has been found
                            else: # 2D
                                if float(l[ix])==x and float(l[ix+1])==y: # probe 2D found
                                    self.dictProbe[str(probei)] = self.case_copy.getHisFullPath(filei)
                                    found = True
                                    break # break loop of lines because the probe has been found
                            pass # pass looking in all lines in the current file
    
                        cp_file.close() # close current file to go to next file
                        if found == True:
                            break # break loop of files .his because the probe has been found
            else: # nbProc = 1
                found = False
                if os.access(self.case_copy.getHisFullPath(0), os.F_OK):
                    cp_file=open(self.case_copy.getHisFullPath(0), "r")
                    l1=''
                    # looking in all lines in the current file .his
                    for line in cp_file.readlines(): 
                        if l1 == '' :
                            l1 = line.split() # save the first line to l1 (l + one)
                        
                        l = line.split() # 1st, 2nd line and so on
                        if l[0] != l1[0] : # stop because we only want to look at the first time step 
                            break               
        
                        # looking for probe
                        if self.Home_form_copy.Dim_Comb.currentIndex()==0: # 3D
                            if float(l[ix])==x and float(l[ix+1])==y and float(l[ix+2])==z: # probe 3D found
                                self.dictProbe[str(probei)] = self.case_copy.getHisFullPath(0)
                                found = True
                                break
                        else: # 2D
                            if float(l[ix])==x and float(l[ix+1])==y: # probe 2D found
                                self.dictProbe[str(probei)] = self.case_copy.getHisFullPath(0)
                                found = True
                                break
                        pass # pass looking in all lines in the current file
                    cp_file.close()  
            if found != True: # alert users that the probe doesn't exist
                #QMessageBox.question(self, 'Message',
                #                     "Probe not found. Please try another probe.", QMessageBox.Ok)
                self.dictProbe[str(probei)] = "-1"               
            pass # loop for cbTop (probes)
        self.dictProbe[str(self.nbProbes)] = "-2"
        
    def Cb_Top_Clb2(self): # fonction de rappel permettant le changement de la sonde à afficher dans le graphique
    # 2 tableaux sont importants ici :
    # appartenance d'une courbe à un ou plusieurs onglets self.tabPlot.curveIndexLinked[index_onglet] = index_courbe
    # appartenance d'un onglet à une courbe self.curves[index_curve].tabIndexLinked = index_onglet
        Cb_Top = QApplication.focusWidget()
        
        if not (Cb_Top in self.Cb_Tops) :
            # not a combobox
            return
        if Cb_Top.currentIndex() == -1 :
            return
                
        # raccourcis :
        oldCurveIndex = self.tabPlot.curveIndexLinked[self.tabPlot.currentIndex()]
        curve_index_base = Cb_Top.currentIndex()
        currentTabIndex = self.tabPlot.currentIndex()
        # ex. 4 sondes --> pression vapeur --> courbe i+4
        # ex. 4 sondes --> pression totale --> courbe i+8        
        # ex. 4 sondes --> surface balance --> courbe i+12
        # ex. 4 sondes + 2 ref surfaces balance --> volume balance --> courbe i + 14
        newCurveIndex = curve_index_base

        currentVarIndex = self.Cb_Vars[currentTabIndex].currentIndex()
        currentVarText = self.Cb_Vars[currentTabIndex].currentText()                 
        if currentVarText == "Vapor pressure of probe:" : # pression vapeur
            newCurveIndex = curve_index_base + self.nbProbes
        elif currentVarText == "Total pressure of probe:" : # pression totale
            newCurveIndex = curve_index_base + 2*self.nbProbes
        elif currentVarText == "Surface balance:" : # pression totale
            newCurveIndex = curve_index_base + 3*self.nbProbes  
        elif currentVarText == "Volume balance:" : # pression totale
            newCurveIndex = curve_index_base + 3*self.nbProbes + self.nbRefSURF
        
        # ne plus souhaitable :
        # sortir si la courbe choisie appatient à un autre onglet
        #if self.curves[newCurveIndex].tabIndexLinked != -1 :
        #    self.Cb_Tops[currentTabIndex].setCurrentIndex(oldCurveIndex)
        #    return
    
        # mis à jour les liens entre les onglets et les courbes                
        #print "len curves", len(self.curves)
        if Cb_Top.currentText() != "None" :
            self.curves[newCurveIndex].tabIndexLinked = currentTabIndex
            self.tabPlot.curveIndexLinked[currentTabIndex] = newCurveIndex

        # désaffecter cet onglet (tabIndexLinked) à l'ancienne courbe
        # et détacher l'ancienne courbe        
        # précédent contrôle ne plus applicable -> contrôler si l'ancienne courbe (old curve)...
        # ...appartient à un autre onglet (variable "ailleur") 
        ailleur = -1
        for ti in range(self.tabPlot.nbActif) :
            if ti != currentTabIndex and self.tabPlot.curveIndexLinked[ti] == oldCurveIndex :
                ailleur = ti
                break
        if ailleur == -1 : # l'ancienne courbe n'a pas de duplicata -> détacher
            if oldCurveIndex != -1 :
                self.curves[oldCurveIndex].tabIndexLinked = -1
                self.curves[oldCurveIndex].detach()
        else :
            self.curves[oldCurveIndex].tabIndexLinked = ailleur

        # contrôler si la nouvelle courbe appartient à un autre onglet (variable "ailleur")
        # pour homogénéiser son style
        if Cb_Top.currentText() != "None" :
            ailleur = -1
            for ti in range(self.tabPlot.nbActif) :
                if ti != currentTabIndex and self.tabPlot.curveIndexLinked[ti] == newCurveIndex :
                    ailleur = ti
                    # changer le style de ce duplicata
                    self.ne_pas_repondre_style = True
                    self.Cb_LineStyles[ti].setCurrentIndex(self.Cb_LineStyles[currentTabIndex].currentIndex())
            
            self.ne_pas_repondre_style = False

#        print "----------après-----------"
#        for i in range(len(self.curves)):
#            print "courbe", i+1, "appartenant à l'onglet n°", self.curves[i].tabIndexLinked+1
#        for i in range(len(self.tabPlot.tabs)):
#            print "tab n°", i+1, "contient la courbe n°", self.tabPlot.curveIndexLinked[i]+1        
#        print "--------------------------"
                                
        if Cb_Top.currentText()=="None": # probe "None" :
            self.tabPlot.curveIndexLinked[currentTabIndex] = -1
            self.plot.setAxisAutoScale(Qwt.QwtPlot.yLeft)
            self.plot.setAxisAutoScale(Qwt.QwtPlot.xBottom)
        elif currentVarText != "Surface balance:" and currentVarText != "Volume balance:" :
            # on travaille sur les sondes
            self.DefDictProbe()

            # check availability of data

            if self.dictProbe[str(Cb_Top.currentIndex())] == "-1" : # probe is not found                
                if not os.access(self.case_copy.getHisFullPath(0), os.F_OK): 
                    QMessageBox.information(self, 'Message', "Result files not found.", QMessageBox.Ok)
                else:
                    QMessageBox.information(self, 'Message', "Probe not found. Please try another probe.", QMessageBox.Ok)
                Cb_Top.setCurrentIndex(Cb_Top.count()-1)
                self.tabPlot.curveIndexLinked[currentTabIndex] = -1
                            
                self.plot.setAxisAutoScale(Qwt.QwtPlot.yLeft)
                self.plot.setAxisAutoScale(Qwt.QwtPlot.xBottom)    
                #self.Time=[]
                #self.Temper=[]
                #self.curve.setData(self.Time, self.Temper)
            else: # probe found
                # contrôle ne plus souhaitable :
                # détacher une courbe si tabIndexLinked = ce tab
                #for i in range(len(self.curves)):
                #    if self.curves[i].tabIndexLinked == self.tabPlot.currentIndex() :
                #        self.curves[i].detach()
                self.read_cp_file2(self.tabPlot.curveIndexLinked[currentTabIndex])
                self.plot.setAxisAutoScale(Qwt.QwtPlot.yLeft)
                self.plot.setAxisAutoScale(Qwt.QwtPlot.xBottom)
        else:
            # à contrôler l'accès 
            if self.Cb_Vars[currentTabIndex].currentText() == "Surface balance:":
                self.read_cp_SURF(self.tabPlot.curveIndexLinked[currentTabIndex])
            elif self.Cb_Vars[currentTabIndex].currentText() == "Volume balance:":
                self.read_cp_VOL(self.tabPlot.curveIndexLinked[currentTabIndex])
            self.plot.setAxisAutoScale(Qwt.QwtPlot.yLeft)
            self.plot.setAxisAutoScale(Qwt.QwtPlot.xBottom)
                
        self.updateTitle()
        
        if self.tabPlot.boolAwaitingData() : # s'il n'y a aucune graphique à tracer
            self.marker.attach(self.plot)
            self.mark=True  
              
            self.plot.setAxisScale(Qwt.QwtPlot.yLeft, 0, 1000)
            self.plot.setAxisScale(Qwt.QwtPlot.xBottom, 0, 1000)
        else:
            try :
                self.marker.detach()
                self.mark=False
            except :
                pass
        # en option : even if Probe not found, but we still display the coordinates so that users can check whether they are correct       
        #if self.tabPlot.nbActif == 1 :
        #    if self.Home_form_copy.Dim_Comb.currentIndex()==0:
        #        table=self.Output_2D_form_copy.Op_Dc_3D_table
        #        x=table.item(int(Cb_Top.currentText())-1,1).text()
        #        y=table.item(int(Cb_Top.currentText())-1,2).text()
        #        z=table.item(int(Cb_Top.currentText())-1,3).text()
        #        ttext = Qwt.QwtText(self.Cb_Vars[0].currentText()+' ['+x+';'+y+';'+z+']')
        #        ttext.setFont(QFont(self.fn, 8, QFont.Normal))
        #        self.plot.setTitle(ttext)
        #    else:
        #        table=self.Output_2D_form_copy.Le2_2D_Op
        #        x=table.item(int(Cb_Top.currentText())-1,1).text()
        #        y=table.item(int(Cb_Top.currentText())-1,2).text()
        #        ttext = Qwt.QwtText(self.Cb_Vars[0].currentText()+' ['+x+';'+y+']')
        #        ttext.setFont(QFont(self.fn, 8, QFont.Normal))
        #        self.plot.setTitle(ttext)      
        #else :
        #    self.plot.setTitle('')
        
        ###self.zoomer = Qwt.QwtPlotZoomer(Qwt.QwtPlot.xBottom,
        ###                                Qwt.QwtPlot.yLeft,
        ###                                Qwt.QwtPicker.DragSelection,
        ###                                Qwt.QwtPicker.AlwaysOff,
        ###                                self.plot.canvas())
        ###self.zoomer.setRubberBandPen(Qt.QPen(Qt.Qt.black))
                
        self.plot.replot()
        pass
    
    def Cb_Var_Clb(self): # fonction de rappel permettant le changement du type de variable à afficher dans le graphique
        Cb_Var = QApplication.focusWidget()
        
        if not (Cb_Var in self.Cb_Vars) :
            # not a combobox de type de variable
            return        
        
        if Cb_Var.currentIndex() == -1 :
            return
               
        currentTabIndex = self.tabPlot.currentIndex()
        oldCurveIndex = self.tabPlot.curveIndexLinked[self.tabPlot.currentIndex()]
        self.tabPlot.curveIndexLinked[currentTabIndex] = -1 # l'onglet n'est plus lié à aucune courbe
        self.updateCb_Top(currentTabIndex)
        if oldCurveIndex == -1 : 
            self.plot.replot()
            return      

        # désaffecter cet onglet (tabIndexLinked) à l'ancienne courbe
        # et détacher l'ancienne courbe        
        # précédent contrôle ne plus applicable -> contrôler si l'ancienne courbe (old curve)...
        # ...appartient à un autre onglet (variable "ailleur") 
        ailleur = -1
        for ti in range(self.tabPlot.nbActif) :
            if ti != currentTabIndex and self.tabPlot.curveIndexLinked[ti] == oldCurveIndex :
                ailleur = ti
                break
        if ailleur == -1 : # l'ancienne courbe n'a pas de duplicata -> détacher
            self.curves[oldCurveIndex].tabIndexLinked = -1
            self.curves[oldCurveIndex].detach()
        else :
            self.curves[oldCurveIndex].tabIndexLinked = ailleur
        
        self.updateTitle()
                
        if self.tabPlot.boolAwaitingData() : # s'il n'y a aucune graphique à tracer
            self.marker.attach(self.plot)
            self.mark=True  
              
            self.plot.setAxisScale(Qwt.QwtPlot.yLeft, 0, 1000)
            self.plot.setAxisScale(Qwt.QwtPlot.xBottom, 0, 1000)
        else :
            try :
                self.marker.detach()
                self.mark=False
            except :
                pass
            self.plot.setAxisAutoScale(Qwt.QwtPlot.yLeft)
            self.plot.setAxisAutoScale(Qwt.QwtPlot.xBottom)
        
        self.plot.replot()
        pass
    
    def Cb_Style_Clb(self):
        if self.ne_pas_repondre_style == True :
            return
        
        Cb_Style = QApplication.focusWidget()
        
        if not (Cb_Style in self.Cb_LineStyles) :
            # not a combobox linestyle
            return
        
        # raccourcis        
        currentTabIndex = self.tabPlot.currentIndex()
        currentCurveIndex = self.tabPlot.curveIndexLinked[currentTabIndex]
        
        # set style
        # index 0 -> style 0+1 -> Qt.Qt.SolidLine 
        # index 1 -> style 1+1 -> Qt.Qt.DashLine
        # index 2 -> style 2+1 -> Qt.Qt.DotLine
        # index 3 -> style 3+1 -> Qt.Qt.DastDotLine
        self.curves[currentCurveIndex].setStyle(Cb_Style.currentIndex()+1)
        
        
        # contrôler si la courbe...
        # ...appartient à un autre onglet (variable "ailleur") 
        ailleur = -1
        for ti in range(self.tabPlot.nbActif) :
            if ti != currentTabIndex and self.tabPlot.curveIndexLinked[ti] == currentCurveIndex :
                ailleur = ti
                # changer le style de ce duplicata
                self.ne_pas_repondre_style = True
                self.Cb_LineStyles[ti].setCurrentIndex(Cb_Style.currentIndex())
        
        self.ne_pas_repondre_style = False
        self.plot.replot()

    def updateTitle(self):       
        code = '' 
        for ti in range(self.tabPlot.nbActif) :
            if self.Cb_Tops[ti].currentText() != '' and self.Cb_Tops[ti].currentText() != 'None' :
                code = code + str(self.Cb_Vars[ti].currentText())
        
        title = ''
        if string.find(code, 'Temperature of probe') != -1 :
            title = title + u"Temp.(°C) ; "
        if string.find(code, 'Vapor pressure of probe') != -1 :
            title = title + "Vap. P.(Pa) ; "
        if string.find(code, 'Total pressure of probe') != -1 :
            title = title + "Tot. P.(Pa) ; "
        if string.find(code, 'Surface balance') != -1 :
            title = title + "Surf. bal.(W) ; "
        if string.find(code, 'Volume balance') != -1 :
            title = title + "Vol. bal.(W)"
        # modifier le titre des axes du plot
        text = Qwt.QwtText(title)
        text.setFont(QFont(self.fn, 8, QFont.Normal))
        self.plot.setAxisTitle(Qwt.QwtPlot.yLeft, text)
                
    def ResetScale(self, parent=None): # auto rescale function
        self.plot.setAxisAutoScale(Qwt.QwtPlot.yLeft)
        self.plot.setAxisAutoScale(Qwt.QwtPlot.xBottom)
        self.plot.replot()       
        for zoomer in self.zoomers:
            zoomer.setZoomBase()

    def showTime(self):
        t = datetime.datetime.now()
        now = datetime.datetime.fromtimestamp(time.mktime(t.timetuple()))
        #print now.ctime()
        
    def RefreshListing(self, parent=None):
        if self.tabWidget.currentIndex()==1: # on vient de basculer sur l'onglet full listing
            if os.access(self.case_copy.dirPath + os.sep+str(self.Running_options_form_copy.Ro_Ln_le.text()), os.F_OK):
                listfile=open(self.case_copy.dirPath + os.sep + str(self.Running_options_form_copy.Ro_Ln_le.text()), "r")
                lines=listfile.readlines()
                self.textEdit_2.moveCursor(QtGui.QTextCursor.End, QtGui.QTextCursor.MoveAnchor)
                #monospace
                myCharFormat = QtGui.QTextCharFormat()    
                myCharFormat.setFontFixedPitch(True)
                self.textEdit_2.setCurrentCharFormat(myCharFormat)
                
                i = self.iLastLineListing + 1 # à chaque nouveau calcul (Run Syrthes), self.iLastLineListing devient -1, donc i = 0
                if i == 0 : # nouveau listing -> effacer le contenu de textEdit_2
                    self.textEdit_2.clear()       

                while i < len(lines): # charger les nouvelles lignes de listing
                    lstr = "" # le faire au moins une ligne
                    lstr = lstr + lines[i]
                    i = i + 1    
                    while (i % 2000 != 0) and (i < len(lines)) : # combiner x lignes dans une chaîne pour gagner du temps
                        lstr = lstr + lines[i]
                        i = i + 1
                        
                    self.textEdit_2.insertPlainText(lstr) # "coller" x lignes à la fois dans textEdit_2 pour gagner du temps
                
                self.iLastLineListing = len(lines) - 1 # enregistrer le numéro de la dernière ligne chargée pour ne pas repartir de 0 la prochaine fois
                
                self.textEdit_2.moveCursor(QtGui.QTextCursor.Start, QtGui.QTextCursor.MoveAnchor)
                listfile.close()
        pass
    

    def Screenshot(self, parent=None): # fonction de rappel de la capture d'écran
        self.plot.setStyleSheet("QwtPlot{border : 1px solid grey; padding : 5 5 5 5;}")
        self.originalPixmap=QtGui.QPixmap.grabWidget(self.plot)
        self.plot.setStyleSheet("QwtPlot{border : 0px solid grey; padding : 0 0 0 0;}")
        format= QtCore.QString("png")
        
        screenshotPath = self.lastDir_copy + self.tr(os.sep+"untitled.")+format

        fileName=QtGui.QFileDialog.getSaveFileName(self, self.tr("Save As"),
                            screenshotPath,
                            self.tr("*.%1;;All Files (*)")
                                                   .arg(format))
        if not fileName.isEmpty():
            self.originalPixmap.save(fileName, str(format))
            self.lastDir_copy = str(fileName).rsplit(os.sep, 1)[0] #update lastDir
        self.initSYRTHESFont()
        
    def wheel_event(self, event): # fonction de rappel prennant en compte les évènement de la roulette de la souris dans la fenêtre de suivis de calcul afin de faire le zoom
        pos=event.pos()
        delta=event.delta() # 15°-step-mousewheel --> delta = 15*8 =  120. Attention finer step on modern mouse will cause problem
        if delta>0:
            delta=delta/100
        else:
            delta=abs(delta)/150
        self.Mag.rescale(delta) # parameter of rescale : >1 zoom in ; <1 zoomout
        event.ignore()

    def grab_mouse(self, event): # fonction de rappel faisant appel au coordonnée de la souris pendant son déplacement pour faire glisser le graphique
        if event.buttons() & Qt.Qt.MidButton:
            if self.xposold==None or self.yposold==None: # Si il n'y a pas de coordonée précédente on prend les coordonnées actuelles
                self.xposold=event.x()
                self.yposold=event.y()
                
            xpos=event.x()# prise des coordonnées actuelles
            ypos=event.y()
            try: # Windows
                xmin=self.plot.axisScaleDiv(Qwt.QwtPlot.xBottom).lBound()# prise des bornes du graphique
                xmax=self.plot.axisScaleDiv(Qwt.QwtPlot.xBottom).hBound()
                ymin=self.plot.axisScaleDiv(Qwt.QwtPlot.yLeft).lBound()
                ymax=self.plot.axisScaleDiv(Qwt.QwtPlot.yLeft).hBound()
            except: # Linux
                xmin=self.plot.axisScaleDiv(Qwt.QwtPlot.xBottom).lowerBound()# prise des bornes du graphique
                xmax=self.plot.axisScaleDiv(Qwt.QwtPlot.xBottom).upperBound()
                ymin=self.plot.axisScaleDiv(Qwt.QwtPlot.yLeft).lowerBound()
                ymax=self.plot.axisScaleDiv(Qwt.QwtPlot.yLeft).upperBound()            
                factor=abs(float(xmax-xmin)/float(ymax-ymin)) # prise du ratio longueur largeur du graphique
                
            wp = self.plot.width() #plot width
            hp = self.plot.height() #plot height
            deltax = -float((xpos - self.xposold))/wp*(xmax - xmin)
            deltay = float((ypos - self.yposold))/hp*(ymax - ymin)
        
            self.plot.setAxisScale(Qwt.QwtPlot.xBottom, xmin+deltax, xmax+deltax, 0) # mise à jour de l'échelle des axes du graphique
            self.plot.setAxisScale(Qwt.QwtPlot.yLeft, ymin+deltay, ymax+deltay, 0)
            self.plot.replot() # mise à jour du graphique    
            self.xposold=xpos # enregistrement des positions actuels dans les positions anciennes
            self.yposold=ypos
            pass
        pass
        
    def raz_mouses(self, event): # fonction de remise à zéro des coordonnées précédente 
        self.xposold=None
        self.yposold=None
        
    def initSYRTHESFont(self):
        # (re)set font for the application
        return
	if not syrthesIHMContext.isEmbedded() :
            return
            myFont= app.font()
            myFont.setFamily('Sans')
            myFont.setStyleHint(QFont.SansSerif, QFont.PreferMatch)
            myFont.setPointSize(10)
            app.setFont(myFont)
        
class clCurve(Qwt.QwtPlotCurve):
    def __init__(self, legend="", parent=None):
        Qwt.QwtPlotCurve.__init__(self, legend)
        self.legend = legend
        self.Time = []
        self.Temper = []
        self.vP = [] # vapor pressure
        self.taP = [] # total air pressure
        self.tabIndexLinked = -1
        self.pen = Qt.QPen(Qt.Qt.green)
        self.pen.setWidth(2)
        self.color = Qt.Qt.black
        
        # coordonnées de la sonde
        self.dimension = -1
        self.x = ""
        self.y = ""
        self.z = ""
    
    def setColor(self, color):        
        self.color = color
        self.pen.setColor(color)
        self.setPen(self.pen)
        
        
    def setStyle(self, style):           
        styles = [None, Qt.Qt.SolidLine, Qt.Qt.DashLine, Qt.Qt.DotLine, Qt.Qt.DashDotLine]
        self.pen.setStyle(styles[style])
        self.setPen(self.pen)
        
    def printProbe(self):
        if self.dimension == 3 :
            return '[' + str(self.x) + ";" + str(self.y) + ";" + str(self.z) + ']'
        else:
            return '[' + str(self.x) + ";" + str(self.y) + ']'
    
    def refreshTemp(self):
        self.setData(self.Time, self.Temper)
        
    def refreshVaporP(self):
        self.setData(self.Time, self.vP)
        
    def refreshTotalAirP(self):
        self.setData(self.Time, self.taP)

    def razData(self):
        self.Time = []
        self.Temper = []
        self.setData([], [])
        
    #Time = property(_getTime, _setTime)
    #Temper = property(_getTemper, _setTemper)        
