//
// tardy - a tar post-processor
// Copyright (C) 1998, 1999, 2002, 2008, 2009 Peter Miller
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 3 of the License, or (at
// your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.
//

#include <libtardy/ac/unistd.h>
#include <libtardy/ac/fcntl.h>
#include <libtardy/file/input/normal.h>


file_input_normal::~file_input_normal()
{
    if (fd >= 0 && ::close(fd))
        nfatal("close");
}


file_input_normal::file_input_normal() :
    fn(),
    fd(-1)
{
    fatal("default constructor is private (bug)");
}


file_input_normal::file_input_normal(const char *arg) :
    fn(arg),
    fd(-1)
{
    fd = ::open(arg, O_RDONLY);
    if (fd < 0)
        nfatal("cannot open");
}


file_input_normal::file_input_normal(const file_input_normal &arg) :
    file_input(arg),
    fn(arg.fn),
    fd(-1)
{
    fd = dup(arg.fd);
    if (fd < 0)
        arg.nfatal("dup");
}


file_input_normal &
file_input_normal::operator = (const file_input_normal &arg)
{
    if (this != &arg)
    {
        file_input::operator=(arg);
        if (fd >= 0 && close(fd))
            nfatal("close");
        fn = arg.fn;
        fd = dup(arg.fd);
        if (fd < 0)
            arg.nfatal("dup");
    }
    return *this;
}


int
file_input_normal::read(void *buffer, int maximum_length)
    const
{
    int nbytes = ::read(fd, buffer, maximum_length);
    if (nbytes < 0)
        nfatal("read");
    return nbytes;
}


const char *
file_input_normal::filename()
    const
{
    return fn;
}
