//
//      tardy - a tar post-processor
//      Copyright (C) 1998, 1999, 2003, 2008, 2009 Peter Miller
//
//      This program is free software; you can redistribute it and/or modify
//      it under the terms of the GNU General Public License as published by
//      the Free Software Foundation; either version 3 of the License, or
//      (at your option) any later version.
//
//      This program is distributed in the hope that it will be useful,
//      but WITHOUT ANY WARRANTY; without even the implied warranty of
//      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//      GNU General Public License for more details.
//
//      You should have received a copy of the GNU General Public License
//      along with this program. If not, see
//      <http://www.gnu.org/licenses/>.
//

#ifndef COMMON_TAR_INPUT_SUPPR_DIREC_H
#define COMMON_TAR_INPUT_SUPPR_DIREC_H

#include <libtardy/tar/input/filter.h>

/**
  * The tar_input_filter_suppress_directories class is used to represent a
  * filter which removes records of directories from tar archive files.
  * All other type of files are passed through.  No file names are
  * altered in any way.
  */
class tar_input_filter_suppress_directories:
    public tar_input_filter
{
public:
    /**
      * The destructor.
      */
    virtual ~tar_input_filter_suppress_directories();

    /**
      * The constructor.
      *
      * \param deeper
      *     The input tream to be filtered.
      */
    tar_input_filter_suppress_directories(tar_input *deeper);

    // See base class for documentation.
    virtual int read_header(tar_header &);

private:
    /**
      * The default constructor.  Do not use.
      */
    tar_input_filter_suppress_directories();

    /**
      * The copy constructor.  Do not use.
      */
    tar_input_filter_suppress_directories(
        const tar_input_filter_suppress_directories &);

    /**
      * The assignment operator.  Do not use.
      */
    tar_input_filter_suppress_directories &operator = (
        const tar_input_filter_suppress_directories &);
};

#endif // COMMON_TAR_INPUT_SUPPR_DIREC_H
