//
//      tardy - a tar post-processor
//      Copyright (C) 1998, 1999, 2008, 2009 Peter Miller
//
//      This program is free software; you can redistribute it and/or modify
//      it under the terms of the GNU General Public License as published by
//      the Free Software Foundation; either version 3 of the License, or
//      (at your option) any later version.
//
//      This program is distributed in the hope that it will be useful,
//      but WITHOUT ANY WARRANTY; without even the implied warranty of
//      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//      GNU General Public License for more details.
//
//      You should have received a copy of the GNU General Public License
//      along with this program. If not, see
//      <http://www.gnu.org/licenses/>.
//

#ifndef COMMON_TAR_INPUT_USER_NUMBER_H
#define COMMON_TAR_INPUT_USER_NUMBER_H

#include <libtardy/tar/input/filter.h>

/**
  * The tar_input_filter_user_number class is used to represent a filter
  * which replaces the User ID in tar archive file headers.
  */
class tar_input_filter_user_number:
    public tar_input_filter
{
public:
    /**
      * The destructor.
      */
    virtual ~tar_input_filter_user_number();

    /**
      * the constructor.
      *
      * \param deeper
      *     The input stream to be filtered.
      * \param uid
      *     The User ID to be inserted into each file header.
      */
    tar_input_filter_user_number(tar_input *deeper, long uid);

    // See base class for documentation.
    virtual int read_header(tar_header &);

private:
    /**
      * The uid instance variable is used to remember the User ID to be
      * inserted into each file header in the tar archive.
      */
    long uid;

    /**
      * The default constructor.  Do not use.
      */
    tar_input_filter_user_number();

    /**
      * The copy constructor.  Do not use.
      */
    tar_input_filter_user_number(const tar_input_filter_user_number &);

    /**
      * The assignment operator.  Do not use.
      */
    tar_input_filter_user_number &operator = (
        const tar_input_filter_user_number &);
};

#endif // COMMON_TAR_INPUT_USER_NUMBER_H
