//
// tardy - a tar post-processor
// Copyright (C) 2011 Peter Miller
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 3 of the License, or (at
// your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.
//

#include <libtardy/ac/ctype.h>
#include <libtardy/ac/string.h>

#include <libtardy/file/output/hexdump.h>


file_output_hexdump::~file_output_hexdump()
{
    if (address & 15)
    {
        deeper->write(buffer, sizeof(buffer));
        address = 0;
    }
}


file_output_hexdump::file_output_hexdump(const file_output::pointer &a_deeper) :
    deeper(a_deeper),
    address(0)
{
}


file_output_hexdump::pointer
file_output_hexdump::create(const file_output::pointer &a_deeper)
{
    return pointer(new file_output_hexdump(a_deeper));
}


static void
hex(char *buffer, long value, size_t buffer_size)
{
    while (buffer_size > 0)
    {
        --buffer_size;
        buffer[buffer_size] = "0123456789ABCDEF"[value & 15];
        value >>= 4;
    }
}


void
file_output_hexdump::write(const void *data, int data_size)
{
    while (data_size > 0)
    {
        unsigned char c = *(const unsigned char *)data;
        data = (const unsigned char *)data + 1;
        --data_size;

        unsigned pos = address & 15;
        if (pos == 0)
        {
            memset(buffer, ' ', sizeof(buffer));
            hex(buffer, address, 8);
            buffer[8] = ':';
            buffer[sizeof(buffer) - 1] = '\n';
        }
        hex(buffer + 10 + 3 * pos, c, 2);
        c &= 0x7F;
        if (!isprint(c))
            c = '.';
        buffer[59 + pos] = c;
        if (pos == 15)
            deeper->write(buffer, sizeof(buffer));
        ++address;
    }
}


rcstring
file_output_hexdump::filename(void)
    const
{
    return deeper->filename();
}
