#
#  The archiver and the flag(s) to use when building archive (library)
#  If you system has no ranlib, set RANLIB = echo.
#

RANLIB    = ranlib

# for universal OSX binary
ARCH = libtool
ARCHFLAGS = -static -o

# for normal arch-native tuned OSX binary
# ARCH      = ar
# ARCHFLAGS = -rvs

#MACOSX_DEPLOYMENT_TARGET=10.4
#export MACOSX_DEPLOYMENT_TARGET


# #Mac OSX
# #
# LOCALLIBDIR = /usr/local/lib
# LIBS = -lgsl -lgslcblas -ldistfit -lmsa -ldssplite -ldltmath -lDLTutils -ltheseus
# SYSLIBS = -lpthread -lm -lc
# LIBDIR = -L./lib
# INSTALLDIR = /usr/local/bin
# #OPT = -O0 -ggdb
# OPT = -O3 -ffast-math -mtune=native# -fstrict-aliasing -funroll-loops -fomit-frame-pointer
# WARN = -Wall -Werror -pedantic -std=c99# -Wno-error=unused-result
# CFLAGS += $(WARN)
# # CPPFLAGS are ignored by the rest of the build system but necessary for hardening flags
# CFLAGS += $(CPPFLAGS)
# # Filter out -O2 which overwrites the default -O3 because OPT is used before CFLAGS
# CFLAGS := $(filter-out -O2,$(CFLAGS))
# CC = gcc


# Mac OSX Universal
#
LOCALLIBDIR = /usr/local/lib
LIBS = -lgsl -lgslcblas -ldistfit -lmsa -ldssplite -ldltmath -lDLTutils -ltheseus
SYSLIBS = -lpthread -lgsl -lgslcblas -lm -lc
LIBDIR = -L./lib
INSTALLDIR = /usr/local/bin
#OPT = -O0 -ggdb
OPT = -O3 -ffast-math #-fstrict-aliasing -funroll-loops -fomit-frame-pointer
#WARN = -Werror -Wno-error=unused-result -Wall -pedantic -std=c99
WARN = -Werror -Wall -pedantic -std=c99 # for APPLE MACOSX
CFLAGS += $(WARN) -force_cpusubtype_ALL -mmacosx-version-min=10.4 -arch x86_64 -arch i386 #-DNDEBUG
# CPPFLAGS are ignored by the rest of the build system but necessary for hardening flags
CFLAGS += $(CPPFLAGS)
# Filter out -O2 which overwrites the default -O3 because OPT is used before CFLAGS
CFLAGS := $(filter-out -O2,$(CFLAGS))
CC = gcc


# Ubuntu LINUX Dual processor Core2 x86_32, gulon (2010-09-07)
#
# LOCALLIBDIR = /usr/local/lib/
# SYSLIBS = -lpthread -lgsl -lgslcblas -lm -lc
# #SYSLIBS = -static -Wl,--whole-archive -lpthread -Wl,--no-whole-archive -lgsl -lgslcblas -lm -lc
# # --whole-archive is needed for pthread lib, due to static linking -- screwed but true
# # see http://gcc.gnu.org/bugzilla/show_bug.cgi?id=44927
# LIBS = -ldistfit -lmsa -ldssplite -ldltmath -lDLTutils -ltheseus
# LIBDIR = -L./lib/ -L/usr/lib/
# INCDIR = -I/usr/local/include/
# INSTALLDIR = /usr/local/bin
# OPT = -O3 -ffast-math -fstrict-aliasing -funroll-loops -fomit-frame-pointer
# # OPT = -m64 -O3 -march=native -funroll-loops -ffast-math -mfpmath=sse
# #OPT = -O0 -ggdb
# WARN = -Wall -pedantic -std=c99 -Wno-unused-result
# CFLAGS = $(WARN) -pthread
# CC = gcc


# LINUX CentOS 5 after "yum install blas-devel lapack-devel atlas-devel gsl-devel" and dependencies
#
# LOCALLIBDIR = /usr/local/lib
# SYSLIBS = -lm -lc -lgsl -lgslcblas
# LIBS = -ldistfit -lmsa -ldssplite -ldltmath -lDLTutils
# LIBDIR = -L./lib
# BLASLIB = -lblas
# LAPACKLIB = -llapack
# INSTALLDIR = /usr/local/bin
# OPT = -O3 -funroll-loops -ffast-math
# WARN = -Wall -pedantic -std=c99
# CFLAGS = $(WARN) -pthread
# CC = gcc


# BROKEN
# Win32 using mingw -- requires win32 pthread library
# SYSLIBS = -static -lpthreadGC2 -lg2c -lm
# LIBS = -ldistfit -lmsa -ldssplite -ldltmath -lDLTutils
# LIBDIR = -L./lib
# BLASLIB = -lblas
# LAPACKLIB = -llapack
# INSTALLDIR = /usr/local/bin
# OPT = -O3 -ffast-math -fstrict-aliasing -funroll-loops
# WARN = -Wall -pedantic -std=c99
# CFLAGS = $(WARN) -DNDEBUG
# CC = /usr/local/cross-tools/i386-mingw32msvc/bin/cc

