/*
 *	TICKR - GTK-based Feed Reader - Copyright (C) Emmanuel Thomas-Maurin 2009-2012
 *	<manutm007@gmail.com>
 *
 * 	This program is free software: you can redistribute it and/or modify
 * 	it under the terms of the GNU General Public License as published by
 * 	the Free Software Foundation, either version 3 of the License, or
 * 	(at your option) any later version.
 *
 * 	This program is distributed in the hope that it will be useful,
 * 	but WITHOUT ANY WARRANTY; without even the implied warranty of
 * 	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * 	GNU General Public License for more details.
 *
 * 	You should have received a copy of the GNU General Public License
 * 	along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef INC_TICKR_LIST_H
#define INC_TICKR_LIST_H

#define FLIST_URL_MAXLEN	FILE_NAME_MAXLEN
#define FLIST_TITLE_MAXLEN	FEED_TITLE_MAXLEN
#define N_FLIST_MAX		(32 * 1024)	/* to prevent infinite loops - adjust as necessary */
#define FLIST_SIG		"fl_node"
#define FLIST_SIG_LEN		7		/* check FLIST_SIG_LEN = strlen(FLIST_SIG) */

#define	IS_FLIST(node)\
	(node != NULL && strcmp(node->sig, FLIST_SIG) == 0)

#define CHECK_IS_FLIST(node, func)\
	if (!IS_FLIST(node)) {\
		big_error(FLIST_ERROR, 2, func, ": Invalid node in list");\
	}

typedef struct FeedListNode0 {
	char			*url;
	char			*title;
	gboolean		selected;
	struct FeedListNode0	*prev;
	struct FeedListNode0	*next;
	char			sig[FLIST_SIG_LEN + 1];
} FList;

FList	*f_list_new(const char *, const char *, gboolean);
void	f_list_free(FList *);
void	f_list_free_all(FList *);
FList	*f_list_first(FList *);
FList	*f_list_last(FList *);
FList	*f_list_prev(FList *);
FList	*f_list_next(FList *);
FList	*f_list_nth(FList *, int);
int	f_list_index(FList *);
int	f_list_count(FList *);
FList	*f_list_add_at_start(FList *, const char *, const char *, gboolean);
FList	*f_list_add_at_end(FList *, const char *, const char *, gboolean);
FList	*f_list_insert_before(FList *, const char *, const char *, gboolean);
FList	*f_list_insert_after(FList *, const char *, const char *, gboolean);
FList	*f_list_remove(FList *);
void	f_list_swap(FList *, FList *);
FList	*f_list_sort(FList *);
int	f_list_search(FList *, const char *);
int	f_list_load_from_file(FList **, const char *);
int	f_list_save_to_file(FList *, const char *);
#endif /* INC_TICKR_LIST_H */
