/*
 * Decompiled with CFR 0.152.
 */
package net.tinyos.comm;

public class ByteQueue {
    byte[] buffer;
    int nbegin;
    int nend;

    int num_free_back() {
        return this.buffer.length - this.nend;
    }

    void left_justify_into(byte[] byArray) {
        int n = this.nbegin;
        int n2 = 0;
        while (n < this.nend) {
            byArray[n2] = this.buffer[n];
            ++n;
            ++n2;
        }
        this.nend -= this.nbegin;
        this.nbegin = 0;
        this.buffer = byArray;
    }

    synchronized void ensure_free(int n) {
        if (this.nbegin + this.num_free_back() < n) {
            int n2;
            int n3 = this.available() + n;
            for (n2 = this.buffer.length * 2; n2 < n3; n2 *= 2) {
            }
            this.left_justify_into(new byte[n2]);
        } else if (this.num_free_back() < n) {
            this.left_justify_into(this.buffer);
        }
    }

    public int available() {
        return this.nend - this.nbegin;
    }

    public void push_back(byte by) {
        this.ensure_free(1);
        this.buffer[this.nend++] = by;
    }

    public void push_back(byte[] byArray) {
        this.push_back(byArray, 0, byArray.length);
    }

    public void push_back(byte[] byArray, int n, int n2) {
        this.ensure_free(n2);
        int n3 = n + n2;
        while (n < n3) {
            this.buffer[this.nend++] = byArray[n++];
        }
    }

    public int pop_front() {
        if (this.available() > 0) {
            return this.buffer[this.nbegin++] & 0xFF;
        }
        return -1;
    }

    public int pop_front(byte[] byArray) {
        return this.pop_front(byArray, 0, byArray.length);
    }

    public int pop_front(byte[] byArray, int n, int n2) {
        int n3 = this.available();
        if (n3 > n2) {
            n3 = n2;
        }
        int n4 = n + n2;
        while (n < n4) {
            byArray[n++] = this.buffer[this.nbegin++];
        }
        return n3;
    }

    public ByteQueue() {
        this(64);
    }

    public ByteQueue(int n) {
        this.buffer = new byte[n];
        this.nbegin = 0;
        this.nend = 0;
    }
}

