/****************************************************************************
    Copyright (C) 1987-2005 by Jeffery P. Hansen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
****************************************************************************/
#ifndef __gsim_h
#define __gsim_h
#include "config.h"
#include "hash.h"
#include "list.h"
#include "expr.h"
#include "gsim_config.h"
#include "delay.h"
#include "memory.h"
#include "vparser.h"
#include "thyme.h"
#include "gateinfo.h"
#include "module.h"
#include "cpath.h"

extern int ycLineNumber;
extern char *ycFileName;

extern int total_area;
extern int total_staticPower;

FILE *openInPath(const char *name);

void init_gates();
int testLogic(char*);

void VerilogDump();

void sendMsg(char *fmt,...);
void error(char *fmt,...);
void errorFile(char *fmt,...);
void errorGate(char *gat,char *fmt,...);
void errorNet(char *net,char *fmt,...);

void Led_enableMonitor(SGate *,EvQueue *);
void Led_disableMonitor(SGate *,EvQueue *);

#endif
