/*
    Tucnak - VHF contest log
    Copyright (C) 2002-2006  Ladislav Vaiz <ok1zia@nagano.cz>

    This program is free software; you can redistribute it and/or                                                        
    modify it under the terms of the GNU General Public License                                                          
    version 2 as published by the Free Software Foundation.

*/

#include "header.h"

#ifdef __CYGWIN__

int parport_init(struct cwdaemon *cwda){
	
	cwda->hInpOut = LoadLibrary("inpout32.dll");
	if (!cwda->hInpOut) {
		log_addf("Can't load inpout32.dll, error %d", GetLastError());
		return -1;
	}

	cwda->inp32 = (void*)GetProcAddress(cwda->hInpOut, "Inp32");
	if (!cwda->inp32){
		log_addf("Can't get entry point for Inp32, error %d", GetLastError());
		FreeLibrary(cwda->hInpOut);
		cwda->hInpOut = NULL;
		return -2;
	}

	cwda->out32 = (void*)GetProcAddress(cwda->hInpOut, "Out32");
	if (!cwda->inp32){
		log_addf("Can't get entry point for Out32, error %d", GetLastError());
		FreeLibrary(cwda->hInpOut);
		cwda->hInpOut = NULL;
		return -3;
	}

	cwda->hInpOut_mutex = g_mutex_new();
	cwda->baseport = 0x378;
	cwda->ctrl = cwda->inp32(cwda->baseport+2);
	parport_reset(cwda);
    return 0;
}


int parport_free(struct cwdaemon *cwda){
    
    if (!cwda || !cwda->hInpOut) return 0;
	
	LOCK(cwda->hInpOut);
	cwda->ctrl &= 0xf0;
    cwda->ctrl |= 0x0c; /* /CW=L=1 PTT=L=0 /SSBW=L=1 /ENABLE=H=0 */
	cwda->out32(cwda->baseport+2, cwda->ctrl);
	UNLOCK(cwda->hInpOut);
	
	FreeLibrary(cwda->hInpOut);
	cwda->hInpOut = NULL;
    g_mutex_free(cwda->hInpOut_mutex);
	return 0;
}

int parport_reset(struct cwdaemon *cwda){

    if (!cwda || !cwda->hInpOut) return 0;

	LOCK(cwda->hInpOut);
	cwda->ctrl &= 0xf0;
    cwda->ctrl |= 0x0d; /* /CW=L=1 PTT=L=0 /SSBW=L=1 /ENABLE=L=1 */
	cwda->out32(cwda->baseport+2, cwda->ctrl);
	UNLOCK(cwda->hInpOut);
	return 0;
}

int parport_cw(struct cwdaemon *cwda, int onoff){
    
    if (!cwda || !cwda->hInpOut) return 1;
    
	LOCK(cwda->hInpOut);
	if (onoff) 
		cwda->ctrl &= ~0x08; /* /CW=H=0 */
	else
		cwda->ctrl |= 0x08;  /* /CW=L=1 */
	
	cwda->out32(cwda->baseport+2, cwda->ctrl);
	UNLOCK(cwda->hInpOut);
    return 0;
}

int parport_ptt(struct cwdaemon *cwda, int onoff){
   
	if (!cwda || !cwda->hInpOut) return 1;
    
	LOCK(cwda->hInpOut);
	if (onoff) 
		cwda->ctrl |= 0x04;  /* PTT=H=1 */
	else
		cwda->ctrl &= ~0x04; /* PTT=L=0 */
	
	cwda->out32(cwda->baseport+2, cwda->ctrl);
	UNLOCK(cwda->hInpOut);
    return 0;
}

int parport_ssbway(struct cwdaemon *cwda, int onoff){

	if (!cwda || !cwda->hInpOut) return 1;
	
	LOCK(cwda->hInpOut);
	if (onoff) 
		cwda->ctrl &= ~0x02; /* /SSBW=H=0 */
	else
		cwda->ctrl |= 0x02;  /* /SSBW=L=1 */
	
	cwda->out32(cwda->baseport+2, cwda->ctrl);
	UNLOCK(cwda->hInpOut);
    return 0;
}

void parport_info(){
    
    printf("\n  parport_info:\n");
	printf("Using inpout32.dll\n");
    
    printf("\n");
}
#endif
