/*
    Tucnak - VHF contest log
    Copyright (C) 2002-2006  Ladislav Vaiz <ok1zia@nagano.cz>

    This program is free software; you can redistribute it and/or                                                        
    modify it under the terms of the GNU General Public License                                                          
    version 2 as published by the Free Software Foundation.

*/

#include "header.h"

void add_namedb(struct namedb *namedb, gchar *call, gchar *name);
    
struct namedb *namedb;

struct namedb *init_namedb(){
    struct namedb *namedb;

    namedb = g_new0(struct namedb, 1);
    namedb->names = g_hash_table_new(g_str_hash, g_str_equal);
    return namedb;
}

gboolean free_names_item(gpointer key, gpointer value, gpointer user_data){
    
    g_free(key);
    g_free(value);
    return 0;    
}

void free_namedb(struct namedb *namedb){
    g_hash_table_foreach_remove(namedb->names, free_names_item, NULL);
    g_hash_table_destroy(namedb->names);
    g_free(namedb);
}

gint get_namedb_size(struct namedb *namedb){
    return g_hash_table_size(namedb->names);
}

#define NAMEDB_DELIM " \t\r\n"

void load_one_namedb(struct namedb *namedb, gchar *s){
    gchar *call, *name;
    char *token_ptr;
    
    call = strtok_r(s, NAMEDB_DELIM, &token_ptr);
    if (!call) return;

    name = strtok_r(NULL, NAMEDB_DELIM, &token_ptr);
    if (!name) return;

    if (strlen(call)==0 || strlen(name)==0) return;
    
    add_namedb(namedb, call, name);
}

int load_namedb_from_file(struct namedb *namedb, gchar *filename){
    FILE *f;
    char s[102];

    /*dbg("load_namedb_from_file(%s)\n", filename);*/
    
    f = fopen(filename, "rt");
    if (!f){
        /*dbg("Can't open '%s'\n", filename);*/
        return -1;
    }

    while((fgets(s, 100, f))!=NULL){
        load_one_namedb(namedb,s);
    }

    fclose(f);
    return 0;
}


void read_namedb_files(struct namedb *namedb){
    gchar *s;
    
    load_namedb_from_file(namedb, SHAREDIR"/tucnaknames");
    s = g_strconcat(getenv("HOME"), "/tucnak/tucnaknames", NULL); 
    load_namedb_from_file(namedb, s);
    g_free(s);
}

int namedb_ret;

void save_one_name(gpointer key, gpointer value, gpointer user_data){
    FILE *f;
    gchar *call, *name;
    int ret;

    f   = (FILE *) user_data;
    call = (gchar *) key;
    name = (gchar *) value;

    ret=fprintf(f, "%s %s\n", call, name);
    if (ret<=0) namedb_ret++;
}

int save_namedb_into_file(struct namedb *namedb, gchar *filename){
    FILE *f;

    f = fopen(filename, "wt"); 
    if (!f) {
        return errno;
    }
    namedb_ret=0;
    g_hash_table_foreach(namedb->names, save_one_name, (gpointer) f);
    fclose(f);
    return namedb_ret;
}


void add_namedb(struct namedb *namedb, gchar *call, gchar *name){
    gchar *namedbi;
    
    /*dbg("add %s=%s\n", call, name);*/
    namedbi = g_hash_table_lookup(namedb->names, call);
    
    if (!namedbi){
        g_hash_table_insert(namedb->names, g_strdup(call), g_strdup(name));
    }
}


gchar *find_name_by_call(struct namedb *namedb, gchar *call){
    gchar *namedbi;
    char rawcall[120];

    get_raw_call(rawcall, call);
    
    namedbi = (gchar *) g_hash_table_lookup(namedb->names, rawcall);
    if (!namedbi) return NULL;
    
    return namedbi;
}

