# -*- coding: utf-8 -*-

# Authors: Natalia B Bidart <natalia.bidart@canonical.com>
#
# Copyright 2011 Canonical Ltd.
#
# This program is free software: you can redistribute it and/or modify it
# under the terms of the GNU General Public License version 3, as published
# by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranties of
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
# PURPOSE.  See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program.  If not, see <http://www.gnu.org/licenses/>.

"""Miscellaneous logging functions."""

import logging
import os

from logging.handlers import RotatingFileHandler

from ubuntuone.logger import LOGFOLDER, LOGBACKUP, basic_formatter

LOG_LEVEL = logging.DEBUG
HANDLER = RotatingFileHandler(os.path.join(LOGFOLDER, 'filestorageapi.log'),
                              maxBytes=1048576,
                              backupCount=LOGBACKUP)
HANDLER.setFormatter(basic_formatter)
HANDLER.setLevel(LOG_LEVEL)


def setup_logging(log_domain):
    """Create a logger for 'log_domain'.

    Final domain will be 'ubuntuone.filestorageapi.<log_domain>.

    """
    logger = logging.getLogger('ubuntuone.filestorageapi.%s' % log_domain)
    logger.setLevel(LOG_LEVEL)
    logger.addHandler(HANDLER)
    return logger
