"""
"""

import common_gen
import npapi_meta

def generate_sources_for(function_descriptions, callback_decls):
    content = ""
    func_decls = []

    content += _generate_callback_dispatchers (callback_decls)
    for func_description in function_descriptions:
        func_decls.append(_generate_source_for(func_description, callback_decls))
    content += '\n'.join (func_decls)

    return content

def _generate_callback_dispatchers(callback_decls):
    dispatchers = []
    for callback_decl in callback_decls:
        dispatchers.append (_generate_callback_dispatcher_for(callback_decl))
    return "\n".join(dispatchers)

def _generate_source_for(func_description, callback_decls):
    function_name = common_gen.get_binding_function_prefix () + func_description['name'][1].replace (common_gen.get_unity_webapps_function_prefix(), '')
    arg_count_validation_chunk = _generate_function_argument_count_check (len(func_description['parameters']));
    arg_validation_chunk = _generate_function_argument_type_validation (func_description['parameters'])
    var_creation_chunk = _generate_variable_creation_for_args (func_description['parameters'], callback_decls)
    func_call_chunk = _generate_webapps_function_call_for (func_description, callback_decls);
    free_resources_chunk = _generate_free_arguments_for (func_description['parameters']);
    return """
NPVariant
    %s (NPP instance
         , NPObject * npobject
         , const NPVariant *args
         , uint32_t argCount)
{
    NPVariant result;
    NULL_TO_NPVARIANT (result);
    %s
    %s
    %s
    %s
    %s
    return result;
}
    """ % (function_name
           , arg_count_validation_chunk
           , arg_validation_chunk
           , var_creation_chunk
           , func_call_chunk
           , free_resources_chunk
       )

def _generate_function_argument_count_check (count):
    return """
    if (argCount != %s)
    {
        NPN_SetException (npobject, "Invalid number of arguments for function call");
	return result;
    }
    """ % str(count)

def _generate_function_argument_type_validation (args):
    validators = []
    types = [arg['type'] for arg in args]
    for i, t in enumerate(types):
        arg = '(args[' + str(i) + '])'
        meta = npapi_meta.get_meta_info_for_type(t)
        validators.append (' ( ! ' + meta['validator'] + arg + ' && ! is_null_or_void' + arg + ' )')
    if len(validators) == 0:
        return ""
    return """
    if ( %s )
    {
        NPN_SetException(npobject, "Invalid argument type for function call");
        return result;
    }
    """ % " || \n\t".join (validators)

def _is_pointer_type(param_type):
    return param_type.strip().endswith('*')

def _generate_webapps_function_call_for (func_decl, callback_decls):
    func_params = func_decl['parameters']
    callback_types = [callback_decl['name'][1] for callback_decl in callback_decls]
    params = []

    # twisted way to "modify the state of the post-argument" generations
    #  given information extracted in a current state
    param_modifier = lambda param: param
    for func_param in func_params:
        name = func_param['name']
        if func_param['type'] in callback_types:
            name = _get_dispatcher_function_name(func_param['type'])
            param_modifier = lambda param: param == "user_data" and "wrappedCallback" or param
        else:
            name = param_modifier(name)
        params.append (name)

    fun_call = "REACHED_UNITY_WEBAPPS_FUNC_CALL();\n"
    fun_call += func_decl['name'][1] + "(" + ", ".join (params) + ");\n"

    return_type = ' '.join(func_decl['return'])
    if return_type != 'void' and _is_pointer_type(return_type):
        fun_call = return_type + ' ret_val = ' + fun_call
        meta = npapi_meta.get_meta_info_for_type(return_type)
        if meta and meta['nullable']:
            fun_call = fun_call + """
    if (NULL == ret_val)
    {
        return result;
    }
    NPObject * object = create_wrapped_ptr_object_for (instance, ret_val);
    if (NULL == object)
    {
        NPN_SetException(npobject, "Unable to wrap return value from NPAPI call");
        return result;
    }
    OBJECT_TO_NPVARIANT(object, result);
    """
        else:
            fun_call = fun_call + """
    %s (ret_val, result);
            """ % meta['to_variant']
    return fun_call

def _generate_free_arguments_for (args):
    arg_infos = zip (range(len(args))
                     , [arg['type'] for arg in args]
                     , [arg['name'] for arg in args])
    gen = []
    for idx, arg_type, arg_name in arg_infos:
        meta = npapi_meta.get_meta_info_for_type (arg_type)
        if not meta:
            print "_generate_free_arguments_for: No meta information found for type: ", arg_type
        else:
            if meta.has_key('can_free') and meta['can_free']:
                gen.append ("\tg_free (" + arg_name + ");")
    return '\n'.join (gen)

def _generate_variable_creation_for_arg (idx, arg_type, arg_name, callback_decls):
    meta = npapi_meta.get_meta_info_for_type (arg_type)
    src = ''
    callback_types = [callback_decl['name'][1] for callback_decl in callback_decls]
    if arg_type in callback_types:
        # handle callback gen
        src += _generate_callback_handling(idx, callback_decls[callback_types.index(arg_type)])
    elif meta['create_var']:
        src += "\t%s %s = %s;\n" % (arg_type, arg_name, meta['null'])
        if not meta['creator'] is None:
            src += """
    if ( ! is_null_or_void (args[%d]))
    {
    \t%s = %s;
    }
    """ % (idx, arg_name, meta['creator'] % idx)
    return src

def _generate_variable_creation_for_args (args, callback_decls):
    arg_infos = zip (range(len(args))
                     , [arg['type'] for arg in args]
                     , [arg['name'] for arg in args])
    gen = []
    
    for idx, arg_type, arg_name in arg_infos:
        gen.append (_generate_variable_creation_for_arg (idx, arg_type, arg_name, callback_decls))
        
    return '\n'.join (gen)

def _generate_callback_handling (param_idx, callback_decl):
    return """
    NPObject * callback = NPVARIANT_TO_OBJECT(args[%d]);
    ADD_NPOBJECT_RETAIN_FOR_CONTEXT(instance, context, callback);

    NPObject *
      wrappedCallback = create_wrapped_callback_object_for (instance, callback);
    ADD_NPOBJECT_RETAIN_FOR_CONTEXT(instance, context, wrappedCallback);
    """ % (param_idx, )

def _get_dispatcher_function_name (name):
    return "%s_dispatcher" % name

def _generate_callback_dispatcher_for (callback_decl):
    name = callback_decl['name'][1]
    dispatcher_func_name = _get_dispatcher_function_name(name)
    params = callback_decl['parameters']
    return """
static void
%s (UnityWebappsContext * context,
      gpointer user_data)
{
  // not really safe ... 
  wrapped_callback_t * pCallbackObject = (wrapped_callback_t *) user_data;

  // fill out the arguments
  NPVariant args [%d];

  // TODO call w/ meaningful values
  %s

  NPVariant response;
  NPN_InvokeDefault (pCallbackObject->instance,
		     pCallbackObject->wrapped_callback,
		     args,
		     G_N_ELEMENTS(args),
		     &response);
  NPN_ReleaseVariantValue(&response);
}
    """ % (dispatcher_func_name,len(params), "\n".join (["NULL_TO_NPVARIANT (args[%d]); //%s" % (i,param['name']) for i, param in enumerate(params)]))



