/*
 * Copyright (C) 2014 Canonical Ltd.
 *
 * This file is part of unity-chromium-extension
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 3, as published
 * by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef UNITY_WEBAPPS_CONNECTION
#define UNITY_WEBAPPS_CONNECTION

#include <QObject>
#include <QVariantMap>

namespace UnityWebapps {

class ConnectionPrivate;

class Connection: public QObject
{
    Q_OBJECT

public:
    explicit Connection(QObject *parent = 0);
    ~Connection();

    bool open();

public Q_SLOTS:
    void postMessage(const QVariantMap &message);

Q_SIGNALS:
    void messageReceived(const QVariantMap &message);

private:
    ConnectionPrivate *d_ptr;
    Q_DECLARE_PRIVATE(Connection)
};

} // namespace

#endif // UNITY_WEBAPPS_CONNECTION
