/* valareturnstatement.c generated by valac, the Vala compiler
 * generated from valareturnstatement.vala, do not modify */

/* valareturnstatement.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <valagee.h>


#define VALA_TYPE_CODE_NODE (vala_code_node_get_type ())
#define VALA_CODE_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_NODE, ValaCodeNode))
#define VALA_CODE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_NODE, ValaCodeNodeClass))
#define VALA_IS_CODE_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_NODE))
#define VALA_IS_CODE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_NODE))
#define VALA_CODE_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_NODE, ValaCodeNodeClass))

typedef struct _ValaCodeNode ValaCodeNode;
typedef struct _ValaCodeNodeClass ValaCodeNodeClass;
typedef struct _ValaCodeNodePrivate ValaCodeNodePrivate;

#define VALA_TYPE_CODE_VISITOR (vala_code_visitor_get_type ())
#define VALA_CODE_VISITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_VISITOR, ValaCodeVisitor))
#define VALA_CODE_VISITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_VISITOR, ValaCodeVisitorClass))
#define VALA_IS_CODE_VISITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_VISITOR))
#define VALA_IS_CODE_VISITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_VISITOR))
#define VALA_CODE_VISITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_VISITOR, ValaCodeVisitorClass))

typedef struct _ValaCodeVisitor ValaCodeVisitor;
typedef struct _ValaCodeVisitorClass ValaCodeVisitorClass;

#define VALA_TYPE_CODE_CONTEXT (vala_code_context_get_type ())
#define VALA_CODE_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_CONTEXT, ValaCodeContext))
#define VALA_CODE_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_CONTEXT, ValaCodeContextClass))
#define VALA_IS_CODE_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_CONTEXT))
#define VALA_IS_CODE_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_CONTEXT))
#define VALA_CODE_CONTEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_CONTEXT, ValaCodeContextClass))

typedef struct _ValaCodeContext ValaCodeContext;
typedef struct _ValaCodeContextClass ValaCodeContextClass;

#define VALA_TYPE_CODE_GENERATOR (vala_code_generator_get_type ())
#define VALA_CODE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_GENERATOR, ValaCodeGenerator))
#define VALA_CODE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_GENERATOR, ValaCodeGeneratorClass))
#define VALA_IS_CODE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_GENERATOR))
#define VALA_IS_CODE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_GENERATOR))
#define VALA_CODE_GENERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_GENERATOR, ValaCodeGeneratorClass))

typedef struct _ValaCodeGenerator ValaCodeGenerator;
typedef struct _ValaCodeGeneratorClass ValaCodeGeneratorClass;

#define VALA_TYPE_DATA_TYPE (vala_data_type_get_type ())
#define VALA_DATA_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DATA_TYPE, ValaDataType))
#define VALA_DATA_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DATA_TYPE, ValaDataTypeClass))
#define VALA_IS_DATA_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DATA_TYPE))
#define VALA_IS_DATA_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DATA_TYPE))
#define VALA_DATA_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DATA_TYPE, ValaDataTypeClass))

typedef struct _ValaDataType ValaDataType;
typedef struct _ValaDataTypeClass ValaDataTypeClass;

#define VALA_TYPE_EXPRESSION (vala_expression_get_type ())
#define VALA_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_EXPRESSION, ValaExpression))
#define VALA_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_EXPRESSION, ValaExpressionClass))
#define VALA_IS_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_EXPRESSION))
#define VALA_IS_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_EXPRESSION))
#define VALA_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_EXPRESSION, ValaExpressionClass))

typedef struct _ValaExpression ValaExpression;
typedef struct _ValaExpressionClass ValaExpressionClass;

#define VALA_TYPE_SYMBOL (vala_symbol_get_type ())
#define VALA_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SYMBOL, ValaSymbol))
#define VALA_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SYMBOL, ValaSymbolClass))
#define VALA_IS_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SYMBOL))
#define VALA_IS_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SYMBOL))
#define VALA_SYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SYMBOL, ValaSymbolClass))

typedef struct _ValaSymbol ValaSymbol;
typedef struct _ValaSymbolClass ValaSymbolClass;

#define VALA_TYPE_VARIABLE (vala_variable_get_type ())
#define VALA_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_VARIABLE, ValaVariable))
#define VALA_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_VARIABLE, ValaVariableClass))
#define VALA_IS_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_VARIABLE))
#define VALA_IS_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_VARIABLE))
#define VALA_VARIABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_VARIABLE, ValaVariableClass))

typedef struct _ValaVariable ValaVariable;
typedef struct _ValaVariableClass ValaVariableClass;

#define VALA_TYPE_LOCAL_VARIABLE (vala_local_variable_get_type ())
#define VALA_LOCAL_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariable))
#define VALA_LOCAL_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariableClass))
#define VALA_IS_LOCAL_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_LOCAL_VARIABLE))
#define VALA_IS_LOCAL_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_LOCAL_VARIABLE))
#define VALA_LOCAL_VARIABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariableClass))

typedef struct _ValaLocalVariable ValaLocalVariable;
typedef struct _ValaLocalVariableClass ValaLocalVariableClass;

#define VALA_TYPE_ATTRIBUTE (vala_attribute_get_type ())
#define VALA_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ATTRIBUTE, ValaAttribute))
#define VALA_ATTRIBUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ATTRIBUTE, ValaAttributeClass))
#define VALA_IS_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ATTRIBUTE))
#define VALA_IS_ATTRIBUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ATTRIBUTE))
#define VALA_ATTRIBUTE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ATTRIBUTE, ValaAttributeClass))

typedef struct _ValaAttribute ValaAttribute;
typedef struct _ValaAttributeClass ValaAttributeClass;

#define VALA_TYPE_STATEMENT (vala_statement_get_type ())
#define VALA_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_STATEMENT, ValaStatement))
#define VALA_IS_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_STATEMENT))
#define VALA_STATEMENT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), VALA_TYPE_STATEMENT, ValaStatementIface))

typedef struct _ValaStatement ValaStatement;
typedef struct _ValaStatementIface ValaStatementIface;

#define VALA_TYPE_RETURN_STATEMENT (vala_return_statement_get_type ())
#define VALA_RETURN_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_RETURN_STATEMENT, ValaReturnStatement))
#define VALA_RETURN_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_RETURN_STATEMENT, ValaReturnStatementClass))
#define VALA_IS_RETURN_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_RETURN_STATEMENT))
#define VALA_IS_RETURN_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_RETURN_STATEMENT))
#define VALA_RETURN_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_RETURN_STATEMENT, ValaReturnStatementClass))

typedef struct _ValaReturnStatement ValaReturnStatement;
typedef struct _ValaReturnStatementClass ValaReturnStatementClass;
typedef struct _ValaReturnStatementPrivate ValaReturnStatementPrivate;
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))

#define VALA_TYPE_SOURCE_REFERENCE (vala_source_reference_get_type ())
#define VALA_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReference))
#define VALA_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReferenceClass))
#define VALA_IS_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SOURCE_REFERENCE))
#define VALA_IS_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SOURCE_REFERENCE))
#define VALA_SOURCE_REFERENCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReferenceClass))

typedef struct _ValaSourceReference ValaSourceReference;
typedef struct _ValaSourceReferenceClass ValaSourceReferenceClass;

#define VALA_TYPE_SEMANTIC_ANALYZER (vala_semantic_analyzer_get_type ())
#define VALA_SEMANTIC_ANALYZER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SEMANTIC_ANALYZER, ValaSemanticAnalyzer))
#define VALA_SEMANTIC_ANALYZER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SEMANTIC_ANALYZER, ValaSemanticAnalyzerClass))
#define VALA_IS_SEMANTIC_ANALYZER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SEMANTIC_ANALYZER))
#define VALA_IS_SEMANTIC_ANALYZER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SEMANTIC_ANALYZER))
#define VALA_SEMANTIC_ANALYZER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SEMANTIC_ANALYZER, ValaSemanticAnalyzerClass))

typedef struct _ValaSemanticAnalyzer ValaSemanticAnalyzer;
typedef struct _ValaSemanticAnalyzerClass ValaSemanticAnalyzerClass;

#define VALA_TYPE_PROFILE (vala_profile_get_type ())

#define VALA_TYPE_VOID_TYPE (vala_void_type_get_type ())
#define VALA_VOID_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_VOID_TYPE, ValaVoidType))
#define VALA_VOID_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_VOID_TYPE, ValaVoidTypeClass))
#define VALA_IS_VOID_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_VOID_TYPE))
#define VALA_IS_VOID_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_VOID_TYPE))
#define VALA_VOID_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_VOID_TYPE, ValaVoidTypeClass))

typedef struct _ValaVoidType ValaVoidType;
typedef struct _ValaVoidTypeClass ValaVoidTypeClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define VALA_TYPE_LITERAL (vala_literal_get_type ())
#define VALA_LITERAL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_LITERAL, ValaLiteral))
#define VALA_LITERAL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_LITERAL, ValaLiteralClass))
#define VALA_IS_LITERAL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_LITERAL))
#define VALA_IS_LITERAL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_LITERAL))
#define VALA_LITERAL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_LITERAL, ValaLiteralClass))

typedef struct _ValaLiteral ValaLiteral;
typedef struct _ValaLiteralClass ValaLiteralClass;

#define VALA_TYPE_NULL_LITERAL (vala_null_literal_get_type ())
#define VALA_NULL_LITERAL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_NULL_LITERAL, ValaNullLiteral))
#define VALA_NULL_LITERAL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_NULL_LITERAL, ValaNullLiteralClass))
#define VALA_IS_NULL_LITERAL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_NULL_LITERAL))
#define VALA_IS_NULL_LITERAL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_NULL_LITERAL))
#define VALA_NULL_LITERAL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_NULL_LITERAL, ValaNullLiteralClass))

typedef struct _ValaNullLiteral ValaNullLiteral;
typedef struct _ValaNullLiteralClass ValaNullLiteralClass;
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))

struct _ValaCodeNode {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaCodeNodePrivate * priv;
	GList* attributes;
};

struct _ValaCodeNodeClass {
	GTypeClass parent_class;
	void (*finalize) (ValaCodeNode *self);
	void (*accept) (ValaCodeNode* self, ValaCodeVisitor* visitor);
	void (*accept_children) (ValaCodeNode* self, ValaCodeVisitor* visitor);
	gboolean (*check) (ValaCodeNode* self, ValaCodeContext* context);
	void (*emit) (ValaCodeNode* self, ValaCodeGenerator* codegen);
	void (*replace_type) (ValaCodeNode* self, ValaDataType* old_type, ValaDataType* new_type);
	void (*replace_expression) (ValaCodeNode* self, ValaExpression* old_node, ValaExpression* new_node);
	gchar* (*to_string) (ValaCodeNode* self);
	void (*get_defined_variables) (ValaCodeNode* self, ValaCollection* collection);
	void (*get_used_variables) (ValaCodeNode* self, ValaCollection* collection);
};

struct _ValaStatementIface {
	GTypeInterface parent_iface;
};

struct _ValaReturnStatement {
	ValaCodeNode parent_instance;
	ValaReturnStatementPrivate * priv;
};

struct _ValaReturnStatementClass {
	ValaCodeNodeClass parent_class;
};

struct _ValaReturnStatementPrivate {
	ValaExpression* _return_expression;
};

typedef enum  {
	VALA_PROFILE_POSIX,
	VALA_PROFILE_GOBJECT,
	VALA_PROFILE_DOVA
} ValaProfile;


static gpointer vala_return_statement_parent_class = NULL;
static ValaStatementIface* vala_return_statement_vala_statement_parent_iface = NULL;

gpointer vala_code_node_ref (gpointer instance);
void vala_code_node_unref (gpointer instance);
GParamSpec* vala_param_spec_code_node (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_node (GValue* value, gpointer v_object);
void vala_value_take_code_node (GValue* value, gpointer v_object);
gpointer vala_value_get_code_node (const GValue* value);
GType vala_code_node_get_type (void) G_GNUC_CONST;
gpointer vala_code_visitor_ref (gpointer instance);
void vala_code_visitor_unref (gpointer instance);
GParamSpec* vala_param_spec_code_visitor (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_visitor (GValue* value, gpointer v_object);
void vala_value_take_code_visitor (GValue* value, gpointer v_object);
gpointer vala_value_get_code_visitor (const GValue* value);
GType vala_code_visitor_get_type (void) G_GNUC_CONST;
gpointer vala_code_context_ref (gpointer instance);
void vala_code_context_unref (gpointer instance);
GParamSpec* vala_param_spec_code_context (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_context (GValue* value, gpointer v_object);
void vala_value_take_code_context (GValue* value, gpointer v_object);
gpointer vala_value_get_code_context (const GValue* value);
GType vala_code_context_get_type (void) G_GNUC_CONST;
GType vala_code_generator_get_type (void) G_GNUC_CONST;
GType vala_data_type_get_type (void) G_GNUC_CONST;
GType vala_expression_get_type (void) G_GNUC_CONST;
GType vala_symbol_get_type (void) G_GNUC_CONST;
GType vala_variable_get_type (void) G_GNUC_CONST;
GType vala_local_variable_get_type (void) G_GNUC_CONST;
GType vala_attribute_get_type (void) G_GNUC_CONST;
GType vala_statement_get_type (void) G_GNUC_CONST;
GType vala_return_statement_get_type (void) G_GNUC_CONST;
#define VALA_RETURN_STATEMENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_RETURN_STATEMENT, ValaReturnStatementPrivate))
enum  {
	VALA_RETURN_STATEMENT_DUMMY_PROPERTY
};
gpointer vala_source_reference_ref (gpointer instance);
void vala_source_reference_unref (gpointer instance);
GParamSpec* vala_param_spec_source_reference (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_source_reference (GValue* value, gpointer v_object);
void vala_value_take_source_reference (GValue* value, gpointer v_object);
gpointer vala_value_get_source_reference (const GValue* value);
GType vala_source_reference_get_type (void) G_GNUC_CONST;
ValaReturnStatement* vala_return_statement_new (ValaExpression* return_expression, ValaSourceReference* source_reference);
ValaReturnStatement* vala_return_statement_construct (GType object_type, ValaExpression* return_expression, ValaSourceReference* source_reference);
ValaCodeNode* vala_code_node_construct (GType object_type);
void vala_code_node_set_source_reference (ValaCodeNode* self, ValaSourceReference* value);
void vala_return_statement_set_return_expression (ValaReturnStatement* self, ValaExpression* value);
static void vala_return_statement_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
void vala_code_visitor_visit_return_statement (ValaCodeVisitor* self, ValaReturnStatement* stmt);
static void vala_return_statement_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor);
ValaExpression* vala_return_statement_get_return_expression (ValaReturnStatement* self);
void vala_code_node_accept (ValaCodeNode* self, ValaCodeVisitor* visitor);
void vala_code_visitor_visit_end_full_expression (ValaCodeVisitor* self, ValaExpression* expr);
static void vala_return_statement_real_replace_expression (ValaCodeNode* base, ValaExpression* old_node, ValaExpression* new_node);
static gboolean vala_return_statement_real_check (ValaCodeNode* base, ValaCodeContext* context);
gboolean vala_code_node_get_checked (ValaCodeNode* self);
gboolean vala_code_node_get_error (ValaCodeNode* self);
void vala_code_node_set_checked (ValaCodeNode* self, gboolean value);
GType vala_semantic_analyzer_get_type (void) G_GNUC_CONST;
ValaSemanticAnalyzer* vala_code_context_get_analyzer (ValaCodeContext* self);
ValaDataType* vala_semantic_analyzer_get_current_return_type (ValaSemanticAnalyzer* self);
void vala_expression_set_target_type (ValaExpression* self, ValaDataType* value);
gboolean vala_code_node_check (ValaCodeNode* self, ValaCodeContext* context);
void vala_code_node_set_error (ValaCodeNode* self, gboolean value);
void vala_report_error (ValaSourceReference* source, const gchar* message);
ValaSourceReference* vala_code_node_get_source_reference (ValaCodeNode* self);
GType vala_profile_get_type (void) G_GNUC_CONST;
ValaProfile vala_code_context_get_profile (ValaCodeContext* self);
GType vala_void_type_get_type (void) G_GNUC_CONST;
ValaDataType* vala_expression_get_value_type (ValaExpression* self);
gboolean vala_data_type_compatible (ValaDataType* self, ValaDataType* target_type);
gchar* vala_code_node_to_string (ValaCodeNode* self);
gboolean vala_data_type_is_disposable (ValaDataType* self);
gboolean vala_data_type_get_value_owned (ValaDataType* self);
ValaSymbol* vala_expression_get_symbol_reference (ValaExpression* self);
ValaDataType* vala_variable_get_variable_type (ValaVariable* self);
GType vala_literal_get_type (void) G_GNUC_CONST;
GType vala_null_literal_get_type (void) G_GNUC_CONST;
gboolean vala_data_type_get_nullable (ValaDataType* self);
void vala_report_warning (ValaSourceReference* source, const gchar* message);
void vala_code_node_add_error_types (ValaCodeNode* self, ValaList* error_types);
ValaList* vala_code_node_get_error_types (ValaCodeNode* self);
static void vala_return_statement_real_emit (ValaCodeNode* base, ValaCodeGenerator* codegen);
void vala_code_node_emit (ValaCodeNode* self, ValaCodeGenerator* codegen);
static void vala_return_statement_real_get_defined_variables (ValaCodeNode* base, ValaCollection* collection);
void vala_code_node_get_defined_variables (ValaCodeNode* self, ValaCollection* collection);
static void vala_return_statement_real_get_used_variables (ValaCodeNode* base, ValaCollection* collection);
void vala_code_node_get_used_variables (ValaCodeNode* self, ValaCollection* collection);
void vala_code_node_set_parent_node (ValaCodeNode* self, ValaCodeNode* value);
static void vala_return_statement_finalize (ValaCodeNode* obj);


/**
 * Creates a new return statement.
 *
 * @param return_expression the return expression
 * @param source_reference  reference to source code
 * @return                  newly created return statement
 */
ValaReturnStatement* vala_return_statement_construct (GType object_type, ValaExpression* return_expression, ValaSourceReference* source_reference) {
	ValaReturnStatement* self = NULL;
	self = (ValaReturnStatement*) vala_code_node_construct (object_type);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	vala_return_statement_set_return_expression (self, return_expression);
	return self;
}


ValaReturnStatement* vala_return_statement_new (ValaExpression* return_expression, ValaSourceReference* source_reference) {
	return vala_return_statement_construct (VALA_TYPE_RETURN_STATEMENT, return_expression, source_reference);
}


static void vala_return_statement_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaReturnStatement * self;
	self = (ValaReturnStatement*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_return_statement (visitor, self);
}


static void vala_return_statement_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaReturnStatement * self;
	ValaExpression* _tmp0_ = NULL;
	self = (ValaReturnStatement*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_return_statement_get_return_expression (self);
	if (_tmp0_ != NULL) {
		ValaExpression* _tmp1_ = NULL;
		ValaExpression* _tmp2_ = NULL;
		_tmp1_ = vala_return_statement_get_return_expression (self);
		vala_code_node_accept ((ValaCodeNode*) _tmp1_, visitor);
		_tmp2_ = vala_return_statement_get_return_expression (self);
		vala_code_visitor_visit_end_full_expression (visitor, _tmp2_);
	}
}


static void vala_return_statement_real_replace_expression (ValaCodeNode* base, ValaExpression* old_node, ValaExpression* new_node) {
	ValaReturnStatement * self;
	ValaExpression* _tmp0_ = NULL;
	self = (ValaReturnStatement*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_return_statement_get_return_expression (self);
	if (_tmp0_ == old_node) {
		vala_return_statement_set_return_expression (self, new_node);
	}
}


static gpointer _vala_code_node_ref0 (gpointer self) {
	return self ? vala_code_node_ref (self) : NULL;
}


static gboolean vala_return_statement_real_check (ValaCodeNode* base, ValaCodeContext* context) {
	ValaReturnStatement * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	ValaExpression* _tmp2_ = NULL;
	gboolean _tmp6_ = FALSE;
	ValaExpression* _tmp7_ = NULL;
	ValaSemanticAnalyzer* _tmp10_ = NULL;
	ValaDataType* _tmp11_ = NULL;
	ValaProfile _tmp13_;
	ValaExpression* _tmp15_ = NULL;
	ValaSemanticAnalyzer* _tmp20_ = NULL;
	ValaDataType* _tmp21_ = NULL;
	ValaExpression* _tmp23_ = NULL;
	ValaDataType* _tmp24_ = NULL;
	ValaExpression* _tmp26_ = NULL;
	ValaDataType* _tmp27_ = NULL;
	ValaSemanticAnalyzer* _tmp28_ = NULL;
	ValaDataType* _tmp29_ = NULL;
	gboolean _tmp30_;
	gboolean _tmp42_ = FALSE;
	ValaExpression* _tmp43_ = NULL;
	ValaDataType* _tmp44_ = NULL;
	gboolean _tmp45_;
	ValaExpression* _tmp50_ = NULL;
	ValaSymbol* _tmp51_ = NULL;
	ValaSymbol* _tmp52_;
	ValaLocalVariable* _tmp53_;
	ValaLocalVariable* local;
	gboolean _tmp54_ = FALSE;
	gboolean _tmp55_ = FALSE;
	gboolean _tmp62_ = FALSE;
	ValaExpression* _tmp63_ = NULL;
	ValaExpression* _tmp74_ = NULL;
	ValaList* _tmp75_ = NULL;
	ValaList* _tmp76_;
	gboolean _tmp77_;
	self = (ValaReturnStatement*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	if (_tmp0_) {
		gboolean _tmp1_;
		_tmp1_ = vala_code_node_get_error ((ValaCodeNode*) self);
		result = !_tmp1_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp2_ = vala_return_statement_get_return_expression (self);
	if (_tmp2_ != NULL) {
		ValaExpression* _tmp3_ = NULL;
		ValaSemanticAnalyzer* _tmp4_ = NULL;
		ValaDataType* _tmp5_ = NULL;
		_tmp3_ = vala_return_statement_get_return_expression (self);
		_tmp4_ = vala_code_context_get_analyzer (context);
		_tmp5_ = vala_semantic_analyzer_get_current_return_type (_tmp4_);
		vala_expression_set_target_type (_tmp3_, _tmp5_);
	}
	_tmp7_ = vala_return_statement_get_return_expression (self);
	if (_tmp7_ != NULL) {
		ValaExpression* _tmp8_ = NULL;
		gboolean _tmp9_;
		_tmp8_ = vala_return_statement_get_return_expression (self);
		_tmp9_ = vala_code_node_check ((ValaCodeNode*) _tmp8_, context);
		_tmp6_ = !_tmp9_;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	_tmp10_ = vala_code_context_get_analyzer (context);
	_tmp11_ = vala_semantic_analyzer_get_current_return_type (_tmp10_);
	if (_tmp11_ == NULL) {
		ValaSourceReference* _tmp12_ = NULL;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp12_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		vala_report_error (_tmp12_, "Return not allowed in this context");
		result = FALSE;
		return result;
	}
	_tmp13_ = vala_code_context_get_profile (context);
	if (_tmp13_ == VALA_PROFILE_DOVA) {
		gboolean _tmp14_;
		_tmp14_ = vala_code_node_get_error ((ValaCodeNode*) self);
		result = !_tmp14_;
		return result;
	}
	_tmp15_ = vala_return_statement_get_return_expression (self);
	if (_tmp15_ == NULL) {
		ValaSemanticAnalyzer* _tmp16_ = NULL;
		ValaDataType* _tmp17_ = NULL;
		gboolean _tmp19_;
		_tmp16_ = vala_code_context_get_analyzer (context);
		_tmp17_ = vala_semantic_analyzer_get_current_return_type (_tmp16_);
		if (!VALA_IS_VOID_TYPE (_tmp17_)) {
			ValaSourceReference* _tmp18_ = NULL;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp18_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			vala_report_error (_tmp18_, "Return without value in non-void function");
		}
		_tmp19_ = vala_code_node_get_error ((ValaCodeNode*) self);
		result = !_tmp19_;
		return result;
	}
	_tmp20_ = vala_code_context_get_analyzer (context);
	_tmp21_ = vala_semantic_analyzer_get_current_return_type (_tmp20_);
	if (VALA_IS_VOID_TYPE (_tmp21_)) {
		ValaSourceReference* _tmp22_ = NULL;
		_tmp22_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		vala_report_error (_tmp22_, "Return with value in void function");
		result = FALSE;
		return result;
	}
	_tmp23_ = vala_return_statement_get_return_expression (self);
	_tmp24_ = vala_expression_get_value_type (_tmp23_);
	if (_tmp24_ == NULL) {
		ValaSourceReference* _tmp25_ = NULL;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp25_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		vala_report_error (_tmp25_, "Invalid expression in return value");
		result = FALSE;
		return result;
	}
	_tmp26_ = vala_return_statement_get_return_expression (self);
	_tmp27_ = vala_expression_get_value_type (_tmp26_);
	_tmp28_ = vala_code_context_get_analyzer (context);
	_tmp29_ = vala_semantic_analyzer_get_current_return_type (_tmp28_);
	_tmp30_ = vala_data_type_compatible (_tmp27_, _tmp29_);
	if (!_tmp30_) {
		ValaSourceReference* _tmp31_ = NULL;
		ValaExpression* _tmp32_ = NULL;
		ValaDataType* _tmp33_ = NULL;
		gchar* _tmp34_ = NULL;
		gchar* _tmp35_;
		ValaSemanticAnalyzer* _tmp36_ = NULL;
		ValaDataType* _tmp37_ = NULL;
		gchar* _tmp38_ = NULL;
		gchar* _tmp39_;
		gchar* _tmp40_ = NULL;
		gchar* _tmp41_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp31_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp32_ = vala_return_statement_get_return_expression (self);
		_tmp33_ = vala_expression_get_value_type (_tmp32_);
		_tmp34_ = vala_code_node_to_string ((ValaCodeNode*) _tmp33_);
		_tmp35_ = _tmp34_;
		_tmp36_ = vala_code_context_get_analyzer (context);
		_tmp37_ = vala_semantic_analyzer_get_current_return_type (_tmp36_);
		_tmp38_ = vala_code_node_to_string ((ValaCodeNode*) _tmp37_);
		_tmp39_ = _tmp38_;
		_tmp40_ = g_strdup_printf ("Return: Cannot convert from `%s' to `%s'", _tmp35_, _tmp39_);
		_tmp41_ = _tmp40_;
		vala_report_error (_tmp31_, _tmp41_);
		_g_free0 (_tmp41_);
		_g_free0 (_tmp39_);
		_g_free0 (_tmp35_);
		result = FALSE;
		return result;
	}
	_tmp43_ = vala_return_statement_get_return_expression (self);
	_tmp44_ = vala_expression_get_value_type (_tmp43_);
	_tmp45_ = vala_data_type_is_disposable (_tmp44_);
	if (_tmp45_) {
		ValaSemanticAnalyzer* _tmp46_ = NULL;
		ValaDataType* _tmp47_ = NULL;
		gboolean _tmp48_;
		_tmp46_ = vala_code_context_get_analyzer (context);
		_tmp47_ = vala_semantic_analyzer_get_current_return_type (_tmp46_);
		_tmp48_ = vala_data_type_get_value_owned (_tmp47_);
		_tmp42_ = !_tmp48_;
	} else {
		_tmp42_ = FALSE;
	}
	if (_tmp42_) {
		ValaSourceReference* _tmp49_ = NULL;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp49_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		vala_report_error (_tmp49_, "Return value transfers ownership but method return type hasn't been de" \
"clared to transfer ownership");
		result = FALSE;
		return result;
	}
	_tmp50_ = vala_return_statement_get_return_expression (self);
	_tmp51_ = vala_expression_get_symbol_reference (_tmp50_);
	_tmp52_ = _tmp51_;
	_tmp53_ = _vala_code_node_ref0 (VALA_IS_LOCAL_VARIABLE (_tmp52_) ? ((ValaLocalVariable*) _tmp52_) : NULL);
	local = _tmp53_;
	if (local != NULL) {
		ValaDataType* _tmp56_ = NULL;
		gboolean _tmp57_;
		_tmp56_ = vala_variable_get_variable_type ((ValaVariable*) local);
		_tmp57_ = vala_data_type_is_disposable (_tmp56_);
		_tmp55_ = _tmp57_;
	} else {
		_tmp55_ = FALSE;
	}
	if (_tmp55_) {
		ValaSemanticAnalyzer* _tmp58_ = NULL;
		ValaDataType* _tmp59_ = NULL;
		gboolean _tmp60_;
		_tmp58_ = vala_code_context_get_analyzer (context);
		_tmp59_ = vala_semantic_analyzer_get_current_return_type (_tmp58_);
		_tmp60_ = vala_data_type_get_value_owned (_tmp59_);
		_tmp54_ = !_tmp60_;
	} else {
		_tmp54_ = FALSE;
	}
	if (_tmp54_) {
		ValaSourceReference* _tmp61_ = NULL;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp61_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		vala_report_error (_tmp61_, "Local variable with strong reference used as return value and method r" \
"eturn type has not been declared to transfer ownership");
		result = FALSE;
		_vala_code_node_unref0 (local);
		return result;
	}
	_tmp63_ = vala_return_statement_get_return_expression (self);
	if (VALA_IS_NULL_LITERAL (_tmp63_)) {
		ValaSemanticAnalyzer* _tmp64_ = NULL;
		ValaDataType* _tmp65_ = NULL;
		gboolean _tmp66_;
		_tmp64_ = vala_code_context_get_analyzer (context);
		_tmp65_ = vala_semantic_analyzer_get_current_return_type (_tmp64_);
		_tmp66_ = vala_data_type_get_nullable (_tmp65_);
		_tmp62_ = !_tmp66_;
	} else {
		_tmp62_ = FALSE;
	}
	if (_tmp62_) {
		ValaSourceReference* _tmp67_ = NULL;
		ValaSemanticAnalyzer* _tmp68_ = NULL;
		ValaDataType* _tmp69_ = NULL;
		gchar* _tmp70_ = NULL;
		gchar* _tmp71_;
		gchar* _tmp72_ = NULL;
		gchar* _tmp73_;
		_tmp67_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp68_ = vala_code_context_get_analyzer (context);
		_tmp69_ = vala_semantic_analyzer_get_current_return_type (_tmp68_);
		_tmp70_ = vala_code_node_to_string ((ValaCodeNode*) _tmp69_);
		_tmp71_ = _tmp70_;
		_tmp72_ = g_strdup_printf ("`null' incompatible with return type `%s`", _tmp71_);
		_tmp73_ = _tmp72_;
		vala_report_warning (_tmp67_, _tmp73_);
		_g_free0 (_tmp73_);
		_g_free0 (_tmp71_);
	}
	_tmp74_ = vala_return_statement_get_return_expression (self);
	_tmp75_ = vala_code_node_get_error_types ((ValaCodeNode*) _tmp74_);
	_tmp76_ = _tmp75_;
	vala_code_node_add_error_types ((ValaCodeNode*) self, _tmp76_);
	_vala_iterable_unref0 (_tmp76_);
	_tmp77_ = vala_code_node_get_error ((ValaCodeNode*) self);
	result = !_tmp77_;
	_vala_code_node_unref0 (local);
	return result;
}


static void vala_return_statement_real_emit (ValaCodeNode* base, ValaCodeGenerator* codegen) {
	ValaReturnStatement * self;
	ValaExpression* _tmp0_ = NULL;
	self = (ValaReturnStatement*) base;
	g_return_if_fail (codegen != NULL);
	_tmp0_ = vala_return_statement_get_return_expression (self);
	if (_tmp0_ != NULL) {
		ValaExpression* _tmp1_ = NULL;
		ValaExpression* _tmp2_ = NULL;
		_tmp1_ = vala_return_statement_get_return_expression (self);
		vala_code_node_emit ((ValaCodeNode*) _tmp1_, codegen);
		_tmp2_ = vala_return_statement_get_return_expression (self);
		vala_code_visitor_visit_end_full_expression ((ValaCodeVisitor*) codegen, _tmp2_);
	}
	vala_code_visitor_visit_return_statement ((ValaCodeVisitor*) codegen, self);
}


static void vala_return_statement_real_get_defined_variables (ValaCodeNode* base, ValaCollection* collection) {
	ValaReturnStatement * self;
	ValaExpression* _tmp0_ = NULL;
	self = (ValaReturnStatement*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_return_statement_get_return_expression (self);
	if (_tmp0_ != NULL) {
		ValaExpression* _tmp1_ = NULL;
		_tmp1_ = vala_return_statement_get_return_expression (self);
		vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp1_, collection);
	}
}


static void vala_return_statement_real_get_used_variables (ValaCodeNode* base, ValaCollection* collection) {
	ValaReturnStatement * self;
	ValaExpression* _tmp0_ = NULL;
	self = (ValaReturnStatement*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_return_statement_get_return_expression (self);
	if (_tmp0_ != NULL) {
		ValaExpression* _tmp1_ = NULL;
		_tmp1_ = vala_return_statement_get_return_expression (self);
		vala_code_node_get_used_variables ((ValaCodeNode*) _tmp1_, collection);
	}
}


ValaExpression* vala_return_statement_get_return_expression (ValaReturnStatement* self) {
	ValaExpression* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_return_expression;
	return result;
}


void vala_return_statement_set_return_expression (ValaReturnStatement* self, ValaExpression* value) {
	ValaExpression* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_return_expression);
	self->priv->_return_expression = _tmp0_;
	if (self->priv->_return_expression != NULL) {
		vala_code_node_set_parent_node ((ValaCodeNode*) self->priv->_return_expression, (ValaCodeNode*) self);
	}
}


static void vala_return_statement_class_init (ValaReturnStatementClass * klass) {
	vala_return_statement_parent_class = g_type_class_peek_parent (klass);
	VALA_CODE_NODE_CLASS (klass)->finalize = vala_return_statement_finalize;
	g_type_class_add_private (klass, sizeof (ValaReturnStatementPrivate));
	VALA_CODE_NODE_CLASS (klass)->accept = vala_return_statement_real_accept;
	VALA_CODE_NODE_CLASS (klass)->accept_children = vala_return_statement_real_accept_children;
	VALA_CODE_NODE_CLASS (klass)->replace_expression = vala_return_statement_real_replace_expression;
	VALA_CODE_NODE_CLASS (klass)->check = vala_return_statement_real_check;
	VALA_CODE_NODE_CLASS (klass)->emit = vala_return_statement_real_emit;
	VALA_CODE_NODE_CLASS (klass)->get_defined_variables = vala_return_statement_real_get_defined_variables;
	VALA_CODE_NODE_CLASS (klass)->get_used_variables = vala_return_statement_real_get_used_variables;
}


static void vala_return_statement_vala_statement_interface_init (ValaStatementIface * iface) {
	vala_return_statement_vala_statement_parent_iface = g_type_interface_peek_parent (iface);
}


static void vala_return_statement_instance_init (ValaReturnStatement * self) {
	self->priv = VALA_RETURN_STATEMENT_GET_PRIVATE (self);
}


static void vala_return_statement_finalize (ValaCodeNode* obj) {
	ValaReturnStatement * self;
	self = VALA_RETURN_STATEMENT (obj);
	_vala_code_node_unref0 (self->priv->_return_expression);
	VALA_CODE_NODE_CLASS (vala_return_statement_parent_class)->finalize (obj);
}


/**
 * Represents a return statement in the source code.
 */
GType vala_return_statement_get_type (void) {
	static volatile gsize vala_return_statement_type_id__volatile = 0;
	if (g_once_init_enter (&vala_return_statement_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaReturnStatementClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_return_statement_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaReturnStatement), 0, (GInstanceInitFunc) vala_return_statement_instance_init, NULL };
		static const GInterfaceInfo vala_statement_info = { (GInterfaceInitFunc) vala_return_statement_vala_statement_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType vala_return_statement_type_id;
		vala_return_statement_type_id = g_type_register_static (VALA_TYPE_CODE_NODE, "ValaReturnStatement", &g_define_type_info, 0);
		g_type_add_interface_static (vala_return_statement_type_id, VALA_TYPE_STATEMENT, &vala_statement_info);
		g_once_init_leave (&vala_return_statement_type_id__volatile, vala_return_statement_type_id);
	}
	return vala_return_statement_type_id__volatile;
}



