/*---------------------------------------------------------------------------*\

    FILE....: MAPDEV.H
    TYPE....: C++ Header File
    AUTHOR..: John Kostogiannis
    DATE....: 26/11/97

    Header file for functions used to map the board and channel number to a 
	handle and vice-versa.


         Voicetronix Voice Processing Board (VPB) Software
         Copyright (C) 1999-2006 Voicetronix www.voicetronix.com.au

         This library is free software; you can redistribute it and/or
         modify it under the terms of the GNU Lesser General Public
         License as published by the Free Software Foundation; either
         version 2.1 of the License, or (at your option) any later version.

         This library is distributed in the hope that it will be useful,
         but WITHOUT ANY WARRANTY; without even the implied warranty of
         MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
         Lesser General Public License for more details.

         You should have received a copy of the GNU Lesser General Public
         License along with this library; if not, write to the Free Software
         Foundation, Inc., 51 Franklin St, Fifth Floor, Boston,
         MA  02110-1301  USA

\*---------------------------------------------------------------------------*/

#ifndef __MAPDEV__
#define __MAPDEV__

#include "vpbreg.h"

//! Return the vpb handle for a @a port on @a board.
int mapdevtohndle( unsigned int board, unsigned int port);

// Note this one returns unsigned shorts for historical reasons.
// it should just be an unsigned int also, but its a huge job to
// replace all occurrences of this one, so not today...  FIXME

//! Return the @a board and @a port for a vpb @a handle.
void maphndletodev(int handle, unsigned short *board, unsigned short *port);

int get_idx_from_ch(VPBREG *v, int ch);
int get_idx_from_ich(VPBREG *v, int ch);

#endif	/* #ifndef __MAPDEV__	*/

