/*---------------------------------------------------------------------------*\

	FUNCTION....: shift_vector()

	AUTHOR......: Bernard Giannetti
	DATE CREATED: 14/11/1995

        Left/right shifts each element of the source vector by k bits.
        Left shift	:	k <  0
        Right shift	:	k >= 0

\*---------------------------------------------------------------------------*/

#include "shift.h"

void shift_vector(int dest_vector[], int src_vector[],
			int k, int length)
/*	int	dest_vector[];	dest vector for scaled results	*/
/*	int	src_vector[];	source vector to be scaled	*/
/*	int	k		value to shift left or right by */
/*				k <  0 : shift left		*/
/*				k >= 0 : shift right		*/
/*	int	length;		length of the vector	 	*/
{
    int i;

    if (k >= 0) {	/* right-shift */
	    for (i = 0;i < length;i++)
    		dest_vector[i] = src_vector[i] >> k;
    }
    else {		/* left-shift */
	    for (i = 0;i < length;i++)
    		dest_vector[i] = src_vector[i] << (-1 * k);
    }
}

