"""
test_exploit.py

Copyright 2013 Andres Riancho

This file is part of w3af, http://w3af.org/ .

w3af is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation version 2 of the License.

w3af is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with w3af; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
"""
import os

from w3af.core.ui.tests.gui import GUI_TEST_ROOT_PATH
from w3af.core.ui.tests.wrappers.xpresser_unittest import XpresserUnittest


class TestExploitFromTemplate(XpresserUnittest):
    
    IMAGES = os.path.join(GUI_TEST_ROOT_PATH, 'exploit_from_template', 'images')
    
    URL = 'http://moth/w3af/audit/os_commanding/param_osc.php'
    DATA = 'param=/etc/passwd'
    VULN_PARAM = 'param'
    
    def setUp(self):
        super(TestExploitFromTemplate, self).setUp()
    
    def test_exploit(self):
        self.click('exploit_tab')
        
        self.click('add_new_vuln')
        self.find('add_new_vuln_title')
        
        # Shows combo box options
        self.sleep(0.5)
        self.type(['<Enter>',], False)
        self.click('os_commanding_combo')
        self.click('add')
        self.find('vuln_params_title')
        
        # Configure the vulnerable URL
        self.click('target_url')
        self.type(['<Home>'], False)
        for _ in xrange(20): self.type(['<Delete>'], False)
        self.type(self.URL, False)
        
        self.click('data')
        self.type(self.DATA, False)

        self.click('vulnerable_parameter')
        self.type(self.VULN_PARAM, False)
        
        self.click('store_in_kb')
        self.click('close')
        
        # Verify that the exploit works with the template
        self.right_click('os_commanding_exploit')
        self.click('exploit_all')
        
        self.find('multiple_exploit')
        self.sleep(1)
        self.click('ok')
        
        self.double_click('os_commanding_shell')
        
        self.find('shell_window_title')
        
        # Close the shell
        self.type(['<Alt>','<F4>'], False)
        