
/*@ axiomatic Factorial {
  @   logic integer factorial(integer n);
  @   axiom factorial_0: factorial(0) == 1;
  @   axiom factorial_succ:
  @     \forall integer n; n > 0 ==> factorial(n) == n * factorial(n-1);
  @ }
  @*/

/*@ lemma fact_bound: \forall integer n; 0 <= n <= 11 ==>
  @      1 <= factorial(n) <= 39916800;
  @*/

/*@ requires 0 <= n <= 12;
  @ decreases n;
  @ ensures \result == factorial(n);
  @*/
int fact(int n) {
  if (n == 0) return 1;
  return n * fact(n-1);
}
