
/** Reversing the elements of an array.
    Original idea by Francesco Bonnizzi <fbonizzi@hotmail.it>
*/

#pragma SeparationPolicy(none)

/*@ requires \valid(a);
  @ requires \valid(b);
  @ assigns(*a);
  @ assigns(*b);
  @ ensures *a == \old(*b);
  @ ensures *b == \old(*a);
  @*/
void swap(char *a, char *b) {
  const char tmp = *a;
  *a = *b;
  *b = tmp;
}

/*@ requires n >= 0;
  @ requires \valid(s+(0 .. n-1));
  @ decreases n;
  @ assigns s[0..(n-1)];
  @ ensures \forall integer i;
  @   0 <= i < n ==> \at(s[i], Pre) == \at(s[n-i-1], Post);
  @*/
void reverse(char *s, unsigned n) {
  if (n < 2) return;
  swap(s, s + (n - 1));
  reverse(s + 1, n - 2);
  //@ assert s[0] == \at(s[n-1], Pre);
  //@ assert s[n-1] == \at(s[0], Pre);
  //@ assert \forall integer i; 1 <= i < n-1 ==> s[i] == (s+1)[i-1] ;
}
