#!/bin/bash
#
# chkconfig: 345 95 95
# description: wulf2html starts a looping wulf2html program on a web \
#              server or monitor server that shares space to create one \
#              or more automatically updating web pages containing \
#              cluster or lan management.
#
# processname: wulf2html
# pidfile: /var/run/wulf2html.pid
# config: /etc/wulfware/wulf2html.conf
# data: /etc/wulfware/wulfhosts (can be more than one for multiple
#       LANs or clusters).

# source function library
. /etc/init.d/functions

RETVAL=0

start() {
	echo -n $"Starting wulf2html: "

	daemon /etc/wulfware/wulf2html.sh
	RETVAL=$?
	echo
	[ $RETVAL -eq 0 ] && touch /var/lock/subsys/wulf2html
}

stop() {
	echo -n $"Shutting down wulf2html: "
	killproc wulf2html
	killproc wulflogger
	RETVAL=$?
	echo
	[ $RETVAL -eq 0 ] && rm -f /var/lock/subsys/wulf2html
}

case "$1" in
  start)
	start
	;;
  stop)
	stop
	;;
  restart|reload)
	stop
	start
	;;
  condrestart)
	if [ -f /var/lock/subsys/wulf2html ]; then
	    stop
	    start
	fi
	;;
  status)
	status wulf2html
	RETVAL=$?
	;;
  *)
	echo $"Usage: $0 {start|stop|restart|condrestart|status}"
	exit 1
esac

exit $RETVAL
