/*
 * Copyright (c) 2006 Alvaro Lopes <alvieboy@alvie.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __AUTODETECT_H__
#define __AUTODETECT_H__

#include "config.h"
#include <glib.h>
#include <dlfcn.h>

#ifdef HAVE_PCIUTILS
#include <pci/pci.h>
#endif

#ifdef HAVE_USBUTILS
#include <usb.h>
#endif

enum device_type_t
{
    DEVICE_TYPE_NONE,
    DEVICE_TYPE_USB,
    DEVICE_TYPE_PCI
};

struct device_info
{
    gchar *device;
    gchar *device_description;
    gchar *error_reason;
};

struct known_device
{
    const gchar *description;
    const gchar *driver;
    /*
     We can fill device_description for USB devices,
     reading the ID directly from the card. Otherwise is
     NULL, so use the description field instead
     */
    enum device_type_t type;
    int vendor;
    int product;
    gboolean (*detect_device)( struct known_device *dev );

    /* This can be changed - depends on driver */

    struct device_info *info;
};

/*
 Prototypes
 */

GList *detect_devices();
void free_detected_devices( GList *l );

#endif
