/*
  Copyright (C) 2000-2007

  Code contributed by Greg Collecutt, Joseph Hope and the xmds-devel team

  This file is part of xmds.

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

/*
  $Id: xmds_integrate_rk9.h 1507 2007-08-15 09:47:34Z paultcochrane $
*/

/*! @file xmds_integrate_rk9.h
  @brief 

  More detailed explanation...
*/

#ifndef XMDS_INTEGRATE_RK9_H
#define XMDS_INTEGRATE_RK9_H

#include <xmds_integrate.h>

// *****************************************************************************
// *****************************************************************************
//                              xmdsIntegrateRK9
// *****************************************************************************
// *****************************************************************************

//! Class to integrate equations using the fourth order Runge-Kutta method
class xmdsIntegrateRK9 : public virtual xmdsIntegrate {

  public :

    //! Constructor of xmdsIntegrateRK9 object
    xmdsIntegrateRK9(
         const xmdsSimulation *const yourSimulation,
         const bool& yourVerboseMode);

  //! Destructor
  ~xmdsIntegrateRK9();

  //! Processes an element
  void processElement(
                      const Element *const yourElement);

  protected :

    //! Writes the function prototypes to outfile
    void writePrototypes(
       FILE *const outfile) const;

  //! Writes the routines to outfile
  void writeRoutines(
                     FILE *const outfile) const;

  //! Writes the single step code to outfile
  virtual void writeSingleStepCode(
                                   FILE *const outfile,
                                   const stepCaseEnum& stepCase) const = 0;
  private :

    //! Write the main integrate routine to file
    void writeMainIntegrateRoutine(
           FILE *const outfile) const;

  //! Write the routine to calculate the cross field to file
  void writeCalculateCrossFieldRoutine(
                                       FILE *const outfile) const;
};


#endif // XMDS_INTEGRATE_RK9_H
